/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.internal.rpm.createrepo.form.ImportRPMsPage;
import org.eclipse.linuxtools.internal.rpm.createrepo.form.MetadataPage;
import org.eclipse.linuxtools.internal.rpm.createrepo.listener.CreaterepoResourceChangeListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.ResourceUtil;

public class RepoFormEditor
extends FormEditor {
    public static final String EDITOR_ID = "org.eclipse.linuxtools.rpm.createrepo.repoEditor";
    private CreaterepoProject project;
    private TextEditor editor;
    private IResourceChangeListener resourceChangeListener;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        this.setPartName(file.getName());
        try {
            this.project = new CreaterepoProject(file.getProject(), file);
        }
        catch (CoreException e) {
            Activator.logError(Messages.RepoFormEditor_errorInitializingProject, e);
        }
        this.resourceChangeListener = new CreaterepoResourceChangeListener(this.project);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.doSave(monitor);
    }

    public void doSaveAs() {
        this.editor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void addPages() {
        this.createPage0();
        this.createPage1();
        this.createPage2();
    }

    void createPage0() {
        try {
            ImportRPMsPage composite = new ImportRPMsPage(this, this.project);
            this.addPage((IFormPage)composite);
        }
        catch (PartInitException e) {
            Activator.logError(Messages.RepoFormEditor_errorInitializingForm, e);
        }
    }

    void createPage1() {
        try {
            MetadataPage composite = new MetadataPage(this, this.project);
            this.addPage((IFormPage)composite);
        }
        catch (PartInitException e) {
            Activator.logError(Messages.RepoFormEditor_errorInitializingForm, e);
        }
    }

    void createPage2() {
        try {
            this.editor = new TextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            Activator.logError(Messages.RepoFormEditor_errorInitializingForm, e);
        }
    }
}

