/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.internal.statesystem.core.Activator;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.DoubleStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.IntegerStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.LongStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.NullStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.StringStateValue;

public abstract class TmfStateValue
implements ITmfStateValue {
    private static final int INT_CACHE_SIZE = 128;
    private static final int LONG_CACHE_SIZE = 128;
    private static final int DOUBLE_CACHE_SIZE = 128;
    private static final IntegerStateValue[] intCache = new IntegerStateValue[128];
    private static final LongStateValue[] longCache = new LongStateValue[128];
    private static final DoubleStateValue[] doubleCache = new DoubleStateValue[128];
    private static TmfStateValue nullValue = new NullStateValue();

    public static final TmfStateValue nullValue() {
        return nullValue;
    }

    public static TmfStateValue newValueInt(int intValue) {
        IntegerStateValue newValue;
        int offset = intValue & 0x7F;
        IntegerStateValue cached = intCache[offset];
        if (cached != null && cached.unboxInt() == intValue) {
            return cached;
        }
        TmfStateValue.intCache[offset] = newValue = new IntegerStateValue(intValue);
        return newValue;
    }

    public static TmfStateValue newValueLong(long longValue) {
        LongStateValue newValue;
        int offset = (int)longValue & 0x7F;
        LongStateValue cached = longCache[offset];
        if (cached != null && cached.unboxLong() == longValue) {
            return cached;
        }
        TmfStateValue.longCache[offset] = newValue = new LongStateValue(longValue);
        return newValue;
    }

    public static TmfStateValue newValueDouble(double value) {
        DoubleStateValue newValue;
        int offset = (int)Double.doubleToLongBits(value) & 0x7F;
        DoubleStateValue cached = doubleCache[offset];
        if (cached != null && Double.compare(cached.unboxDouble(), value) == 0) {
            return cached;
        }
        TmfStateValue.doubleCache[offset] = newValue = new DoubleStateValue(value);
        return newValue;
    }

    public static TmfStateValue newValueString(@Nullable String strValue) {
        if (strValue == null) {
            return TmfStateValue.nullValue();
        }
        char[] cArray = strValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isISOControl(c)) {
                Activator.getDefault().logError("Trying to use invalid string: " + strValue);
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        return new StringStateValue(strValue);
    }

    private String unboxErrMsg(String targetType) {
        return "Type " + this.getClass().getSimpleName() + " cannot be unboxed into a " + targetType + " value.";
    }

    @Override
    public int unboxInt() {
        throw new StateValueTypeException(this.unboxErrMsg("Int"));
    }

    @Override
    public long unboxLong() {
        throw new StateValueTypeException(this.unboxErrMsg("Long"));
    }

    @Override
    public double unboxDouble() {
        throw new StateValueTypeException(this.unboxErrMsg("Double"));
    }

    @Override
    public String unboxStr() {
        throw new StateValueTypeException(this.unboxErrMsg("String"));
    }
}

