/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlCondition {
    private final List<TmfXmlCondition> fConditions = new ArrayList<TmfXmlCondition>();
    private final ITmfXmlStateValue fStateValue;
    private final ConditionOperator fOperator;
    private final IXmlStateSystemContainer fContainer;

    public TmfXmlCondition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        this.fContainer = container;
        Element rootNode = node;
        List<Element> childElements = XmlUtils.getChildElements(rootNode);
        if (node.getNodeName().equals("if")) {
            if (childElements.isEmpty()) {
                throw new IllegalArgumentException("TmfXmlCondition constructor: IF node has no child element");
            }
            rootNode = childElements.get(0);
            childElements = XmlUtils.getChildElements(rootNode);
        }
        switch (rootNode.getNodeName()) {
            case "condition": {
                this.fOperator = ConditionOperator.NONE;
                Element stateValueElement = childElements.remove(childElements.size() - 1);
                if (childElements.size() == 1 && childElements.get(0).getNodeName().equals("field")) {
                    this.fStateValue = modelFactory.createStateValue(stateValueElement, this.fContainer, childElements.get(0).getAttribute("name"));
                    break;
                }
                ArrayList<ITmfXmlStateAttribute> attributes = new ArrayList<ITmfXmlStateAttribute>();
                for (Element element : childElements) {
                    if (!element.getNodeName().equals("stateAttribute")) {
                        throw new IllegalArgumentException("TmfXmlCondition: a condition either has a eventField element or a number of TmfXmlStateAttribute elements before the state value");
                    }
                    ITmfXmlStateAttribute attribute = modelFactory.createStateAttribute(element, this.fContainer);
                    attributes.add(attribute);
                }
                this.fStateValue = modelFactory.createStateValue(stateValueElement, this.fContainer, attributes);
                break;
            }
            case "not": {
                this.fOperator = ConditionOperator.NOT;
                this.fStateValue = null;
                this.fConditions.add(modelFactory.createCondition(childElements.get(0), this.fContainer));
                break;
            }
            case "and": {
                this.fOperator = ConditionOperator.AND;
                this.fStateValue = null;
                for (Element condition : childElements) {
                    this.fConditions.add(modelFactory.createCondition(condition, this.fContainer));
                }
                break;
            }
            case "or": {
                this.fOperator = ConditionOperator.OR;
                this.fStateValue = null;
                for (Element condition : childElements) {
                    this.fConditions.add(modelFactory.createCondition(condition, this.fContainer));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlCondition constructor: XML node is of the wrong type");
            }
        }
    }

    public boolean testForEvent(@NonNull ITmfEvent event) throws AttributeNotFoundException {
        ITmfStateSystem ss = this.fContainer.getStateSystem();
        if (this.fStateValue != null) {
            ITmfXmlStateValue filter = this.fStateValue;
            int quark = -1;
            for (ITmfXmlStateAttribute attribute : filter.getAttributes()) {
                quark = attribute.getAttributeQuark(event, quark);
                if (quark != -1) continue;
                throw new AttributeNotFoundException();
            }
            ITmfStateValue valueXML = filter.getValue(event);
            ITmfStateValue valueState = quark != -1 ? ss.queryOngoingState(quark) : filter.getEventFieldValue(event);
            return valueXML.equals(valueState);
        }
        if (!this.fConditions.isEmpty()) {
            switch (this.fOperator) {
                case AND: {
                    for (TmfXmlCondition childCondition : this.fConditions) {
                        if (childCondition.testForEvent(event)) continue;
                        return false;
                    }
                    return true;
                }
                case NONE: {
                    break;
                }
                case NOT: {
                    return !this.fConditions.get(0).testForEvent(event);
                }
                case OR: {
                    for (TmfXmlCondition childCondition : this.fConditions) {
                        if (!childCondition.testForEvent(event)) continue;
                        return true;
                    }
                    return false;
                }
            }
        } else {
            throw new IllegalStateException("TmfXmlCondition: the condition should be either a state value or be the result of a condition tree");
        }
        return true;
    }

    private static enum ConditionOperator {
        NONE,
        NOT,
        AND,
        OR;

    }
}

