/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model.readwrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlReadWriteStateValue
extends TmfXmlStateValue {
    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes) {
        this(modelFactory, node, container, attributes, null);
    }

    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, String eventField) {
        this(modelFactory, node, container, new ArrayList<ITmfXmlStateAttribute>(), eventField);
    }

    private TmfXmlReadWriteStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, String eventField) {
        super(modelFactory, node, container, attributes, eventField);
    }

    protected ITmfStateSystemBuilder getStateSystem() {
        return (ITmfStateSystemBuilder)super.getStateSystem();
    }

    @Override
    protected TmfXmlStateValue.TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        TmfXmlStateValueTypeReadWrite stateValueType = null;
        String type = node.getAttribute("type");
        String value = this.getSsContainer().getAttributeValue(node.getAttribute("value"));
        switch (type) {
            case "int": {
                TmfStateValue stateValue = TmfStateValue.newValueInt((int)Integer.parseInt(value));
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "long": {
                TmfStateValue stateValue = TmfStateValue.newValueLong((long)Long.parseLong(value));
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "string": {
                TmfStateValue stateValue = TmfStateValue.newValueString((String)value);
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "null": {
                TmfStateValue stateValue = TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "eventField": {
                stateValueType = new TmfXmlStateValueEventField(value);
                break;
            }
            case "eventName": {
                stateValueType = new TmfXmlStateValueEventName();
                break;
            }
            case "delete": {
                stateValueType = new TmfXmlStateValueDelete();
                break;
            }
            case "query": {
                List<Element> children = XmlUtils.getChildElements(node);
                ArrayList<ITmfXmlStateAttribute> childAttributes = new ArrayList<ITmfXmlStateAttribute>();
                for (Element child : children) {
                    ITmfXmlStateAttribute queryAttribute = modelFactory.createStateAttribute(child, this.getSsContainer());
                    childAttributes.add(queryAttribute);
                }
                stateValueType = new TmfXmlStateValueQuery(childAttributes);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("TmfXmlStateValue constructor: unexpected element %s for stateValue type", type));
            }
        }
        return stateValueType;
    }

    private class TmfXmlStateValueDelete
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueDelete() {
        }

        @Override
        public ITmfStateValue getValue(ITmfEvent event) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (!(ss instanceof ITmfStateSystemBuilder)) {
                throw new IllegalStateException("incrementValue should never be called when not building the state system");
            }
            ITmfStateSystemBuilder builder = ss;
            builder.removeAttribute(timestamp, quark);
        }
    }

    private class TmfXmlStateValueEventField
    extends TmfXmlStateValueTypeReadWrite {
        private final String fFieldName;

        public TmfXmlStateValueEventField(String field) {
            this.fFieldName = field;
        }

        @Override
        public ITmfStateValue getValue(ITmfEvent event) {
            if (event == null) {
                Activator.logWarning("XML State value: requested an event field, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfXmlReadWriteStateValue.this.getEventFieldValue(event, this.fFieldName);
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystem ss = TmfXmlReadWriteStateValue.this.getSsContainer().getStateSystem();
            ITmfStateValue incrementValue = this.getValue(event);
            switch (incrementValue.getType()) {
                case INTEGER: {
                    int increment = incrementValue.unboxInt();
                    int currentValue = ss.queryOngoingState(quark).unboxInt();
                    TmfStateValue value = TmfStateValue.newValueInt((int)(increment + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    break;
                }
                case LONG: {
                    long incrementLong = incrementValue.unboxLong();
                    long currentValue = ss.queryOngoingState(quark).unboxLong();
                    TmfStateValue value = TmfStateValue.newValueLong((long)(incrementLong + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    break;
                }
                default: {
                    Activator.logWarning(String.format("TmfXmlStateValue: The event field increment %s is not a number type but a %s", this.fFieldName, incrementValue.getType()));
                }
            }
        }
    }

    private class TmfXmlStateValueEventName
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueEventName() {
        }

        @Override
        public ITmfStateValue getValue(ITmfEvent event) {
            if (event == null) {
                Activator.logWarning("XML State value: request event name, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfStateValue.newValueString((String)event.getType().getName());
        }
    }

    private class TmfXmlStateValueQuery
    extends TmfXmlStateValueTypeReadWrite {
        private final List<ITmfXmlStateAttribute> fQueryValue;

        public TmfXmlStateValueQuery(List<ITmfXmlStateAttribute> childAttributes) {
            this.fQueryValue = childAttributes;
        }

        @Override
        public ITmfStateValue getValue(ITmfEvent event) throws AttributeNotFoundException {
            TmfStateValue value = TmfStateValue.nullValue();
            int quarkQuery = -1;
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            for (ITmfXmlStateAttribute attribute : this.fQueryValue) {
                quarkQuery = attribute.getAttributeQuark(event, quarkQuery);
                if (quarkQuery == -1) break;
            }
            if (quarkQuery != -1) {
                value = ss.queryOngoingState(quarkQuery);
            }
            return value;
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            ITmfStateValue incrementValue = this.getValue(event);
            switch (incrementValue.getType()) {
                case INTEGER: {
                    int increment = incrementValue.unboxInt();
                    int currentValue = ss.queryOngoingState(quark).unboxInt();
                    TmfStateValue value = TmfStateValue.newValueInt((int)(increment + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    break;
                }
                case LONG: {
                    long incrementLong = incrementValue.unboxLong();
                    long currentValue = ss.queryOngoingState(quark).unboxLong();
                    TmfStateValue value = TmfStateValue.newValueLong((long)(incrementLong + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    break;
                }
                default: {
                    Activator.logWarning("TmfXmlStateValue: The query result increment is not a number type");
                }
            }
        }
    }

    private class TmfXmlStateValueTmf
    extends TmfXmlStateValueTypeReadWrite {
        private final ITmfStateValue fValue;

        public TmfXmlStateValueTmf(ITmfStateValue value) {
            this.fValue = value;
        }

        @Override
        public ITmfStateValue getValue(ITmfEvent event) {
            return this.fValue;
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            switch (this.fValue.getType()) {
                case LONG: {
                    long incrementLong = this.fValue.unboxLong();
                    long currentValue = ss.queryOngoingState(quark).unboxLong();
                    TmfStateValue value = TmfStateValue.newValueLong((long)(incrementLong + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    return;
                }
                case INTEGER: {
                    int increment = this.fValue.unboxInt();
                    int currentValue = ss.queryOngoingState(quark).unboxInt();
                    TmfStateValue value = TmfStateValue.newValueInt((int)(increment + currentValue));
                    this.processValue(quark, timestamp, (ITmfStateValue)value);
                    break;
                }
                default: {
                    Activator.logWarning("TmfXmlStateValue: The increment value is not a number type");
                }
            }
        }
    }

    protected abstract class TmfXmlStateValueTypeReadWrite
    extends TmfXmlStateValue.TmfXmlStateValueBase {
        protected TmfXmlStateValueTypeReadWrite() {
            super(TmfXmlReadWriteStateValue.this);
        }

        @Override
        public final void handleEvent(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlReadWriteStateValue.this.isIncrement()) {
                this.incrementValue(event, quark, timestamp);
            } else {
                ITmfStateValue value = this.getValue(event);
                this.processValue(quark, timestamp, value);
            }
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
            switch (TmfXmlReadWriteStateValue.this.getStackType()) {
                case POP: {
                    TmfXmlReadWriteStateValue.this.getStateSystem().popAttribute(timestamp, quark);
                    break;
                }
                case PUSH: {
                    TmfXmlReadWriteStateValue.this.getStateSystem().pushAttribute(timestamp, value, quark);
                    break;
                }
                default: {
                    TmfXmlReadWriteStateValue.this.getStateSystem().modifyAttribute(timestamp, value, quark);
                }
            }
        }

        @Override
        protected void incrementValue(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            TmfXmlReadWriteStateValue.this.getStateSystem().incrementAttribute(timestamp, quark);
        }
    }
}

