/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import java.nio.ByteBuffer;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;

public final class TmfExperimentLocation
implements ITmfLocation {
    private final TmfLocationArray fLocation;

    public TmfExperimentLocation(TmfLocationArray locations) {
        this.fLocation = locations;
    }

    public TmfExperimentLocation(TmfExperimentLocation location) {
        this(location.getLocationInfo());
    }

    public String toString() {
        StringBuilder result = new StringBuilder("TmfExperimentLocation [");
        result.append(this.fLocation.toString());
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fLocation != null ? this.fLocation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfExperimentLocation other = (TmfExperimentLocation)obj;
        return !(this.fLocation == null ? other.fLocation != null : !this.fLocation.equals(other.fLocation));
    }

    public TmfLocationArray getLocationInfo() {
        return this.fLocation;
    }

    @Override
    public void serialize(ByteBuffer bufferOut) {
        ITmfLocation[] locations = this.fLocation.getLocations();
        long[] ranks = this.fLocation.getRanks();
        int i = 0;
        while (i < locations.length) {
            locations[i].serialize(bufferOut);
            bufferOut.putLong(ranks[i]);
            ++i;
        }
    }
}

