/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisParameterProvider;
import org.eclipse.linuxtools.tmf.core.analysis.Messages;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.osgi.util.NLS;

public abstract class TmfAbstractAnalysisModule
extends TmfComponent
implements IAnalysisModule {
    @NonNull
    private static final String UNDEFINED_ID = "undefined";
    private String fName;
    private String fId;
    private boolean fAutomatic = false;
    private boolean fStarted = false;
    private ITmfTrace fTrace;
    private final Map<String, Object> fParameters = new HashMap<String, Object>();
    private final List<String> fParameterNames = new ArrayList<String>();
    private final List<IAnalysisOutput> fOutputs = new ArrayList<IAnalysisOutput>();
    private List<IAnalysisParameterProvider> fParameterProviders = new ArrayList<IAnalysisParameterProvider>();
    private Job fJob = null;
    private final Object syncObj = new Object();
    private CountDownLatch fFinishedLatch = new CountDownLatch(0);
    private boolean fAnalysisCancelled = false;

    @Override
    public boolean isAutomatic() {
        return this.fAutomatic;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    @NonNull
    public String getId() {
        String id = this.fId;
        if (id == null) {
            Activator.logError("Analysis module getId(): the id should not be null in class " + this.getClass().getSimpleName());
            return UNDEFINED_ID;
        }
        return id;
    }

    @Override
    public void setAutomatic(boolean auto) {
        this.fAutomatic = auto;
    }

    @Override
    public void setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (trace == null) {
            throw new TmfAnalysisException(Messages.TmfAbstractAnalysisModule_NullTrace);
        }
        if (this.fTrace != null) {
            throw new TmfAnalysisException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_TraceSetMoreThanOnce, (Object)this.getName()));
        }
        if (!this.canExecute(trace)) {
            throw new TmfAnalysisException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisCannotExecute, (Object)this.getName()));
        }
        this.fTrace = trace;
        this.fParameterProviders = TmfAnalysisManager.getParameterProviders(this, this.fTrace);
        for (IAnalysisParameterProvider provider : this.fParameterProviders) {
            provider.registerModule(this);
        }
        this.resetAnalysis();
        this.fStarted = false;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public void addParameter(String name) {
        this.fParameterNames.add(name);
    }

    @Override
    public synchronized void setParameter(String name, Object value) {
        if (!this.fParameterNames.contains(name)) {
            throw new RuntimeException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_InvalidParameter, (Object)name, (Object)this.getName()));
        }
        Object oldValue = this.fParameters.get(name);
        this.fParameters.put(name, value);
        if (value != null && !value.equals(oldValue)) {
            this.parameterChanged(name);
        }
    }

    @Override
    public synchronized void notifyParameterChanged(String name) {
        if (!this.fParameterNames.contains(name)) {
            throw new RuntimeException(NLS.bind((String)Messages.TmfAbstractAnalysisModule_InvalidParameter, (Object)name, (Object)this.getName()));
        }
        Object oldValue = this.fParameters.get(name);
        Object value = this.getParameter(name);
        if (value != null && !value.equals(oldValue)) {
            this.parameterChanged(name);
        }
    }

    protected void parameterChanged(String name) {
    }

    @Override
    public Object getParameter(String name) {
        Object paramValue = this.fParameters.get(name);
        if (paramValue == null && this.fTrace != null) {
            for (IAnalysisParameterProvider provider : this.fParameterProviders) {
                paramValue = provider.getParameter(name);
                if (paramValue != null) break;
            }
        }
        return paramValue;
    }

    @Override
    public boolean canExecute(@NonNull ITmfTrace trace) {
        for (TmfAnalysisRequirement requirement : this.getAnalysisRequirements()) {
            if (requirement.isFulfilled(trace)) continue;
            return false;
        }
        return true;
    }

    protected void resetAnalysis() {
        this.fFinishedLatch.countDown();
        this.fFinishedLatch = new CountDownLatch(1);
    }

    protected abstract boolean executeAnalysis(IProgressMonitor var1) throws TmfAnalysisException;

    protected abstract void canceling();

    private void setAnalysisCompleted() {
        this.fStarted = false;
        this.fJob = null;
        this.fFinishedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.fJob != null && this.fJob.cancel()) {
                this.fAnalysisCancelled = true;
                this.setAnalysisCompleted();
            }
            this.fStarted = false;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final @NonNull ITmfTrace trace) {
        if (this.fFinishedLatch.getCount() == 0L) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.fStarted) {
                return;
            }
            this.fStarted = true;
        }
        this.fJob = new Job(NLS.bind((String)Messages.TmfAbstractAnalysisModule_RunningAnalysis, (Object)this.getName())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block15: {
                    try {
                        try {
                            monitor.beginTask("", -1);
                            TmfAbstractAnalysisModule.this.broadcast(new TmfStartAnalysisSignal((Object)TmfAbstractAnalysisModule.this, TmfAbstractAnalysisModule.this));
                            TmfAbstractAnalysisModule.this.fAnalysisCancelled = !TmfAbstractAnalysisModule.this.executeAnalysis(monitor);
                        }
                        catch (TmfAnalysisException e) {
                            Activator.logError("Error executing analysis with trace " + TmfAbstractAnalysisModule.this.getTrace().getName(), e);
                            Object object = TmfAbstractAnalysisModule.this.syncObj;
                            synchronized (object) {
                                monitor.done();
                                TmfAbstractAnalysisModule.this.setAnalysisCompleted();
                            }
                            TmfTraceManager.refreshSupplementaryFiles(trace);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = TmfAbstractAnalysisModule.this.syncObj;
                        synchronized (object) {
                            monitor.done();
                            TmfAbstractAnalysisModule.this.setAnalysisCompleted();
                        }
                        TmfTraceManager.refreshSupplementaryFiles(trace);
                        throw throwable;
                    }
                    Object object = TmfAbstractAnalysisModule.this.syncObj;
                    synchronized (object) {
                        monitor.done();
                        TmfAbstractAnalysisModule.this.setAnalysisCompleted();
                    }
                    TmfTraceManager.refreshSupplementaryFiles(trace);
                }
                if (!TmfAbstractAnalysisModule.this.fAnalysisCancelled) {
                    return Status.OK_STATUS;
                }
                TmfAbstractAnalysisModule.this.resetAnalysis();
                return Status.CANCEL_STATUS;
            }

            protected void canceling() {
                TmfAbstractAnalysisModule.this.canceling();
            }
        };
        this.fJob.schedule();
    }

    @Override
    public IStatus schedule() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return new Status(4, "org.eclipse.linuxtools.tmf.core", String.format("No trace specified for analysis %s", this.getName()));
        }
        this.execute(trace);
        return Status.OK_STATUS;
    }

    @Override
    public Iterable<IAnalysisOutput> getOutputs() {
        return this.fOutputs;
    }

    @Override
    public void registerOutput(IAnalysisOutput output) {
        if (!this.fOutputs.contains(output)) {
            this.fOutputs.add(output);
        }
    }

    @Override
    public boolean waitForCompletion() {
        try {
            this.fFinishedLatch.await();
        }
        catch (InterruptedException e) {
            Activator.logError("Error while waiting for module completion", e);
        }
        return !this.fAnalysisCancelled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForCompletion(IProgressMonitor monitor) {
        try {
            while (!this.fFinishedLatch.await(500L, TimeUnit.MILLISECONDS)) {
                if (!this.fAnalysisCancelled && !monitor.isCanceled()) continue;
                this.fAnalysisCancelled = true;
                return false;
            }
        }
        catch (InterruptedException e) {
            Activator.logError("Error while waiting for module completion", e);
        }
        if (!this.fAnalysisCancelled) return true;
        return false;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.cancel();
            this.fTrace = null;
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            for (IAnalysisParameterProvider provider : this.fParameterProviders) {
                provider.registerModule(this);
            }
        }
    }

    protected String getFullHelpText() {
        return NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisModule, (Object)this.getName());
    }

    protected String getShortHelpText(ITmfTrace trace) {
        return NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisForTrace, (Object)this.getName(), (Object)trace.getName());
    }

    protected String getTraceCannotExecuteHelpText(@NonNull ITmfTrace trace) {
        StringBuilder builder = new StringBuilder();
        builder.append(NLS.bind((String)Messages.TmfAbstractAnalysisModule_AnalysisCannotExecute, (Object)this.getName()));
        for (TmfAnalysisRequirement requirement : this.getAnalysisRequirements()) {
            if (requirement.isFulfilled(trace)) continue;
            builder.append("\n\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementNotFulfilled, (Object)requirement.getType()));
            builder.append("\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementMandatoryValues, requirement.getValues(TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY)));
            Set<String> information = requirement.getInformation();
            if (information.isEmpty()) continue;
            builder.append("\n");
            builder.append(NLS.bind((String)Messages.TmfAnalysis_RequirementInformation, information));
        }
        return builder.toString();
    }

    @Override
    public String getHelpText() {
        return this.getFullHelpText();
    }

    @Override
    public String getHelpText(ITmfTrace trace) {
        if (trace == null) {
            return this.getHelpText();
        }
        String text = this.getShortHelpText(trace);
        if (!this.canExecute(trace)) {
            text = String.valueOf(text) + "\n\n" + this.getTraceCannotExecuteHelpText(trace);
        }
        return text;
    }

    @Override
    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }
}

