/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterAndNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "AND";
    public static final String NOT_ATTR = "not";
    private boolean fNot = false;

    public TmfFilterAndNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            if (!node.matches(event)) {
                return this.fNot;
            }
            ++n2;
        }
        return true ^ this.fNot;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fNot) {
            buf.append("not ");
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString());
            if (i < this.getChildrenCount() - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append(" )");
        }
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fNot ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfFilterAndNode other = (TmfFilterAndNode)obj;
        return this.fNot == other.fNot;
    }
}

