/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;

public class TmfFilterCompareNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "COMPARE";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String RESULT_ATTR = "result";
    public static final String TYPE_ATTR = "type";
    public static final String VALUE_ATTR = "value";
    private boolean fNot = false;
    private String fField;
    private int fResult;
    private Type fType = Type.NUM;
    private String fValue;
    private transient Number fValueNumber;
    private transient TmfTimestamp fValueTimestamp;

    public TmfFilterCompareNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public int getResult() {
        return this.fResult;
    }

    public void setResult(int result) {
        this.fResult = result;
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
        this.setValue(this.fValue);
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fValueNumber = null;
        this.fValueTimestamp = null;
        if (value == null) {
            return;
        }
        if (this.fType == Type.NUM) {
            try {
                this.fValueNumber = NumberFormat.getInstance().parse(value).doubleValue();
            }
            catch (ParseException parseException) {}
        } else if (this.fType == Type.TIMESTAMP) {
            try {
                this.fValueTimestamp = new TmfTimestamp((long)(1.0E9 * NumberFormat.getInstance().parse(value.toString()).doubleValue()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        Object value = this.getFieldValue(event, this.fField);
        if (value == null) {
            return this.fNot;
        }
        if (this.fType == Type.NUM) {
            if (this.fValueNumber != null) {
                if (value instanceof Number) {
                    double valueDouble = ((Number)value).doubleValue();
                    return Double.compare(valueDouble, this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
                try {
                    double valueDouble = NumberFormat.getInstance().parse(value.toString()).doubleValue();
                    return Double.compare(valueDouble, this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
                catch (ParseException valueDouble) {}
            }
        } else {
            if (this.fType == Type.ALPHA) {
                String valueString = value.toString();
                int comp = valueString.compareTo(this.fValue.toString());
                if (comp < -1) {
                    comp = -1;
                } else if (comp > 1) {
                    comp = 1;
                }
                return comp == this.fResult ^ this.fNot;
            }
            if (this.fType == Type.TIMESTAMP && this.fValueTimestamp != null) {
                if (value instanceof TmfTimestamp) {
                    TmfTimestamp valueTimestamp = (TmfTimestamp)value;
                    return valueTimestamp.compareTo(this.fValueTimestamp, false) == this.fResult ^ this.fNot;
                }
                try {
                    TmfTimestamp valueTimestamp = new TmfTimestamp((long)(1.0E9 * NumberFormat.getInstance().parse(value.toString()).doubleValue()));
                    return valueTimestamp.compareTo(this.fValueTimestamp, false) == this.fResult ^ this.fNot;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return this.fNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        String open;
        String result;
        String string = this.fResult == 0 ? "= " : (result = this.fResult < 0 ? "< " : "> ");
        String string2 = this.fType == Type.NUM ? "" : (open = this.fType == Type.ALPHA ? "\"" : "[");
        String close = this.fType == Type.NUM ? "" : (this.fType == Type.ALPHA ? "\"" : "]");
        return String.valueOf(this.fField) + (this.fNot ? " not " : " ") + result + open + this.fValue + close;
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterCompareNode clone = (TmfFilterCompareNode)super.clone();
        clone.fField = this.fField;
        clone.setValue(this.fValue);
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fField == null ? 0 : this.fField.hashCode());
        result = 31 * result + (this.fNot ? 1231 : 1237);
        result = 31 * result + this.fResult;
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfFilterCompareNode other = (TmfFilterCompareNode)obj;
        if (this.fField == null ? other.fField != null : !this.fField.equals(other.fField)) {
            return false;
        }
        if (this.fNot != other.fNot) {
            return false;
        }
        if (this.fResult != other.fResult) {
            return false;
        }
        if (this.fType != other.fType) {
            return false;
        }
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }

    public static enum Type {
        NUM,
        ALPHA,
        TIMESTAMP;

    }
}

