/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterEqualsNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "EQUALS";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String VALUE_ATTR = "value";
    public static final String IGNORECASE_ATTR = "ignorecase";
    private boolean fNot = false;
    private String fField;
    private String fValue;
    private boolean fIgnoreCase = false;

    public TmfFilterEqualsNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public boolean isIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        Object value = this.getFieldValue(event, this.fField);
        if (value == null) {
            return this.fNot;
        }
        String valueString = value.toString();
        if (valueString == null) {
            return this.fNot;
        }
        if (this.fIgnoreCase) {
            return valueString.equalsIgnoreCase(this.fValue) ^ this.fNot;
        }
        return valueString.equals(this.fValue) ^ this.fNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        return String.valueOf(this.fField) + (this.fNot ? " not" : "") + " equals \"" + this.fValue + "\"";
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterEqualsNode clone = (TmfFilterEqualsNode)super.clone();
        clone.fField = this.fField;
        clone.fValue = this.fValue;
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fField == null ? 0 : this.fField.hashCode());
        result = 31 * result + (this.fIgnoreCase ? 1231 : 1237);
        result = 31 * result + (this.fNot ? 1231 : 1237);
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfFilterEqualsNode other = (TmfFilterEqualsNode)obj;
        if (this.fField == null ? other.fField != null : !this.fField.equals(other.fField)) {
            return false;
        }
        if (this.fIgnoreCase != other.fIgnoreCase) {
            return false;
        }
        if (this.fNot != other.fNot) {
            return false;
        }
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }
}

