/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterEventTypeNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "EVENTTYPE";
    public static final String TYPE_ATTR = "type";
    public static final String NAME_ATTR = "name";
    private String fType;
    private String fName;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfFilterEventTypeNode other = (TmfFilterEventTypeNode)obj;
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        return !(this.fType == null ? other.fType != null : !this.fType.equals(other.fType));
    }

    public TmfFilterEventTypeNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    public String getEventType() {
        return this.fType;
    }

    public void setEventType(String type) {
        this.fType = type;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        boolean match = false;
        if (this.fType.contains(":")) {
            if (this.fType.startsWith(event.getClass().getCanonicalName()) && this.fType.endsWith(event.getType().getName())) {
                match = true;
            }
        } else if (event.getClass().getCanonicalName().equals(this.fType)) {
            match = true;
        }
        if (match) {
            ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
            int n = iTmfFilterTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
                if (!node.matches(event)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getValidChildren() {
        if (this.getChildrenCount() == 0) {
            return super.getValidChildren();
        }
        return new ArrayList<String>(0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("EventType is " + this.fName);
        if (this.getChildrenCount() > 0) {
            buf.append(" and ");
        }
        if (this.getChildrenCount() > 1) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString());
            if (i < this.getChildrenCount() - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        if (this.getChildrenCount() > 1) {
            buf.append(" )");
        }
        return buf.toString();
    }
}

