/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterMatchesNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "MATCHES";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String REGEX_ATTR = "regex";
    private boolean fNot = false;
    private String fField;
    private String fRegex;
    private transient Pattern fPattern;

    public TmfFilterMatchesNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public String getRegex() {
        return this.fRegex;
    }

    public void setRegex(String regex) {
        this.fRegex = regex;
        if (regex != null) {
            try {
                this.fPattern = Pattern.compile(regex, 32);
            }
            catch (PatternSyntaxException e) {
                this.fPattern = null;
            }
        }
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        if (this.fPattern == null) {
            return this.fNot;
        }
        Object value = this.getFieldValue(event, this.fField);
        if (value == null) {
            return this.fNot;
        }
        String valueString = value.toString();
        return this.fPattern.matcher(valueString).matches() ^ this.fNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        return String.valueOf(this.fField) + (this.fNot ? " not" : "") + " matches \"" + this.fRegex + "\"";
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterMatchesNode clone = (TmfFilterMatchesNode)super.clone();
        clone.fField = this.fField;
        clone.setRegex(this.fRegex);
        return clone;
    }

    public static String regexFix(String pattern) {
        String ret = pattern;
        if (ret.indexOf(".*") < 0 && ret.charAt(0) != '^' && ret.charAt(ret.length() - 1) != '$') {
            ret = ".*" + ret + ".*";
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fField == null ? 0 : this.fField.hashCode());
        result = 31 * result + (this.fNot ? 1231 : 1237);
        result = 31 * result + (this.fRegex == null ? 0 : this.fRegex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfFilterMatchesNode other = (TmfFilterMatchesNode)obj;
        if (this.fField == null ? other.fField != null : !this.fField.equals(other.fField)) {
            return false;
        }
        if (this.fNot != other.fNot) {
            return false;
        }
        return !(this.fRegex == null ? other.fRegex != null : !this.fRegex.equals(other.fRegex));
    }
}

