/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.parsers.custom;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.Messages;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CustomTxtTraceDefinition
extends CustomTraceDefinition {
    public List<InputLine> inputs;
    protected static final String CUSTOM_TXT_TRACE_DEFINITIONS_DEFAULT_FILE_NAME = "custom_txt_default_parsers.xml";
    protected static final String CUSTOM_TXT_TRACE_DEFINITIONS_FILE_NAME = "custom_txt_parsers.xml";
    protected static final String CUSTOM_TXT_TRACE_DEFINITIONS_DEFAULT_PATH_NAME = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "templates/org.eclipse.linuxtools.tmf.core/" + "custom_txt_default_parsers.xml";
    protected static final String CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append("custom_txt_parsers.xml").toString();
    private static final String CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME_LEGACY = Activator.getDefault().getStateLocation().removeLastSegments(1).addTrailingSeparator().append("org.eclipse.linuxtools.tmf.ui").append("custom_txt_parsers.xml").toString();
    private static final String CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT = Messages.CustomTxtTraceDefinition_definitionRootElement;
    private static final String DEFINITION_ELEMENT = Messages.CustomTxtTraceDefinition_definition;
    private static final String NAME_ATTRIBUTE = Messages.CustomTxtTraceDefinition_name;
    private static final String TIME_STAMP_OUTPUT_FORMAT_ELEMENT = Messages.CustomTxtTraceDefinition_timestampOutputFormat;
    private static final String INPUT_LINE_ELEMENT = Messages.CustomTxtTraceDefinition_inputLine;
    private static final String CARDINALITY_ELEMENT = Messages.CustomTxtTraceDefinition_cardinality;
    private static final String MIN_ATTRIBUTE = Messages.CustomTxtTraceDefinition_min;
    private static final String MAX_ATTRIBUTE = Messages.CustomTxtTraceDefinition_max;
    private static final String REGEX_ELEMENT = Messages.CustomTxtTraceDefinition_regEx;
    private static final String INPUT_DATA_ELEMENT = Messages.CustomTxtTraceDefinition_inputData;
    private static final String ACTION_ATTRIBUTE = Messages.CustomTxtTraceDefinition_action;
    private static final String FORMAT_ATTRIBUTE = Messages.CustomTxtTraceDefinition_format;
    private static final String OUTPUT_COLUMN_ELEMENT = Messages.CustomTxtTraceDefinition_outputColumn;

    public CustomTxtTraceDefinition() {
        this("", new ArrayList<InputLine>(0), new ArrayList<CustomTraceDefinition.OutputColumn>(0), "");
    }

    public CustomTxtTraceDefinition(String logtype, List<InputLine> inputs, List<CustomTraceDefinition.OutputColumn> outputs, String timeStampOutputFormat) {
        this.definitionName = logtype;
        this.inputs = inputs;
        this.outputs = outputs;
        this.timeStampOutputFormat = timeStampOutputFormat;
    }

    @Override
    public void save() {
        this.save(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME);
    }

    @Override
    public void save(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomTxtTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomTxtTraceDefinition.createErrorHandler());
            Document doc = null;
            File file = new File(path);
            if (file.canRead()) {
                doc = db.parse(file);
                if (!doc.getDocumentElement().getNodeName().equals(CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT)) {
                    return;
                }
            } else {
                doc = db.newDocument();
                Element node = doc.createElement(CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT);
                doc.appendChild(node);
            }
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && this.definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                    root.removeChild(node);
                }
                ++i;
            }
            Element definitionElement = doc.createElement(DEFINITION_ELEMENT);
            root.appendChild(definitionElement);
            definitionElement.setAttribute(NAME_ATTRIBUTE, this.definitionName);
            Element formatElement = doc.createElement(TIME_STAMP_OUTPUT_FORMAT_ELEMENT);
            definitionElement.appendChild(formatElement);
            formatElement.appendChild(doc.createTextNode(this.timeStampOutputFormat));
            if (this.inputs != null) {
                for (InputLine inputLine : this.inputs) {
                    definitionElement.appendChild(this.createInputLineElement(inputLine, doc));
                }
            }
            if (this.outputs != null) {
                for (CustomTraceDefinition.OutputColumn output : this.outputs) {
                    Element outputColumnElement = doc.createElement(OUTPUT_COLUMN_ELEMENT);
                    definitionElement.appendChild(outputColumnElement);
                    outputColumnElement.setAttribute(NAME_ATTRIBUTE, output.name);
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            Throwable throwable = null;
            Object var15_23 = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.write(xmlString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            TmfTraceType.addCustomTraceType("Custom Text", this.definitionName);
        }
        catch (ParserConfigurationException e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (TransformerConfigurationException e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (TransformerException e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (IOException e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (SAXException e) {
            Activator.logError("Error saving CustomTxtTraceDefinition: path=" + path, e);
        }
    }

    private Element createInputLineElement(InputLine inputLine, Document doc) {
        Element inputLineElement = doc.createElement(INPUT_LINE_ELEMENT);
        Element cardinalityElement = doc.createElement(CARDINALITY_ELEMENT);
        inputLineElement.appendChild(cardinalityElement);
        cardinalityElement.setAttribute(MIN_ATTRIBUTE, Integer.toString(inputLine.cardinality.min));
        cardinalityElement.setAttribute(MAX_ATTRIBUTE, Integer.toString(inputLine.cardinality.max));
        Element regexElement = doc.createElement(REGEX_ELEMENT);
        inputLineElement.appendChild(regexElement);
        regexElement.appendChild(doc.createTextNode(inputLine.regex));
        if (inputLine.columns != null) {
            for (InputData inputData : inputLine.columns) {
                Element inputDataElement = doc.createElement(INPUT_DATA_ELEMENT);
                inputLineElement.appendChild(inputDataElement);
                inputDataElement.setAttribute(NAME_ATTRIBUTE, inputData.name);
                inputDataElement.setAttribute(ACTION_ATTRIBUTE, Integer.toString(inputData.action));
                if (inputData.format == null) continue;
                inputDataElement.setAttribute(FORMAT_ATTRIBUTE, inputData.format);
            }
        }
        if (inputLine.childrenInputs != null) {
            for (InputLine childInputLine : inputLine.childrenInputs) {
                inputLineElement.appendChild(this.createInputLineElement(childInputLine, doc));
            }
        }
        return inputLineElement;
    }

    public static CustomTxtTraceDefinition[] loadAll() {
        File defaultFile = new File(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME);
        File legacyFile = new File(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME_LEGACY);
        if (!defaultFile.exists() && legacyFile.exists()) {
            CustomTxtTraceDefinition[] oldDefs;
            CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = oldDefs = CustomTxtTraceDefinition.loadAll(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME_LEGACY);
            int n = oldDefs.length;
            int n2 = 0;
            while (n2 < n) {
                CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
                def.save();
                ++n2;
            }
        }
        TreeSet<CustomTxtTraceDefinition> defs = new TreeSet<CustomTxtTraceDefinition>(new Comparator<CustomTxtTraceDefinition>(){

            @Override
            public int compare(CustomTxtTraceDefinition o1, CustomTxtTraceDefinition o2) {
                return o1.definitionName.compareTo(o2.definitionName);
            }
        });
        defs.addAll(Arrays.asList(CustomTxtTraceDefinition.loadAll(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME)));
        defs.addAll(Arrays.asList(CustomTxtTraceDefinition.loadAll(CUSTOM_TXT_TRACE_DEFINITIONS_DEFAULT_PATH_NAME)));
        return defs.toArray(new CustomTxtTraceDefinition[0]);
    }

    public static CustomTxtTraceDefinition[] loadAll(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomTxtTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomTxtTraceDefinition.createErrorHandler());
            File file = new File(path);
            if (!file.canRead()) {
                return new CustomTxtTraceDefinition[0];
            }
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return new CustomTxtTraceDefinition[0];
            }
            ArrayList<CustomTxtTraceDefinition> defList = new ArrayList<CustomTxtTraceDefinition>();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                CustomTxtTraceDefinition def;
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && (def = CustomTxtTraceDefinition.extractDefinition((Element)node)) != null) {
                    defList.add(def);
                }
                ++i;
            }
            return defList.toArray(new CustomTxtTraceDefinition[0]);
        }
        catch (ParserConfigurationException e) {
            Activator.logError("Error loading all in CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (SAXException e) {
            Activator.logError("Error loading all in CustomTxtTraceDefinition: path=" + path, e);
        }
        catch (IOException e) {
            Activator.logError("Error loading all in CustomTxtTraceDefinition: path=" + path, e);
        }
        return new CustomTxtTraceDefinition[0];
    }

    public static CustomTxtTraceDefinition load(String definitionName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomTxtTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomTxtTraceDefinition.createErrorHandler());
            CustomTxtTraceDefinition value = CustomTxtTraceDefinition.lookupDefinition(definitionName, db, CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME);
            if (value == null) {
                return CustomTxtTraceDefinition.lookupDefinition(definitionName, db, CUSTOM_TXT_TRACE_DEFINITIONS_DEFAULT_PATH_NAME);
            }
            return value;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error loading CustomTxtTraceDefinition: definitionName=" + definitionName, e);
            return null;
        }
    }

    private static CustomTxtTraceDefinition lookupDefinition(String definitionName, DocumentBuilder db, String source) throws SAXException, IOException {
        File file = new File(source);
        if (!file.exists()) {
            return null;
        }
        Document doc = db.parse(file);
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals(CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT)) {
            return null;
        }
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                return CustomTxtTraceDefinition.extractDefinition((Element)node);
            }
            ++i;
        }
        return null;
    }

    public static CustomTxtTraceDefinition extractDefinition(Element definitionElement) {
        CustomTxtTraceDefinition def = new CustomTxtTraceDefinition();
        def.definitionName = definitionElement.getAttribute(NAME_ATTRIBUTE);
        if (def.definitionName == null) {
            return null;
        }
        NodeList nodeList = definitionElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(TIME_STAMP_OUTPUT_FORMAT_ELEMENT)) {
                Element formatElement = (Element)node;
                def.timeStampOutputFormat = formatElement.getTextContent();
            } else if (nodeName.equals(INPUT_LINE_ELEMENT)) {
                InputLine inputLine = CustomTxtTraceDefinition.extractInputLine((Element)node);
                if (inputLine != null) {
                    def.inputs.add(inputLine);
                }
            } else if (nodeName.equals(OUTPUT_COLUMN_ELEMENT)) {
                Element outputColumnElement = (Element)node;
                CustomTraceDefinition.OutputColumn outputColumn = new CustomTraceDefinition.OutputColumn();
                outputColumn.name = outputColumnElement.getAttribute(NAME_ATTRIBUTE);
                def.outputs.add(outputColumn);
            }
            ++i;
        }
        return def;
    }

    private static InputLine extractInputLine(Element inputLineElement) {
        InputLine inputLine = new InputLine();
        NodeList nodeList = inputLineElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element childInputLineElement;
            InputLine childInputLine;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(CARDINALITY_ELEMENT)) {
                Element cardinalityElement = (Element)node;
                try {
                    int min = Integer.parseInt(cardinalityElement.getAttribute(MIN_ATTRIBUTE));
                    int max = Integer.parseInt(cardinalityElement.getAttribute(MAX_ATTRIBUTE));
                    inputLine.cardinality = new Cardinality(min, max);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else if (nodeName.equals(REGEX_ELEMENT)) {
                Element regexElement = (Element)node;
                inputLine.regex = regexElement.getTextContent();
            } else if (nodeName.equals(INPUT_DATA_ELEMENT)) {
                Element inputDataElement = (Element)node;
                InputData inputData = new InputData();
                inputData.name = inputDataElement.getAttribute(NAME_ATTRIBUTE);
                inputData.action = Integer.parseInt(inputDataElement.getAttribute(ACTION_ATTRIBUTE));
                inputData.format = inputDataElement.getAttribute(FORMAT_ATTRIBUTE);
                inputLine.addColumn(inputData);
            } else if (nodeName.equals(INPUT_LINE_ELEMENT) && (childInputLine = CustomTxtTraceDefinition.extractInputLine(childInputLineElement = (Element)node)) != null) {
                inputLine.addChild(childInputLine);
            }
            ++i;
        }
        return inputLine;
    }

    public static void delete(String definitionName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomTxtTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomTxtTraceDefinition.createErrorHandler());
            File file = new File(CUSTOM_TXT_TRACE_DEFINITIONS_PATH_NAME);
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_TXT_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return;
            }
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                    root.removeChild(node);
                }
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            Throwable throwable = null;
            Object var12_15 = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.write(xmlString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            TmfTraceType.removeCustomTraceType("Custom Text", definitionName);
            TmfTraceType.addCustomTraceType("Custom Text", definitionName);
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            Activator.logError("Error deleting CustomTxtTraceDefinition: definitionName=" + definitionName, e);
        }
    }

    public static class Cardinality {
        public static final int INF = Integer.MAX_VALUE;
        public static final Cardinality ONE = new Cardinality(1, 1);
        public static final Cardinality ONE_OR_MORE = new Cardinality(1, Integer.MAX_VALUE);
        public static final Cardinality ZERO_OR_ONE = new Cardinality(0, 1);
        public static final Cardinality ZERO_OR_MORE = new Cardinality(0, Integer.MAX_VALUE);
        private final int min;
        private final int max;

        public Cardinality(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "(" + (this.min >= 0 ? Integer.valueOf(this.min) : "?") + ',' + (this.max == Integer.MAX_VALUE ? "\u221e" : (this.max >= 0 ? Integer.valueOf(this.max) : "?")) + ')';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.max;
            result = 31 * result + this.min;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Cardinality)) {
                return false;
            }
            Cardinality other = (Cardinality)obj;
            return this.min == other.min && this.max == other.max;
        }
    }

    public static class InputData {
        public String name;
        public int action;
        public String format;

        public InputData() {
        }

        public InputData(String name, int action, String format) {
            this.name = name;
            this.action = action;
            this.format = format;
        }

        public InputData(String name, int action) {
            this.name = name;
            this.action = action;
        }
    }

    public static class InputLine {
        public List<InputData> columns;
        public Cardinality cardinality;
        public InputLine parentInput;
        public int level;
        public InputLine nextInput;
        public List<InputLine> childrenInputs;
        private String regex;
        private Pattern pattern;

        public InputLine() {
        }

        public InputLine(Cardinality cardinality, String regex, List<InputData> columns) {
            this.cardinality = cardinality;
            this.regex = regex;
            this.columns = columns;
        }

        public void setRegex(String regex) {
            this.regex = regex;
            this.pattern = null;
        }

        public String getRegex() {
            return this.regex;
        }

        public Pattern getPattern() throws PatternSyntaxException {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
            return this.pattern;
        }

        public void addChild(InputLine input) {
            if (this.childrenInputs == null) {
                this.childrenInputs = new ArrayList<InputLine>(1);
            } else if (this.childrenInputs.size() > 0) {
                InputLine last = this.childrenInputs.get(this.childrenInputs.size() - 1);
                last.nextInput = input;
            }
            this.childrenInputs.add(input);
            input.parentInput = this;
            input.level = this.level + 1;
        }

        public void addNext(InputLine input) {
            if (this.parentInput != null) {
                int index = this.parentInput.childrenInputs.indexOf(this);
                this.parentInput.childrenInputs.add(index + 1, input);
                InputLine next = this.nextInput;
                this.nextInput = input;
                input.nextInput = next;
            }
            input.parentInput = this.parentInput;
            input.level = this.level;
        }

        public void moveUp() {
            int index;
            if (this.parentInput != null && (index = this.parentInput.childrenInputs.indexOf(this)) > 0) {
                this.parentInput.childrenInputs.add(index - 1, this.parentInput.childrenInputs.remove(index));
                this.parentInput.childrenInputs.get((int)index).nextInput = this.nextInput;
                this.nextInput = this.parentInput.childrenInputs.get(index);
            }
        }

        public void moveDown() {
            int index;
            if (this.parentInput != null && (index = this.parentInput.childrenInputs.indexOf(this)) < this.parentInput.childrenInputs.size() - 1) {
                this.parentInput.childrenInputs.add(index + 1, this.parentInput.childrenInputs.remove(index));
                this.nextInput = this.parentInput.childrenInputs.get((int)index).nextInput;
                this.parentInput.childrenInputs.get((int)index).nextInput = this;
            }
        }

        public void addColumn(InputData column) {
            if (this.columns == null) {
                this.columns = new ArrayList<InputData>(1);
            }
            this.columns.add(column);
        }

        public List<InputLine> getNextInputs(Map<InputLine, Integer> countMap) {
            ArrayList<InputLine> nextInputs = new ArrayList<InputLine>();
            InputLine next = this.nextInput;
            while (next != null) {
                nextInputs.add(next);
                if (next.cardinality.min > 0) {
                    return nextInputs;
                }
                next = next.nextInput;
            }
            if (this.parentInput != null && this.parentInput.level > 0) {
                int parentCount = countMap.get(this.parentInput);
                if (parentCount < this.parentInput.getMaxCount()) {
                    nextInputs.add(this.parentInput);
                }
                if (parentCount < this.parentInput.getMinCount()) {
                    return nextInputs;
                }
                nextInputs.addAll(this.parentInput.getNextInputs(countMap));
            }
            return nextInputs;
        }

        public int getMinCount() {
            return this.cardinality.min;
        }

        public int getMaxCount() {
            return this.cardinality.max;
        }

        public String toString() {
            return String.valueOf(this.regex) + " " + this.cardinality;
        }
    }
}

