/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.synchronization;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.linuxtools.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.synchronization.Messages;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.linuxtools.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class SyncAlgorithmFullyIncremental
extends SynchronizationAlgorithm {
    private static final long serialVersionUID = -1782788842774838830L;
    private static final MathContext fMc = MathContext.DECIMAL128;
    private final List<ConvexHull> fSyncs = new LinkedList<ConvexHull>();

    @Override
    public void matchingEnded() {
        this.getStats();
    }

    @Override
    public void init(Collection<ITmfTrace> traces) {
        ITmfTrace[] traceArr = traces.toArray(new ITmfTrace[traces.size()]);
        this.fSyncs.clear();
        int i = 0;
        while (i < traceArr.length) {
            int j = i + 1;
            while (j < traceArr.length) {
                ConvexHull algo = new ConvexHull(traceArr[i].getHostId(), traceArr[j].getHostId());
                this.fSyncs.add(algo);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void processMatch(TmfEventDependency match) {
        String host2;
        String host1 = match.getSourceEvent().getTrace().getHostId();
        if (host1.equals(host2 = match.getDestinationEvent().getTrace().getHostId())) {
            return;
        }
        ConvexHull algo = null;
        for (ConvexHull traceSync : this.fSyncs) {
            if (!traceSync.isForHosts(host1, host2)) continue;
            algo = traceSync;
        }
        if (algo == null) {
            algo = new ConvexHull(host1, host2);
            this.fSyncs.add(algo);
        }
        algo.processMatch(match);
    }

    @Override
    public ITmfTimestampTransform getTimestampTransform(ITmfTrace trace) {
        return this.getTimestampTransform(trace.getHostId());
    }

    @Override
    public ITmfTimestampTransform getTimestampTransform(String hostId) {
        for (ConvexHull traceSync : this.fSyncs) {
            if (!traceSync.isTraceSynced(hostId)) continue;
            ITmfTimestampTransform refTt = this.getTimestampTransform(traceSync.getReferenceHost());
            return refTt.composeWith(traceSync.getTimestampTransform(hostId));
        }
        return TimestampTransformFactory.getDefaultTransform();
    }

    @Override
    public SynchronizationAlgorithm.SyncQuality getSynchronizationQuality(ITmfTrace trace1, ITmfTrace trace2) {
        for (ConvexHull traceSync : this.fSyncs) {
            if (!traceSync.isForHosts(trace1.getHostId(), trace2.getHostId())) continue;
            return traceSync.getQuality();
        }
        return SynchronizationAlgorithm.SyncQuality.ABSENT;
    }

    @Override
    public boolean isTraceSynced(String hostId) {
        boolean traceSynced = false;
        for (ConvexHull traceSync : this.fSyncs) {
            boolean bl = traceSynced = traceSynced || traceSync.isTraceSynced(hostId);
        }
        return traceSynced;
    }

    @Override
    public Map<String, Map<String, Object>> getStats() {
        LinkedHashMap<String, Map<String, Object>> statmap = new LinkedHashMap<String, Map<String, Object>>();
        for (ConvexHull traceSync : this.fSyncs) {
            statmap.put(String.valueOf(traceSync.getReferenceHost()) + " <==> " + traceSync.getOtherHost(), traceSync.getStats());
        }
        return statmap;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getClass().getSimpleName()) + " ");
        b.append(this.fSyncs);
        return b.toString();
    }

    private class ConvexHull
    implements Serializable {
        private static final long serialVersionUID = 8309351175030935291L;
        private final LinkedList<SyncPoint> fUpperBoundList = new LinkedList();
        private final LinkedList<SyncPoint> fLowerBoundList = new LinkedList();
        private final SyncPoint[] fLmax;
        private final SyncPoint[] fLmin;
        private BigDecimal fAlphamin;
        private BigDecimal fBetamax;
        private BigDecimal fAlphamax;
        private BigDecimal fBetamin;
        private BigDecimal fAlpha;
        private BigDecimal fBeta;
        private int fNbMatches;
        private int fNbAccurateMatches;
        private String fReferenceHost = "";
        private String fOtherHost = "";
        private SynchronizationAlgorithm.SyncQuality fQuality;
        private Map<String, Object> fStats = new LinkedHashMap<String, Object>();

        public ConvexHull(String host1, String host2) {
            if (host1.compareTo(host2) > 0) {
                this.fReferenceHost = host2;
                this.fOtherHost = host1;
            } else {
                this.fReferenceHost = host1;
                this.fOtherHost = host2;
            }
            this.fLmax = new SyncPoint[2];
            this.fLmin = new SyncPoint[2];
            this.fAlpha = BigDecimal.ONE;
            this.fAlphamax = BigDecimal.ONE;
            this.fAlphamin = BigDecimal.ONE;
            this.fBeta = BigDecimal.ZERO;
            this.fBetamax = BigDecimal.ZERO;
            this.fBetamin = BigDecimal.ZERO;
            this.fNbMatches = 0;
            this.fNbAccurateMatches = 0;
            this.fQuality = SynchronizationAlgorithm.SyncQuality.ABSENT;
        }

        protected void processMatch(TmfEventDependency match) {
            SyncPoint p;
            SyncPoint[] otherLine;
            SyncPoint[] line;
            LinkedList<SyncPoint> otherBoundList;
            LinkedList<SyncPoint> boundList;
            int inversionFactor = 1;
            boolean qualify = false;
            ++this.fNbMatches;
            if (match.getSourceEvent().getTrace().getHostId().compareTo(match.getDestinationEvent().getTrace().getHostId()) > 0) {
                boundList = this.fUpperBoundList;
                otherBoundList = this.fLowerBoundList;
                line = this.fLmin;
                otherLine = this.fLmax;
                p = new SyncPoint(match.getDestinationEvent(), match.getSourceEvent());
                inversionFactor = 1;
            } else {
                boundList = this.fLowerBoundList;
                otherBoundList = this.fUpperBoundList;
                line = this.fLmax;
                otherLine = this.fLmin;
                p = new SyncPoint(match.getSourceEvent(), match.getDestinationEvent());
                inversionFactor = -1;
            }
            if (line[0] == null || line[1] == null || p.crossProduct(line[0], line[1]) * (long)inversionFactor > 0L) {
                ++this.fNbAccurateMatches;
                qualify = true;
                this.removeUselessPoints(p, boundList, inversionFactor);
                line[1] = p;
                this.fStats.clear();
            }
            this.adjustBound(line, otherBoundList, inversionFactor);
            if (otherLine[1] != null && !boundList.contains(otherLine[0])) {
                this.adjustBound(otherLine, boundList, inversionFactor * -1);
            }
            if (qualify) {
                this.approximateSync();
            }
        }

        private void approximateSync() {
            if (this.fLmax[0] != null || this.fLmin[0] != null) {
                this.fAlphamax = this.fLmax[1].getAlpha(this.fLmax[0]);
                this.fBetamin = this.fLmax[1].getBeta(this.fAlphamax);
                this.fAlphamin = this.fLmin[1].getAlpha(this.fLmin[0]);
                this.fBetamax = this.fLmin[1].getBeta(this.fAlphamin);
                this.fAlpha = this.fAlphamax.add(this.fAlphamin).divide(BigDecimal.valueOf(2L), fMc);
                this.fBeta = this.fBetamin.add(this.fBetamax).divide(BigDecimal.valueOf(2L), fMc);
                this.fQuality = this.fLmax[0] == null || this.fLmin[0] == null ? SynchronizationAlgorithm.SyncQuality.APPROXIMATE : (this.fAlphamax.compareTo(this.fAlphamin) > 0 ? SynchronizationAlgorithm.SyncQuality.ACCURATE : SynchronizationAlgorithm.SyncQuality.FAIL);
            } else if (this.fLmax[0] == null && this.fLmin[1] == null || this.fLmax[1] == null && this.fLmin[0] == null) {
                this.fQuality = SynchronizationAlgorithm.SyncQuality.INCOMPLETE;
            }
        }

        private void adjustBound(SyncPoint[] line, LinkedList<SyncPoint> otherBoundList, int inversionFactor) {
            SyncPoint minPoint = null;
            boolean finishedSearch = false;
            int i = Math.max(0, otherBoundList.indexOf(line[0]));
            while (i < otherBoundList.size() - 1 && !finishedSearch) {
                SyncPoint nextPoint;
                minPoint = otherBoundList.get(i);
                if (minPoint.crossProduct(nextPoint = otherBoundList.get(i + 1), line[1]) * (long)inversionFactor > 0L) {
                    if (nextPoint.getTimeX() < line[1].getTimeX()) {
                        ++i;
                        continue;
                    }
                    line[0] = null;
                    finishedSearch = true;
                    continue;
                }
                line[0] = minPoint;
                finishedSearch = true;
            }
            if (line[0] == null) {
                line[0] = minPoint;
            }
            if (line[0] != null && line[0].getTimeX() > line[1].getTimeX()) {
                line[0] = null;
            }
        }

        private void removeUselessPoints(SyncPoint p, LinkedList<SyncPoint> boundList, int inversionFactor) {
            boolean checkRemove = true;
            while (checkRemove && boundList.size() >= 2) {
                if (p.crossProduct(boundList.get(boundList.size() - 2), boundList.getLast()) * (long)inversionFactor > 0L) {
                    boundList.removeLast();
                    continue;
                }
                checkRemove = false;
            }
            boundList.addLast(p);
        }

        public ITmfTimestampTransform getTimestampTransform(String hostId) {
            if (hostId.equals(this.fOtherHost) && (this.fQuality == SynchronizationAlgorithm.SyncQuality.ACCURATE || this.fQuality == SynchronizationAlgorithm.SyncQuality.APPROXIMATE || this.fQuality == SynchronizationAlgorithm.SyncQuality.FAIL)) {
                return TimestampTransformFactory.createLinear(BigDecimal.ONE.divide(this.fAlpha, fMc), BigDecimal.valueOf(-1L).multiply(this.fBeta).divide(this.fAlpha, fMc));
            }
            return TimestampTransformFactory.getDefaultTransform();
        }

        public SynchronizationAlgorithm.SyncQuality getQuality() {
            return this.fQuality;
        }

        public Map<String, Object> getStats() {
            if (this.fStats.size() == 0) {
                String syncQuality;
                switch (this.fQuality) {
                    case ABSENT: {
                        syncQuality = Messages.SyncAlgorithmFullyIncremental_absent;
                        break;
                    }
                    case ACCURATE: {
                        syncQuality = Messages.SyncAlgorithmFullyIncremental_accurate;
                        break;
                    }
                    case APPROXIMATE: {
                        syncQuality = Messages.SyncAlgorithmFullyIncremental_approx;
                        break;
                    }
                    case INCOMPLETE: {
                        syncQuality = Messages.SyncAlgorithmFullyIncremental_incomplete;
                        break;
                    }
                    default: {
                        syncQuality = Messages.SyncAlgorithmFullyIncremental_fail;
                    }
                }
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_refhost, this.fReferenceHost);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_otherhost, this.fOtherHost);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_quality, syncQuality);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_alpha, this.fAlpha);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_beta, this.fBeta);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_ub, this.fUpperBoundList.size() == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fUpperBoundList.size()));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_lb, this.fLowerBoundList.size() == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fLowerBoundList.size()));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_accuracy, this.fAlphamax.subtract(this.fAlphamin).doubleValue());
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_nbmatch, this.fNbMatches == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fNbMatches));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_nbacc, this.fNbAccurateMatches == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fNbAccurateMatches));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_refformula, String.valueOf(Messages.SyncAlgorithmFullyIncremental_T_) + this.fReferenceHost);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_otherformula, this.fAlpha + Messages.SyncAlgorithmFullyIncremental_mult + Messages.SyncAlgorithmFullyIncremental_T_ + this.fReferenceHost + Messages.SyncAlgorithmFullyIncremental_add + this.fBeta);
            }
            return this.fStats;
        }

        public String getReferenceHost() {
            return this.fReferenceHost;
        }

        public String getOtherHost() {
            return this.fOtherHost;
        }

        public boolean isTraceSynced(String hostId) {
            return hostId.equals(this.fOtherHost) && (this.fQuality == SynchronizationAlgorithm.SyncQuality.ACCURATE || this.fQuality == SynchronizationAlgorithm.SyncQuality.APPROXIMATE || this.fQuality == SynchronizationAlgorithm.SyncQuality.FAIL);
        }

        public boolean isForHosts(String hostId1, String hostId2) {
            return this.fReferenceHost.equals(hostId1) && this.fOtherHost.equals(hostId2) || this.fReferenceHost.equals(hostId2) && this.fOtherHost.equals(hostId1);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            this.fUpperBoundList.clear();
            this.fLowerBoundList.clear();
            this.fLmin[0] = null;
            this.fLmin[1] = null;
            this.fLmax[0] = null;
            this.fLmax[1] = null;
            s.defaultWriteObject();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Between " + this.fReferenceHost + " and " + this.fOtherHost + " [");
            b.append(" alpha " + this.fAlpha + " beta " + this.fBeta + " ]");
            return b.toString();
        }
    }

    private class SyncPoint {
        private final ITmfTimestamp x;
        private final ITmfTimestamp y;

        public SyncPoint(ITmfEvent ex, ITmfEvent ey) {
            this.x = ex.getTimestamp();
            this.y = ey.getTimestamp();
        }

        public long getTimeX() {
            return this.x.getValue();
        }

        public long crossProduct(SyncPoint pa, SyncPoint pb) {
            long cp = (pa.x.getValue() - this.x.getValue()) * (pb.y.getValue() - this.y.getValue()) - (pa.y.getValue() - this.y.getValue()) * (pb.x.getValue() - this.x.getValue());
            return cp;
        }

        public BigDecimal getAlpha(SyncPoint p1) {
            if (p1 == null) {
                return BigDecimal.ONE;
            }
            BigDecimal deltay = BigDecimal.valueOf(this.y.getValue() - p1.y.getValue());
            BigDecimal deltax = BigDecimal.valueOf(this.x.getValue() - p1.x.getValue());
            if (deltax.equals(BigDecimal.ZERO)) {
                return BigDecimal.ONE;
            }
            return deltay.divide(deltax, fMc);
        }

        public BigDecimal getBeta(BigDecimal alpha) {
            return BigDecimal.valueOf(this.y.getValue()).subtract(alpha.multiply(BigDecimal.valueOf(this.x.getValue()), fMc));
        }
    }
}

