/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.synchronization;

import java.math.BigDecimal;
import org.eclipse.linuxtools.internal.tmf.core.synchronization.TmfConstantTransform;
import org.eclipse.linuxtools.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.linuxtools.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.linuxtools.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;

public final class TimestampTransformFactory {
    private TimestampTransformFactory() {
    }

    public static ITmfTimestampTransform getDefaultTransform() {
        return TmfTimestampTransform.IDENTITY;
    }

    public static ITmfTimestampTransform createWithOffset(long offset) {
        if (offset == 0L) {
            return TmfTimestampTransform.IDENTITY;
        }
        return new TmfConstantTransform(offset);
    }

    public static ITmfTimestampTransform createWithOffset(ITmfTimestamp offset) {
        if (offset.getValue() == 0L) {
            return TmfTimestampTransform.IDENTITY;
        }
        return new TmfConstantTransform(offset);
    }

    public static ITmfTimestampTransform createLinear(double factor, ITmfTimestamp offset) {
        if (factor == 1.0) {
            return TimestampTransformFactory.createWithOffset(offset);
        }
        return new TmfTimestampTransformLinear(factor, offset.normalize(0L, -9).getValue());
    }

    public static ITmfTimestampTransform createLinear(double factor, long offset) {
        if (factor == 1.0) {
            return TimestampTransformFactory.createWithOffset(offset);
        }
        return new TmfTimestampTransformLinear(factor, offset);
    }

    public static ITmfTimestampTransform createLinear(BigDecimal factor, BigDecimal offset) {
        if (factor.equals(BigDecimal.ONE)) {
            return TimestampTransformFactory.createWithOffset(offset.longValueExact());
        }
        return new TmfTimestampTransformLinear(factor, offset);
    }
}

