/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;

final class TmfTraceContext {
    static final TmfTraceContext NULL_CONTEXT = new TmfTraceContext(TmfTimestamp.BIG_CRUNCH, TmfTimestamp.BIG_CRUNCH, TmfTimeRange.NULL_RANGE, null);
    private final TmfTimeRange fSelection;
    private final TmfTimeRange fWindowRange;
    private final IFile fEditorFile;
    private final ITmfFilter fFilter;

    public TmfTraceContext(ITmfTimestamp beginTs, ITmfTimestamp endTs, TmfTimeRange tr, IFile editorFile) {
        this.fSelection = new TmfTimeRange(beginTs, endTs);
        this.fWindowRange = tr;
        this.fEditorFile = editorFile;
        this.fFilter = null;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, ITmfTimestamp beginTs, ITmfTimestamp endTs) {
        this.fSelection = new TmfTimeRange(beginTs, endTs);
        this.fWindowRange = prevCtx.fWindowRange;
        this.fEditorFile = prevCtx.fEditorFile;
        this.fFilter = prevCtx.fFilter;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, TmfTimeRange tr) {
        this.fSelection = prevCtx.fSelection;
        this.fWindowRange = tr;
        this.fEditorFile = prevCtx.fEditorFile;
        this.fFilter = prevCtx.fFilter;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, ITmfFilter filter) {
        this.fSelection = prevCtx.fSelection;
        this.fWindowRange = prevCtx.fWindowRange;
        this.fEditorFile = prevCtx.fEditorFile;
        this.fFilter = filter;
    }

    public ITmfTimestamp getSelectionBegin() {
        return this.fSelection.getStartTime();
    }

    public ITmfTimestamp getSelectionEnd() {
        return this.fSelection.getEndTime();
    }

    public TmfTimeRange getWindowRange() {
        return this.fWindowRange;
    }

    public IFile getEditorFile() {
        return this.fEditorFile;
    }

    public ITmfFilter getFilter() {
        return this.fFilter;
    }

    public boolean isValid() {
        return this.fSelection.getStartTime().compareTo(TmfTimestamp.ZERO) > 0 && this.fSelection.getEndTime().compareTo(TmfTimestamp.ZERO) > 0 && this.fWindowRange.getEndTime().compareTo(this.fWindowRange.getStartTime()) > 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[fSelection=" + this.fSelection + ", fWindowRange=" + this.fWindowRange + ']';
    }
}

