/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.Set;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.project.registry.AbstractMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.MavenRequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenDependencyResolver
extends AbstractMavenDependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultMavenDependencyResolver.class);
    private final IMavenMarkerManager markerManager;

    public DefaultMavenDependencyResolver(ProjectRegistryManager manager, IMavenMarkerManager markerManager) {
        this.setManager(manager);
        this.markerManager = markerManager;
    }

    @Override
    public void resolveProjectDependencies(IMavenProjectFacade facade, Set<Capability> capabilities, Set<RequiredCapability> requirements, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        log.debug("Resolving dependencies for {}", (Object)facade.toString());
        this.markerManager.deleteMarkers((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.dependency");
        ProjectBuildingRequest configuration = this.getMaven().getExecutionContext().newProjectBuildingRequest();
        configuration.setProject(facade.getMavenProject());
        configuration.setResolveDependencies(true);
        MavenExecutionResult mavenResult = this.getMaven().readMavenProject(facade.getPomFile(), configuration);
        this.markerManager.addMarkers((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.dependency", mavenResult);
        if (!facade.getResolverConfiguration().shouldResolveWorkspaceProjects()) {
            return;
        }
        MavenProject mavenProject = facade.getMavenProject();
        for (org.apache.maven.artifact.Artifact artifact : mavenProject.getArtifacts()) {
            requirements.add(MavenRequiredCapability.createMavenArtifact(new ArtifactKey(artifact), artifact.getScope(), artifact.isOptional()));
        }
        for (Plugin plugin : mavenProject.getBuildPlugins()) {
            if (!plugin.isExtensions()) continue;
            ArtifactKey artifactKey = new ArtifactKey(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null);
            requirements.add(MavenRequiredCapability.createMavenArtifact(artifactKey, "plugin", false));
        }
        DependencyResolutionResult resolutionResult = mavenResult.getDependencyResolutionResult();
        if (resolutionResult != null && resolutionResult.getUnresolvedDependencies() != null) {
            for (Dependency dependency : resolutionResult.getUnresolvedDependencies()) {
                Artifact artifact = dependency.getArtifact();
                ArtifactKey dependencyKey = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null);
                requirements.add(MavenRequiredCapability.createMavenArtifact(dependencyKey, dependency.getScope(), dependency.isOptional()));
            }
        }
        log.debug("Resolved dependencies for {} in {} ms", (Object)facade.toString(), (Object)(System.currentTimeMillis() - start));
    }

    public static void addParentRequirements(Set<RequiredCapability> requirements, MavenProject mavenProject) {
        org.apache.maven.artifact.Artifact parentArtifact = mavenProject.getParentArtifact();
        if (parentArtifact != null) {
            requirements.add(MavenRequiredCapability.createMavenParent(new ArtifactKey(parentArtifact)));
        }
    }
}

