/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class FileHelpers {
    public static void copyDir(File src, File dst) throws IOException {
        FileHelpers.copyDir(src, dst, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !".svn".equals(pathname.getName());
            }
        });
    }

    public static void copyDir(File src, File dst, FileFilter filter) throws IOException {
        FileHelpers.copyDir(src, dst, filter, true);
    }

    private static void copyDir(File src, File dst, FileFilter filter, boolean deleteDst) throws IOException {
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:" + src.getAbsolutePath());
        }
        if (deleteDst) {
            FileUtils.deleteDirectory((File)dst);
        }
        dst.mkdirs();
        File[] files = src.listFiles(filter);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.canRead()) {
                    File dstChild = new File(dst, file.getName());
                    if (file.isDirectory()) {
                        FileHelpers.copyDir(file, dstChild, filter, false);
                    } else {
                        FileHelpers.copyFile(file, dstChild);
                    }
                }
                ++i;
            }
        }
    }

    private static void copyFile(File src, File dst) throws IOException {
        int len;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        out.close();
        in.close();
    }

    public static void filterXmlFile(File src, File dst, Map<String, String> tokens) throws IOException {
        String text;
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)src);
        try {
            text = IOUtil.toString((Reader)reader);
        }
        finally {
            reader.close();
        }
        for (String token : tokens.keySet()) {
            text = text.replace(token, tokens.get(token));
        }
        dst.getParentFile().mkdirs();
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)dst);
        try {
            writer.write(text);
        }
        finally {
            writer.close();
        }
    }

    public static boolean deleteDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

