/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.mylyn.internal.git.core.GitArtifact;
import org.eclipse.mylyn.internal.git.core.GitRepository;
import org.eclipse.mylyn.internal.git.core.LazyChangeSet;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ChangeType;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.core.spi.ScmResourceArtifact;
import org.eclipse.mylyn.versions.core.spi.ScmResourceUtils;
import org.eclipse.team.core.history.IFileRevision;

public class GitConnector
extends ScmConnector {
    static String PLUGIN_ID = "org.eclipse.mylyn.git.core";

    public String getProviderId() {
        return GitProvider.class.getName();
    }

    public ScmArtifact getArtifact(IResource resource) throws CoreException {
        Repository repository;
        if (resource == null) {
            return null;
        }
        RepositoryMapping m = RepositoryMapping.getMapping((IResource)resource);
        try {
            repository = this.getRepositoryCache().lookupRepository(m.getGitDirAbsolutePath().toFile());
        }
        catch (IOException iOException) {
            return null;
        }
        String resRepoRelPath = this.resolveRepoRelativePath(repository, resource);
        String revision = null;
        try {
            revision = this.resolveObject(repository, resRepoRelPath);
        }
        catch (Exception exception) {}
        ScmArtifact artifact = null;
        if (revision != null) {
            GitRepository repo = this.getRepository(resource);
            artifact = new GitArtifact(revision, resRepoRelPath, repo);
            artifact.setProjectName(resource.getProject().getName());
            artifact.setProjectRelativePath(resource.getProjectRelativePath().toPortableString());
        } else {
            artifact = this.getArtifact(resource, null);
        }
        return artifact;
    }

    public ScmArtifact getArtifact(IResource resource, String revision) throws CoreException {
        return new ScmResourceArtifact((ScmConnector)this, resource, revision);
    }

    public ChangeSet getChangeSet(ScmRepository repository, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        GitRepository gitRepository = (GitRepository)repository;
        Repository repository2 = gitRepository.getRepository();
        RevWalk walk = new RevWalk(repository2);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)revision.getContentIdentifier()));
            return this.changeSet(commit, gitRepository);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
        }
    }

    List<Change> diffCommit(ScmRepository repository, Repository repository2, RevWalk walk, RevCommit commit) throws MissingObjectException, IOException, IncorrectObjectTypeException, CorruptObjectException {
        TreeWalk treeWalk = new TreeWalk(repository2);
        RevCommit[] revCommitArray = commit.getParents();
        if (revCommitArray.length != 0) {
            RevCommit p = revCommitArray[0];
            walk.parseHeaders((RevObject)p);
            walk.parseBody((RevObject)p);
            treeWalk.addTree((AnyObjectId)p.getTree());
        }
        if (treeWalk.getTreeCount() == 0) {
            treeWalk.addTree((AnyObjectId)commit.getTree());
        }
        treeWalk.addTree((AnyObjectId)commit.getTree());
        treeWalk.setRecursive(true);
        ArrayList<Change> changes = new ArrayList<Change>();
        List entries = DiffEntry.scan((TreeWalk)treeWalk);
        File repoDir = repository2.getWorkTree().getAbsoluteFile();
        IPath repoWorkAreaPath = new Path(repoDir.getAbsolutePath()).addTrailingSeparator();
        for (DiffEntry d : entries) {
            if (!d.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME) && d.getOldId().equals((Object)d.getNewId())) continue;
            ScmArtifact newArtifact = this.getArtifact(repository, d, false, repoWorkAreaPath);
            ScmArtifact oldArtifact = this.getArtifact(repository, d, true, repoWorkAreaPath);
            changes.add(new Change(oldArtifact, newArtifact, this.mapChangeType(d.getChangeType())));
        }
        return changes;
    }

    private ScmArtifact getArtifact(ScmRepository repository, DiffEntry d, boolean old, IPath repoWorkAreaPath) {
        GitArtifact artifact = null;
        String id = null;
        String path = null;
        if (old) {
            id = d.getOldId().name();
            path = d.getOldPath();
        } else {
            id = d.getNewId().name();
            path = d.getNewPath();
        }
        GitRepository gitRepository = (GitRepository)repository;
        artifact = new GitArtifact(id, path, gitRepository);
        IFile ifile = null;
        IPath absPath = repoWorkAreaPath.append(path);
        URI absURI = URIUtil.toURI((IPath)absPath);
        IFile[] files = ScmResourceUtils.getWorkSpaceFiles((URI)absURI);
        if (files != null && files.length > 0) {
            ifile = files[0];
            if (files.length > 1) {
                IProject mainProject = gitRepository.getMainWsProject();
                if (mainProject != null) {
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile dfile = iFileArray[n2];
                        String fileProjectName = dfile.getProject().getName();
                        if (mainProject.getName().equals(fileProjectName)) {
                            ifile = dfile;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IFile file = iFileArray[n3];
                        IPath projPath = file.getProject().getLocation();
                        if (projPath.isPrefixOf(absPath)) {
                            ifile = file;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            artifact.setProjectName(ifile.getProject().getName());
            artifact.setProjectRelativePath(ifile.getProjectRelativePath().toPortableString());
        }
        return artifact;
    }

    private ChangeType mapChangeType(DiffEntry.ChangeType change) {
        switch (change) {
            case ADD: 
            case COPY: {
                return ChangeType.ADDED;
            }
            case DELETE: {
                return ChangeType.DELETED;
            }
            case MODIFY: {
                return ChangeType.MODIFIED;
            }
            case RENAME: {
                return ChangeType.REPLACED;
            }
        }
        return null;
    }

    public List<ChangeSet> getChangeSets(ScmRepository repository, IProgressMonitor monitor) throws CoreException {
        return Lists.newArrayList(this.getChangeSetsIterator(repository, monitor));
    }

    public Iterator<ChangeSet> getChangeSetsIterator(ScmRepository repository, IProgressMonitor monitor) {
        Iterable revs;
        final GitRepository gitRepository = (GitRepository)repository;
        Repository gitRepo = gitRepository.getRepository();
        Git git = new Git(gitRepo);
        try {
            revs = git.log().call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Iterators.transform(revs.iterator(), (Function)new Function<RevCommit, ChangeSet>(){

            public ChangeSet apply(RevCommit input) {
                return GitConnector.this.changeSet(input, gitRepository);
            }
        });
    }

    private ChangeSet changeSet(RevCommit r, GitRepository repository) {
        LazyChangeSet changeSet = new LazyChangeSet(r, repository);
        return changeSet;
    }

    public List<ScmRepository> getRepositories(IProgressMonitor monitor) throws CoreException {
        ArrayList<ScmRepository> repos = new ArrayList<ScmRepository>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository repository = this.getRepository((IResource)project, monitor);
            if (repository != null) {
                repos.add(repository);
            }
            ++n2;
        }
        return repos;
    }

    public GitRepository getRepository(IResource resource, IProgressMonitor monitor) throws CoreException {
        return this.getRepository(resource);
    }

    public GitRepository getRepository(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return null;
        }
        return new GitRepository(this, mapping, resource.getProject());
    }

    protected RepositoryCache getRepositoryCache() {
        return Activator.getDefault().getRepositoryCache();
    }

    private String resolveRepoRelativePath(Repository repo, IResource resource) {
        if (repo == null || resource == null) {
            return null;
        }
        File workTree = repo.getWorkTree();
        IPath workTreePath = Path.fromOSString((String)workTree.getAbsolutePath());
        if (workTreePath.isPrefixOf(resource.getProject().getLocation())) {
            IPath makeRelativeTo = resource.getLocation().makeRelativeTo(workTreePath);
            String repoRelativePath = makeRelativeTo.toPortableString();
            return repoRelativePath;
        }
        return null;
    }

    private String resolveObject(Repository repo, String repoRelativePath) throws AmbiguousObjectException, IOException {
        if (repo == null || repoRelativePath == null) {
            return null;
        }
        ObjectId headCommitId = repo.resolve("HEAD");
        String id = null;
        if (headCommitId != null) {
            RevWalk revWalk = new RevWalk(repo);
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headCommitId);
            RevTree headTree = headCommit.getTree();
            TreeWalk resourceInRepo = TreeWalk.forPath((Repository)repo, (String)repoRelativePath, (RevTree)headTree);
            if (resourceInRepo != null) {
                ObjectId objId = resourceInRepo.getObjectId(0);
                id = objId.getName();
            }
            revWalk.dispose();
        }
        return id;
    }
}

