/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.identity.core.IIdentityService;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.commons.notifications.feed.ServiceMessageManager;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.TaskBarManager;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryModelListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.RepositoryExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskActivationExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.core.util.RepositoryConnectorLoader;
import org.eclipse.mylyn.internal.tasks.core.util.TaskRepositoryKeyringMigrator;
import org.eclipse.mylyn.internal.tasks.core.util.TaskRepositorySecureStoreMigrator;
import org.eclipse.mylyn.internal.tasks.core.util.TasksCoreExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskJobFactory;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListNotificationManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListSynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiFactory;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationReminder;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotifier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.activity.AbstractTaskActivityMonitor;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TasksUiPlugin
extends AbstractUIPlugin {
    private static final int DELAY_QUERY_REFRESH_ON_STARTUP = 20000;
    private static final int DEFAULT_LINK_PROVIDER_TIMEOUT = 5000;
    public static final String ID_PLUGIN = "org.eclipse.mylyn.tasks.ui";
    private static final String DIRECTORY_METADATA = ".metadata";
    private static final String NAME_DATA_DIR = ".mylyn";
    private static final char DEFAULT_PATH_SEPARATOR = '/';
    private static final int NOTIFICATION_DELAY = 5000;
    private static final String PREF_MIGRATED_TASK_REPOSITORIES_FROM_SECURE_STORE = "migrated.task.repositories.secure.store";
    private static final String PREF_MIGRATED_TASK_REPOSITORIES_FROM_KEYRING = "migrated.task.repositories.keyring";
    private static final String PROP_FORCE_CREDENTIALS_MIGRATION = "org.eclipse.mylyn.tasks.force.credentials.migration";
    private static TasksUiPlugin INSTANCE;
    private static ExternalizationManager externalizationManager;
    private static TaskActivityManager taskActivityManager;
    private static TaskRepositoryManager repositoryManager;
    private static TaskListSynchronizationScheduler synchronizationScheduler;
    private static TaskDataManager taskDataManager;
    private static Map<String, AbstractRepositoryConnectorUi> repositoryConnectorUiMap;
    private TaskListNotificationManager taskListNotificationManager;
    private TaskListBackupManager taskListBackupManager;
    private RepositoryTemplateManager repositoryTemplateManager;
    private ServiceMessageManager serviceMessageManager;
    private final Set<AbstractTaskEditorPageFactory> taskEditorPageFactories = new HashSet<AbstractTaskEditorPageFactory>();
    private final TreeSet<AbstractTaskRepositoryLinkProvider> repositoryLinkProviders = new TreeSet<AbstractTaskRepositoryLinkProvider>(new OrderComparator());
    private TaskListExternalizer taskListExternalizer;
    private final Map<String, Image> brandingIcons = new HashMap<String, Image>();
    private final Map<String, ImageDescriptor> overlayIcons = new HashMap<String, ImageDescriptor>();
    private final Set<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
    private ISaveParticipant saveParticipant;
    private TaskJobFactory taskJobFactory;
    private FormColors formColors;
    private static AbstractTaskContextStore contextStore;
    private final List<AbstractSearchHandler> searchHandlers = new ArrayList<AbstractSearchHandler>();
    private static final boolean DEBUG_HTTPCLIENT;
    private static ITaskListNotificationProvider REMINDER_NOTIFICATION_PROVIDER;
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.end.hour") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.week.start.day")) {
                TasksUiPlugin.this.updateTaskActivityManager();
            }
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds")) {
                TasksUiPlugin.this.updateSynchronizationScheduler(false);
            }
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.messages.enabled")) {
                if (TasksUiPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.messages.enabled")) {
                    TasksUiPlugin.this.serviceMessageManager.start();
                } else {
                    TasksUiPlugin.this.serviceMessageManager.stop();
                }
            }
        }
    };
    private AbstractTaskActivityMonitor taskActivityMonitor;
    private ServiceReference proxyServiceReference;
    private IProxyChangeListener proxyChangeListener;
    private static TaskListExternalizationParticipant taskListExternalizationParticipant;
    private final Set<IRepositoryModelListener> listeners = new HashSet<IRepositoryModelListener>();
    private File activationHistoryFile;
    private static TaskList taskList;
    private static RepositoryModel repositoryModel;
    private static TasksUiFactory uiFactory;
    @Deprecated
    public static String LABEL_VIEW_REPOSITORIES;
    private final AtomicInteger initializationCount = new AtomicInteger();
    private SynchronizationManger synchronizationManger;
    private RepositoryConnectorLoader connectorLoader;
    private final Map<String, List<IDynamicSubMenuContributor>> menuContributors = new HashMap<String, List<IDynamicSubMenuContributor>>();
    private ServiceTracker identityServiceTracker;

    static {
        repositoryConnectorUiMap = new HashMap<String, AbstractRepositoryConnectorUi>();
        DEBUG_HTTPCLIENT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.ui/debug/httpclient"));
        REMINDER_NOTIFICATION_PROVIDER = new ITaskListNotificationProvider(){

            @Override
            public Set<AbstractUiNotification> getNotifications() {
                Collection allTasks = TasksUiPlugin.getTaskList().getAllTasks();
                HashSet<AbstractUiNotification> reminders = new HashSet<AbstractUiNotification>();
                for (AbstractTask task : allTasks) {
                    if (!TasksUiPlugin.getTaskActivityManager().isPastReminder(task) || task.isReminded()) continue;
                    reminders.add(new TaskListNotificationReminder(task));
                    task.setReminded(true);
                }
                return reminders;
            }
        };
        LABEL_VIEW_REPOSITORIES = Messages.TasksUiPlugin_Task_Repositories;
    }

    public TasksUiPlugin() {
        INSTANCE = this;
    }

    private void addSystemTaskBarActions() {
        MenuManager taskBarMenuManager = TaskBarManager.getTaskBarMenuManager();
        if (taskBarMenuManager != null) {
            NewTaskAction newTaskAction = new NewTaskAction(Messages.TasksUiPlugin_New_Task, true);
            taskBarMenuManager.add((IAction)newTaskAction);
            Action activateTaskAction = new Action(){

                public void run() {
                    ActivateTaskDialogAction activateTaskDialogAction = new ActivateTaskDialogAction();
                    IWorkbenchWindow window = TasksUiPlugin.this.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null && TasksUiPlugin.this.getWorkbench().getWorkbenchWindows().length > 0) {
                        window = TasksUiPlugin.this.getWorkbench().getWorkbenchWindows()[0];
                    }
                    activateTaskDialogAction.init(window);
                    activateTaskDialogAction.run(null);
                }
            };
            activateTaskAction.setImageDescriptor(TasksUiImages.CONTEXT_ACTIVE_CENTERED);
            activateTaskAction.setText(Messages.TasksUiPlugin_Activate_Task);
            taskBarMenuManager.add((IAction)activateTaskAction);
            taskBarMenuManager.update(true);
        }
    }

    private void updateSynchronizationScheduler(boolean initial) {
        if (synchronizationScheduler == null) {
            return;
        }
        boolean enabled = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
        if (enabled) {
            long interval = TasksUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
            if (initial) {
                synchronizationScheduler.setInterval(20000L, interval);
            } else {
                synchronizationScheduler.setInterval(interval);
            }
        } else {
            synchronizationScheduler.setInterval(0L);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            IProxyService proxyService;
            if (DEBUG_HTTPCLIENT) {
                this.initHttpLogging();
            }
            WebUtil.init();
            this.initializePreferences(this.getPreferenceStore());
            File dataDir = new File(this.getDataDirectory());
            dataDir.mkdirs();
            externalizationManager = new ExternalizationManager(this.getDataDirectory());
            repositoryManager = new TaskRepositoryManager();
            RepositoryExternalizationParticipant repositoryParticipant = new RepositoryExternalizationParticipant(externalizationManager, repositoryManager);
            externalizationManager.addParticipant((IExternalizationParticipant)repositoryParticipant);
            taskList = new TaskList();
            repositoryModel = new RepositoryModel(taskList, (IRepositoryManager)repositoryManager);
            this.taskListExternalizer = new TaskListExternalizer(repositoryModel, (IRepositoryManager)repositoryManager);
            taskListExternalizationParticipant = new TaskListExternalizationParticipant(repositoryModel, taskList, this.taskListExternalizer, externalizationManager, repositoryManager);
            externalizationManager.addParticipant((IExternalizationParticipant)taskListExternalizationParticipant);
            taskList.addChangeListener((ITaskListChangeListener)taskListExternalizationParticipant);
            taskActivityManager = new TaskActivityManager(repositoryManager, taskList);
            taskActivityManager.addActivationListener((ITaskActivationListener)taskListExternalizationParticipant);
            this.updateTaskActivityManager();
            this.proxyServiceReference = context.getServiceReference(IProxyService.class.getName());
            if (this.proxyServiceReference != null && (proxyService = (IProxyService)context.getService(this.proxyServiceReference)) != null) {
                this.proxyChangeListener = new IProxyChangeListener(){

                    public void proxyInfoChanged(IProxyChangeEvent event) {
                        List repositories = repositoryManager.getAllRepositories();
                        for (TaskRepository repository : repositories) {
                            if (!repository.isDefaultProxyEnabled()) continue;
                            repositoryManager.notifyRepositorySettingsChanged(repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.PROYX));
                        }
                    }
                };
                proxyService.addProxyChangeListener(this.proxyChangeListener);
            }
            this.repositoryTemplateManager = new RepositoryTemplateManager();
            this.connectorLoader = new RepositoryConnectorLoader();
            this.connectorLoader.registerConnectors(repositoryManager, this.taskListExternalizer);
            this.connectorLoader.registerTemplates(repositoryManager, this.repositoryTemplateManager);
            TasksUiExtensionReader.initStartupExtensions(this.connectorLoader.getBlackList());
            TaskDataStore taskDataStore = new TaskDataStore((IRepositoryManager)repositoryManager);
            this.synchronizationManger = new SynchronizationManger(repositoryModel);
            taskDataManager = new TaskDataManager(taskDataStore, (IRepositoryManager)repositoryManager, taskList, taskActivityManager, this.synchronizationManger);
            this.taskJobFactory = new TaskJobFactory(taskList, taskDataManager, (IRepositoryManager)repositoryManager, (IRepositoryModel)repositoryModel);
            this.taskActivityMonitor = TasksCoreExtensionReader.loadTaskActivityMonitor();
            this.taskActivityMonitor.start((ITaskActivityManager)taskActivityManager);
            this.saveParticipant = new ISaveParticipant(){

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }

                public void saving(ISaveContext context) throws CoreException {
                    if (context.getKind() == 1) {
                        externalizationManager.stop();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, this.saveParticipant);
            IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
            this.activationHistoryFile = stateLocation.append("TaskActivationHistory.xml").toFile();
            TaskActivationExternalizationParticipant taskActivationExternalizationParticipant = new TaskActivationExternalizationParticipant(externalizationManager, taskList, taskActivityManager.getTaskActivationHistory(), this.activationHistoryFile);
            taskActivityManager.addActivationListener((ITaskActivationListener)taskActivationExternalizationParticipant);
            externalizationManager.addParticipant((IExternalizationParticipant)taskActivationExternalizationParticipant);
            this.initializeDataSources();
            this.migrateCredentials(repositoryManager.getAllRepositories());
            this.taskListNotificationManager = new TaskListNotificationManager();
            String lastMod = this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.servicemessage.lastmodified");
            String etag = this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.servicemessage.etag");
            String serviceMessageUrl = this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.servicemessage.url");
            Long checktime = this.getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.servicemessage.checktime");
            this.serviceMessageManager = new ServiceMessageManager(serviceMessageUrl, lastMod, etag, checktime.longValue(), new NotificationEnvironment(){
                private Set<String> installedFeatures;

                public Set<String> getInstalledFeatures(IProgressMonitor monitor) {
                    if (this.installedFeatures == null) {
                        this.installedFeatures = DiscoveryUi.createInstallJob().getInstalledFeatures(monitor);
                    }
                    return this.installedFeatures;
                }
            });
            if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.messages.enabled")) {
                this.serviceMessageManager.start();
            }
            new TasksUiInitializationJob().schedule();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list initialization failed", (Throwable)e));
        }
    }

    private void migrateCredentials(final List<TaskRepository> repositories) {
        boolean migrateFromKeyring;
        final boolean force = Boolean.parseBoolean(System.getProperty(PROP_FORCE_CREDENTIALS_MIGRATION));
        final boolean migrateFromSecureStore = force || !this.getPluginPreferences().getBoolean(PREF_MIGRATED_TASK_REPOSITORIES_FROM_SECURE_STORE);
        boolean bl = migrateFromKeyring = (force || !this.getPluginPreferences().getBoolean(PREF_MIGRATED_TASK_REPOSITORIES_FROM_KEYRING)) && this.isKeyringInstalled();
        if (!migrateFromSecureStore && !migrateFromKeyring) {
            return;
        }
        new UIJob("Credential Migration UI Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                new Job("Credential Migration"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (force) {
                            StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Forcing task repository credential migration because system property {0} is set.", (Object)TasksUiPlugin.PROP_FORCE_CREDENTIALS_MIGRATION)));
                        }
                        if (migrateFromSecureStore) {
                            new TaskRepositorySecureStoreMigrator().migrateCredentials((Collection)repositories);
                        }
                        if (migrateFromKeyring) {
                            new TaskRepositoryKeyringMigrator("", "Basic").migrateCredentials((Collection)repositories);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean isKeyringInstalled() {
        return Platform.getBundle((String)"org.eclipse.core.runtime.compatibility.auth") != null;
    }

    private void initHttpLogging() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient.HttpConnection", "trace");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.axis.message", "debug");
    }

    private void updateTaskActivityManager() {
        int endHour = this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
        TaskActivityUtil.setEndHour((int)endHour);
        int newWeekStartDay = this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day");
        int oldWeekStartDay = taskActivityManager.getWeekStartDay();
        if (oldWeekStartDay != newWeekStartDay) {
            taskActivityManager.setWeekStartDay(newWeekStartDay);
        }
    }

    private void loadTemplateRepositories() {
        TaskRepository local = this.getLocalTaskRepository();
        repositoryManager.applyMigrators(local);
        for (AbstractRepositoryConnector connector : repositoryManager.getRepositoryConnectors()) {
            for (RepositoryTemplate template : this.repositoryTemplateManager.getTemplates(connector.getConnectorKind())) {
                if (!template.addAutomatically || TaskRepositoryUtil.isAddAutomaticallyDisabled(template.repositoryUrl)) continue;
                try {
                    String repositoryUrl = TaskRepositoryManager.stripSlashes((String)template.repositoryUrl);
                    TaskRepository taskRepository = repositoryManager.getRepository(connector.getConnectorKind(), repositoryUrl);
                    if (taskRepository != null) continue;
                    taskRepository = new TaskRepository(connector.getConnectorKind(), repositoryUrl);
                    taskRepository.setVersion(template.version);
                    taskRepository.setRepositoryLabel(template.label);
                    taskRepository.setCharacterEncoding(template.characterEncoding);
                    if (template.anonymous) {
                        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.enabled", String.valueOf(false));
                    }
                    taskRepository.setCreatedFromTemplate(true);
                    repositoryManager.addRepository(taskRepository);
                    repositoryManager.applyMigrators(taskRepository);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, NLS.bind((String)"Could not load repository template for repository {0}", (Object)template.repositoryUrl), t));
                }
            }
        }
    }

    public TaskRepository getLocalTaskRepository() {
        TaskRepository localRepository = repositoryManager.getRepository("local", "local");
        if (localRepository == null) {
            localRepository = new TaskRepository("local", "local");
            localRepository.setVersion("1");
            localRepository.setRepositoryLabel(LocalRepositoryConnector.REPOSITORY_LABEL);
            repositoryManager.addRepository(localRepository);
        }
        return localRepository;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                Job.getJobManager().cancel(ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION);
                if (this.formColors != null) {
                    this.formColors.dispose();
                    this.formColors = null;
                }
                if (this.taskActivityMonitor != null) {
                    this.taskActivityMonitor.stop();
                }
                if (ResourcesPlugin.getWorkspace() != null) {
                    ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
                }
                if (this.proxyServiceReference != null) {
                    IProxyService proxyService = (IProxyService)context.getService(this.proxyServiceReference);
                    if (proxyService != null) {
                        proxyService.removeProxyChangeListener(this.proxyChangeListener);
                    }
                    context.ungetService(this.proxyServiceReference);
                }
                if (this.identityServiceTracker != null) {
                    this.identityServiceTracker.close();
                    this.identityServiceTracker = null;
                }
                this.getPluginPreferences().setValue(PREF_MIGRATED_TASK_REPOSITORIES_FROM_SECURE_STORE, Boolean.toString(true));
                if (this.isKeyringInstalled()) {
                    this.getPluginPreferences().setValue(PREF_MIGRATED_TASK_REPOSITORIES_FROM_KEYRING, Boolean.toString(true));
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    if (this.taskListNotificationManager != null) {
                        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListNotificationManager);
                    }
                    if (this.taskListBackupManager != null) {
                        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListBackupManager);
                    }
                    this.getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
                    CommonColors.dispose();
                    this.serviceMessageManager.stop();
                    INSTANCE = null;
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list stop terminated abnormally", (Throwable)e));
                super.stop(context);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public String getDefaultDataDirectory() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + '/' + DIRECTORY_METADATA + '/' + NAME_DATA_DIR;
    }

    public String getDataDirectory() {
        return this.getPreferenceStore().getString("org.eclipse.mylyn.data.dir");
    }

    public void setDataDirectory(final String path) throws CoreException {
        Assert.isNotNull((Object)path);
        IRunnableWithProgress runner = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(Messages.TasksUiPlugin_Load_Data_Directory, -1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    TasksUi.getTaskActivityManager().deactivateActiveTask();
                    if (!path.equals(TasksUiPlugin.this.getDataDirectory())) {
                        TasksUiPlugin.this.getPreferenceStore().setValue("org.eclipse.mylyn.data.dir", path);
                    }
                    TasksUiPlugin.this.initializeDataSources();
                }
                finally {
                    monitor.done();
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.runInUI((IRunnableContext)service, runner, ITasksCoreConstants.ROOT_SCHEDULING_RULE);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, ID_PLUGIN, "Failed to set data directory", e.getCause()));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public void reloadDataDirectory() throws CoreException {
        this.setDataDirectory(this.getDataDirectory());
    }

    public void initializeDataSources() {
        File storeFile = new File(this.getDataDirectory(), "contexts");
        if (!storeFile.exists()) {
            storeFile.mkdirs();
        }
        taskDataManager.setDataPath(this.getDataDirectory());
        externalizationManager.setRootFolderPath(this.getDataDirectory());
        TasksUiPlugin.getContextStore().setDirectory(new File(this.getDataDirectory(), "tasks"));
        externalizationManager.load();
        this.loadTemplateRepositories();
        taskActivityManager.clear();
        this.taskActivityMonitor.loadActivityTime();
        taskActivityManager.reloadPlanningData();
        if (!this.activationHistoryFile.exists() && taskActivityManager.getTaskActivationHistory().getSize() == 0) {
            List tasks = this.taskActivityMonitor.getActivationHistory();
            for (ITask task : tasks) {
                taskActivityManager.getTaskActivationHistory().addTask((AbstractTask)task);
            }
        }
        if (!MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled.checked")) {
            if (!this.taskActivityMonitor.getActivationHistory().isEmpty()) {
                MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.activity.tracking.enabled", true);
            }
            MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.activity.tracking.enabled.checked", true);
            MonitorUiPlugin.getDefault().savePluginPreferences();
        }
        for (final IRepositoryModelListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(2, TasksUiPlugin.ID_PLUGIN, "Listener failed: " + listener.getClass(), exception));
                }

                public void run() throws Exception {
                    listener.loaded();
                }
            });
        }
    }

    private void initializePreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylyn.data.dir", this.getDefaultDataDirectory());
        store.setDefault("org.eclipse.mylyn.tasks.ui.group.subtasks", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.notifications.enabled", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.messages.enabled", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P5.toString());
        store.setDefault("org.eclipse.mylyn.tasks.ui.reporting.open.editor", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activate.when.opened", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.show.trim", false);
        store.setToDefault("org.eclipse.mylyn.tasks.ui.subtasks.local");
        store.setDefault("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", "1200000");
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.maxfiles", 20);
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.last", 0.0f);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.hidden", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.archive", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setValue("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.week.start.day", Calendar.getInstance().getFirstDayOfWeek());
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.end.hour", 18);
        store.setDefault("org.eclipse.mylyn.tasks.ui.auto.expand", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.task.list.tool.tip", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.servicemessage.url", "http://eclipse.org/mylyn/updates.xml");
    }

    public static TaskActivityManager getTaskActivityManager() {
        return taskActivityManager;
    }

    public static TaskListNotificationManager getTaskListNotificationManager() {
        return TasksUiPlugin.INSTANCE.taskListNotificationManager;
    }

    public static TasksUiPlugin getDefault() {
        return INSTANCE;
    }

    public boolean groupSubtasks(ITaskContainer element) {
        AbstractRepositoryConnectorUi connectorUi;
        boolean groupSubtasks = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.group.subtasks");
        if (element instanceof ITask && (connectorUi = TasksUiPlugin.getConnectorUi(((ITask)element).getConnectorKind())) != null && connectorUi.hasStrictSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        if (element instanceof IRepositoryQuery && (connectorUi = TasksUiPlugin.getConnectorUi(((IRepositoryQuery)element).getConnectorKind())) != null && connectorUi.hasStrictSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        return groupSubtasks;
    }

    public Map<String, List<IDynamicSubMenuContributor>> getDynamicMenuMap() {
        return this.menuContributors;
    }

    public void addDynamicPopupContributor(String menuPath, IDynamicSubMenuContributor contributor) {
        List<IDynamicSubMenuContributor> contributors = this.menuContributors.get(menuPath);
        if (contributors == null) {
            contributors = new ArrayList<IDynamicSubMenuContributor>();
            this.menuContributors.put(menuPath, contributors);
        }
        contributors.add(contributor);
    }

    public String[] getSaveOptions() {
        String[] options = new String[]{TaskListSaveMode.ONE_HOUR.toString(), TaskListSaveMode.THREE_HOURS.toString(), TaskListSaveMode.DAY.toString()};
        return options;
    }

    public String getBackupFolderPath() {
        return String.valueOf(this.getDataDirectory()) + '/' + "backup";
    }

    public AbstractTaskEditorPageFactory[] getTaskEditorPageFactories() {
        return this.taskEditorPageFactories.toArray(new AbstractTaskEditorPageFactory[0]);
    }

    public void addTaskEditorPageFactory(AbstractTaskEditorPageFactory factory) {
        Assert.isNotNull((Object)factory);
        this.taskEditorPageFactories.add(factory);
    }

    public void removeTaskEditorPageFactory(AbstractTaskEditorPageFactory factory) {
        Assert.isNotNull((Object)factory);
        this.taskEditorPageFactories.remove(factory);
    }

    public static TaskRepositoryManager getRepositoryManager() {
        return repositoryManager;
    }

    public static RepositoryTemplateManager getRepositoryTemplateManager() {
        return TasksUiPlugin.INSTANCE.repositoryTemplateManager;
    }

    public void addBrandingIcon(String repositoryType, Image icon) {
        this.brandingIcons.put(repositoryType, icon);
    }

    public Image getBrandingIcon(String repositoryType) {
        return this.brandingIcons.get(repositoryType);
    }

    public void addOverlayIcon(String repositoryType, ImageDescriptor icon) {
        this.overlayIcons.put(repositoryType, icon);
    }

    public ImageDescriptor getOverlayIcon(String repositoryType) {
        return this.overlayIcons.get(repositoryType);
    }

    public void addRepositoryLinkProvider(AbstractTaskRepositoryLinkProvider repositoryLinkProvider) {
        if (repositoryLinkProvider != null) {
            this.repositoryLinkProviders.add(repositoryLinkProvider);
        }
    }

    public static synchronized TaskListBackupManager getBackupManager() {
        if (TasksUiPlugin.INSTANCE.taskListBackupManager == null) {
            TasksUiPlugin.INSTANCE.taskListBackupManager = new TaskListBackupManager(INSTANCE.getBackupFolderPath());
            INSTANCE.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)TasksUiPlugin.INSTANCE.taskListBackupManager);
        }
        return TasksUiPlugin.INSTANCE.taskListBackupManager;
    }

    public void addRepositoryConnectorUi(AbstractRepositoryConnectorUi repositoryConnectorUi) {
        if (!repositoryConnectorUiMap.values().contains(repositoryConnectorUi)) {
            repositoryConnectorUiMap.put(repositoryConnectorUi.getConnectorKind(), repositoryConnectorUi);
        }
    }

    public static AbstractRepositoryConnector getConnector(String kind) {
        return TasksUiPlugin.getRepositoryManager().getRepositoryConnector(kind);
    }

    public static AbstractRepositoryConnectorUi getConnectorUi(String kind) {
        return repositoryConnectorUiMap.get(kind);
    }

    @Deprecated
    public static TaskListSynchronizationScheduler getSynchronizationScheduler() {
        return synchronizationScheduler;
    }

    public static TaskDataManager getTaskDataManager() {
        return taskDataManager;
    }

    public static TaskJobFactory getTaskJobFactory() {
        return TasksUiPlugin.INSTANCE.taskJobFactory;
    }

    public void addDuplicateDetector(AbstractDuplicateDetector duplicateDetector) {
        Assert.isNotNull((Object)duplicateDetector);
        this.duplicateDetectors.add(duplicateDetector);
    }

    public Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        return this.duplicateDetectors;
    }

    public String getRepositoriesFilePath() {
        return String.valueOf(this.getDataDirectory()) + File.separator + "repositories.xml.zip";
    }

    public void addModelListener(IRepositoryModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IRepositoryModelListener listener) {
        this.listeners.remove(listener);
    }

    public boolean canSetRepositoryForResource(final IResource resource) {
        if (resource == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        final boolean[] found = new boolean[1];
        for (final AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Task repository link provider failed: \"" + linkProvider.getId() + "\"", e));
                }

                public void run() throws Exception {
                    if (linkProvider.getTaskRepository(resource, (IRepositoryManager)TasksUiPlugin.getRepositoryManager()) != null) {
                        found[0] = true;
                        result[0] = linkProvider.canSetTaskRepository(resource);
                    }
                }
            });
            if (!found[0]) continue;
            return result[0];
        }
        for (final AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Task repository link provider failed: \"" + linkProvider.getId() + "\"", e));
                }

                public void run() throws Exception {
                    if (linkProvider.canSetTaskRepository(resource)) {
                        result[0] = true;
                    }
                }
            });
            if (!result[0]) continue;
            return true;
        }
        return false;
    }

    public void setRepositoryForResource(final IResource resource, final TaskRepository repository) {
        Assert.isNotNull((Object)resource);
        for (final AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Task repository link provider failed: \"" + linkProvider.getId() + "\"", e));
                }

                public void run() throws Exception {
                    boolean canSetRepository = linkProvider.canSetTaskRepository(resource);
                    if (canSetRepository) {
                        linkProvider.setTaskRepository(resource, repository);
                    }
                }
            });
        }
    }

    public TaskRepository getRepositoryForResource(final IResource resource) {
        long timeout;
        Assert.isNotNull((Object)resource);
        try {
            timeout = Long.parseLong(System.getProperty("org.eclipse.mylyn.linkProviderTimeout", "5000"));
        }
        catch (NumberFormatException numberFormatException) {
            timeout = 5000L;
        }
        HashSet<AbstractTaskRepositoryLinkProvider> defectiveLinkProviders = new HashSet<AbstractTaskRepositoryLinkProvider>();
        for (final AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            long startTime = System.currentTimeMillis();
            final TaskRepository[] repository = new TaskRepository[1];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Task repository link provider failed: \"" + linkProvider.getId() + "\"", e));
                }

                public void run() throws Exception {
                    repository[0] = linkProvider.getTaskRepository(resource, (IRepositoryManager)TasksUiPlugin.getRepositoryManager());
                }
            });
            long elapsed = System.currentTimeMillis() - startTime;
            if (timeout >= 0L && elapsed > timeout) {
                defectiveLinkProviders.add(linkProvider);
            }
            if (repository[0] == null) continue;
            return repository[0];
        }
        if (!defectiveLinkProviders.isEmpty()) {
            this.repositoryLinkProviders.removeAll(defectiveLinkProviders);
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "Repository link provider took over " + timeout + " ms to execute and was timed out: \"" + defectiveLinkProviders + "\""));
        }
        return null;
    }

    public static ExternalizationManager getExternalizationManager() {
        return externalizationManager;
    }

    public static AbstractTaskActivityMonitor getTaskActivityMonitor() {
        return TasksUiPlugin.INSTANCE.taskActivityMonitor;
    }

    public static TaskList getTaskList() {
        return taskList;
    }

    public static RepositoryModel getRepositoryModel() {
        return repositoryModel;
    }

    public void addSearchHandler(AbstractSearchHandler searchHandler) {
        this.searchHandlers.add(searchHandler);
    }

    public void removeSearchHandler(AbstractSearchHandler searchHandler) {
        this.searchHandlers.remove(searchHandler);
    }

    public AbstractSearchHandler getSearchHandler(String connectorKind) {
        Assert.isNotNull((Object)connectorKind);
        for (AbstractSearchHandler searchHandler : this.searchHandlers) {
            if (!searchHandler.getConnectorKind().equals(connectorKind)) continue;
            return searchHandler;
        }
        return null;
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public void removeRepositoryLinkProvider(AbstractTaskRepositoryLinkProvider provider) {
        this.repositoryLinkProviders.remove(provider);
    }

    public TaskListExternalizer createTaskListExternalizer() {
        return new TaskListExternalizer(repositoryModel, (IRepositoryManager)repositoryManager);
    }

    public static TaskListExternalizationParticipant getTaskListExternalizationParticipant() {
        return taskListExternalizationParticipant;
    }

    public static TasksUiFactory getUiFactory() {
        if (uiFactory == null) {
            uiFactory = new TasksUiFactory();
        }
        return uiFactory;
    }

    public void initializeNotificationsAndSynchronization() {
        if (this.initializationCount.incrementAndGet() != 2) {
            return;
        }
        try {
            this.taskListNotificationManager.addNotificationProvider(REMINDER_NOTIFICATION_PROVIDER);
            TaskListNotifier taskListNotifier = new TaskListNotifier(TasksUiPlugin.getTaskDataManager(), this.getSynchronizationManger());
            TasksUiPlugin.getTaskDataManager().addListener((ITaskDataManagerListener)taskListNotifier);
            this.taskListNotificationManager.addNotificationProvider(taskListNotifier);
            this.taskListNotificationManager.startNotification(5000L);
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.taskListNotificationManager);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not initialize notifications", t));
        }
        try {
            TasksUiPlugin.getBackupManager();
            synchronizationScheduler = new TaskListSynchronizationScheduler((ITaskJobFactory)this.taskJobFactory);
            MonitorUiPlugin.getDefault().getActivityContextManager().addListener((IUserAttentionListener)synchronizationScheduler);
            this.updateSynchronizationScheduler(true);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not initialize task list backup and synchronization", t));
        }
    }

    public ServiceMessageManager getServiceMessageManager() {
        return this.serviceMessageManager;
    }

    public SynchronizationManger getSynchronizationManger() {
        return this.synchronizationManger;
    }

    public IIdentityService getIdentityService() {
        if (this.identityServiceTracker == null) {
            this.identityServiceTracker = new ServiceTracker(this.getBundle().getBundleContext(), IIdentityService.class.getName(), null);
            this.identityServiceTracker.open();
        }
        return (IIdentityService)this.identityServiceTracker.getService();
    }

    public static synchronized AbstractTaskContextStore getContextStore() {
        if (contextStore == null) {
            contextStore = TasksCoreExtensionReader.loadTaskContextStore();
        }
        return contextStore;
    }

    private static final class OrderComparator
    implements Comparator<AbstractTaskRepositoryLinkProvider> {
        private OrderComparator() {
        }

        @Override
        public int compare(AbstractTaskRepositoryLinkProvider p1, AbstractTaskRepositoryLinkProvider p2) {
            return p1.getOrder() - p2.getOrder();
        }
    }

    public static enum ReportOpenMode {
        EDITOR,
        INTERNAL_BROWSER,
        EXTERNAL_BROWSER;

    }

    public static enum TaskListSaveMode {
        ONE_HOUR,
        THREE_HOURS,
        DAY;


        public String toString() {
            switch (this) {
                case ONE_HOUR: {
                    return "1 hour";
                }
                case THREE_HOURS: {
                    return "3 hours";
                }
                case DAY: {
                    return "1 day";
                }
            }
            return "3 hours";
        }

        public static TaskListSaveMode fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("1 hour")) {
                return ONE_HOUR;
            }
            if (string.equals("3 hours")) {
                return THREE_HOURS;
            }
            if (string.equals("1 day")) {
                return DAY;
            }
            return null;
        }

        public static long fromStringToLong(String string) {
            long hour = 3600000L;
            switch (TaskListSaveMode.fromString(string)) {
                case ONE_HOUR: {
                    return hour;
                }
                case THREE_HOURS: {
                    return hour * 3L;
                }
                case DAY: {
                    return hour * 24L;
                }
            }
            return hour * 3L;
        }
    }

    private class TasksUiInitializationJob
    extends UIJob {
        public TasksUiInitializationJob() {
            super(Messages.TasksUiPlugin_Initializing_Task_List);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            block13: {
                monitor.beginTask("Initializing Task List", 5);
                try {
                    boolean activateTask;
                    TasksUiExtensionReader.initWorkbenchUiExtensions(TasksUiPlugin.this.connectorLoader.getBlackList());
                    externalizationManager.getLoadStatus();
                    List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
                    boolean bl = activateTask = !commandLineArgs.contains("-no-activate-task");
                    if (activateTask) {
                        try {
                            Field field = Workspace.class.getDeclaredField("crashed");
                            field.setAccessible(true);
                            Object value = field.get(ResourcesPlugin.getWorkspace());
                            if (value instanceof Boolean) {
                                activateTask = (Boolean)value == false;
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    for (AbstractTask task : taskList.getAllTasks()) {
                        if (!task.isActive()) continue;
                        task.setActive(false);
                        if (!activateTask) continue;
                        taskActivityManager.activateTask((ITask)task);
                        activateTask = false;
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize task activity", t));
                }
                monitor.worked(1);
                TasksUiPlugin.this.initializeNotificationsAndSynchronization();
                TasksUiPlugin.this.addSystemTaskBarActions();
                try {
                    try {
                        TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener(TasksUiPlugin.this.PROPERTY_LISTENER);
                        TaskRepositoriesView repositoriesView = TaskRepositoriesView.getFromActivePerspective();
                        if (repositoriesView != null) {
                            repositoriesView.getViewer().refresh();
                        }
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not finish Tasks UI initialization", t));
                        monitor.done();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            this.hideNonMatchingSubtasks();
            return new Status(0, TasksUiPlugin.ID_PLUGIN, 0, "", null);
        }

        protected void hideNonMatchingSubtasks() {
            if (!TasksUiPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.nonmatching") && !TasksUiPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.nonmatching.encouraged")) {
                if (taskList.getQueries().isEmpty()) {
                    TasksUiPlugin.this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", true);
                } else {
                    TaskListView view = TaskListView.getFromActivePerspective();
                    if (view != null && view.getServiceMessageControl() != null) {
                        ServiceMessage message = new ServiceMessage(""){

                            public boolean openLink(String link) {
                                if ("hide-subtasks".equals(link)) {
                                    TasksUiPlugin.this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", true);
                                    TasksUiPlugin.this.savePluginPreferences();
                                    return true;
                                }
                                return false;
                            }
                        };
                        message.setId("hide.nonmatching.subtasks");
                        message.setImage("dialog_messasge_info_image");
                        message.setTitle(Messages.TasksUiPlugin_Hide_Irrelevant_Subtasks);
                        message.setDescription(NLS.bind((String)Messages.TasksUiPlugin_Hide_Irrelevant_Subtasks_Message, (Object)"hide-subtasks"));
                        view.getServiceMessageControl().setMessage(message);
                    }
                }
                TasksUiPlugin.this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching.encouraged", true);
                TasksUiPlugin.this.savePluginPreferences();
            }
        }
    }

    public static class TasksUiStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

