/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageProvider;
import org.eclipse.mylyn.wikitext.core.util.Messages;

public class ServiceLocator {
    protected final ClassLoader classLoader;
    private static Object implementationClassLock = new Object();
    private static Class<? extends ServiceLocator> implementationClass;
    private static Pattern CLASS_NAME_PATTERN;

    static {
        CLASS_NAME_PATTERN = Pattern.compile("\\s*([^\\s#]+)?#?.*");
    }

    protected ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator getInstance(ClassLoader classLoader) {
        Object object = implementationClassLock;
        synchronized (object) {
            if (implementationClass != null) {
                try {
                    return implementationClass.getConstructor(ClassLoader.class).newInstance(classLoader);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return new ServiceLocator(classLoader);
    }

    public static ServiceLocator getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            ServiceLocator.class.getClassLoader();
        }
        return ServiceLocator.getInstance(loader);
    }

    public MarkupLanguage getMarkupLanguage(final String languageName) throws IllegalArgumentException {
        String className;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)languageName) ? 1 : 0) != 0, (Object)"Must provide a languageName");
        Pattern classNamePattern = Pattern.compile("\\s*([^\\s#]+)?#?.*");
        final ArrayList names = Lists.newArrayList();
        final ArrayList languages = Lists.newArrayList();
        final MarkupLanguage[] result = new MarkupLanguage[1];
        this.loadMarkupLanguages(new MarkupLanguageVisitor(){

            @Override
            public boolean accept(MarkupLanguage language) {
                if (languageName.equals(language.getName())) {
                    result[0] = language;
                    return false;
                }
                languages.add(language);
                names.add(language.getName());
                return true;
            }
        });
        if (result[0] != null) {
            return result[0];
        }
        Matcher matcher = classNamePattern.matcher(languageName);
        if (matcher.matches() && (className = matcher.group(1)) != null) {
            for (MarkupLanguage language : languages) {
                if (!className.equals(language.getClass().getName())) continue;
                return language;
            }
            try {
                Class<?> clazz = Class.forName(className, true, this.classLoader);
                if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                    MarkupLanguage instance = (MarkupLanguage)clazz.newInstance();
                    return instance;
                }
            }
            catch (Exception exception) {}
        }
        Collections.sort(names);
        StringBuilder buf = new StringBuilder();
        for (String name : names) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append('\'');
            buf.append(name);
            buf.append('\'');
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ServiceLocator.4"), languageName, buf.length() == 0 ? Messages.getString("ServiceLocator.5") : String.valueOf(Messages.getString("ServiceLocator.6")) + buf));
    }

    public Set<MarkupLanguage> getAllMarkupLanguages() {
        final HashSet<MarkupLanguage> markupLanguages = new HashSet<MarkupLanguage>();
        this.loadMarkupLanguages(new MarkupLanguageVisitor(){

            @Override
            public boolean accept(MarkupLanguage language) {
                markupLanguages.add(language);
                return true;
            }
        });
        return markupLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setImplementation(Class<? extends ServiceLocator> implementationClass) {
        Object object = implementationClassLock;
        synchronized (object) {
            ServiceLocator.implementationClass = implementationClass;
        }
    }

    private void loadMarkupLanguages(MarkupLanguageVisitor visitor) {
        for (ResourceDescriptor descriptor : this.discoverServiceResources()) {
            List<String> classNames = this.readServiceClassNames(descriptor.getUrl());
            for (String className : classNames) {
                try {
                    Class<?> clazz = this.loadClass(descriptor, className);
                    if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                        MarkupLanguage instance = (MarkupLanguage)clazz.newInstance();
                        if (visitor.accept(instance)) continue;
                        return;
                    }
                    if (!MarkupLanguageProvider.class.isAssignableFrom(clazz)) continue;
                    MarkupLanguageProvider provider = (MarkupLanguageProvider)clazz.newInstance();
                    for (MarkupLanguage language : provider.getMarkupLanguages()) {
                        if (visitor.accept(language)) continue;
                        return;
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(ServiceLocator.class.getName()).log(Level.WARNING, MessageFormat.format(Messages.getString("ServiceLocator.0"), className), e);
                }
            }
        }
    }

    protected Class<?> loadClass(ResourceDescriptor resource, String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.classLoader);
    }

    protected List<ResourceDescriptor> discoverServiceResources() {
        ArrayList serviceResources = Lists.newArrayList();
        for (String serviceResourceName : this.getClasspathServiceResourceNames()) {
            try {
                Enumeration<URL> resources = this.classLoader.getResources(serviceResourceName);
                while (resources.hasMoreElements()) {
                    serviceResources.add(new ResourceDescriptor(resources.nextElement()));
                }
            }
            catch (IOException e) {
                this.logReadServiceClassNamesFailure(e);
            }
        }
        return serviceResources;
    }

    protected List<String> getClasspathServiceResourceNames() {
        ArrayList paths = Lists.newArrayList();
        String[] stringArray = new String[]{"services/" + MarkupLanguage.class.getName(), "services/" + MarkupLanguageProvider.class.getName()};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            String[] stringArray2 = new String[]{"", "META-INF/"};
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String prefix = stringArray2[n4];
                paths.add(String.valueOf(prefix) + suffix);
                ++n4;
            }
            ++n2;
        }
        return ImmutableList.copyOf((Collection)paths);
    }

    protected List<String> readServiceClassNames(URL url) {
        InputStream stream = null;
        try {
            stream = url.openStream();
            List<String> list = this.readServiceClassNames(stream);
            return list;
        }
        catch (IOException e) {
            this.logReadServiceClassNamesFailure(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)stream);
        }
        return Collections.emptyList();
    }

    List<String> readServiceClassNames(InputStream stream) {
        ArrayList serviceClassNames;
        block6: {
            serviceClassNames = Lists.newArrayList();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        String className;
                        Matcher matcher = CLASS_NAME_PATTERN.matcher(line);
                        if (!matcher.matches() || (className = matcher.group(1)) == null) continue;
                        serviceClassNames.add(className);
                    }
                }
                catch (IOException e) {
                    this.logReadServiceClassNamesFailure(e);
                    Closeables.closeQuietly(reader);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)reader);
        }
        return serviceClassNames;
    }

    void logReadServiceClassNamesFailure(IOException e) {
        Logger.getLogger(ServiceLocator.class.getName()).log(Level.SEVERE, Messages.getString("ServiceLocator.1"), e);
    }

    private static interface MarkupLanguageVisitor {
        public boolean accept(MarkupLanguage var1);
    }

    protected static class ResourceDescriptor {
        private final URL url;

        public ResourceDescriptor(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url);
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

