/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.html.core.ElementMatcher;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanStrategy;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class FontElementStrategy
extends SpanHtmlElementStrategy {
    public FontElementStrategy() {
        super(new FontElementMatcher(), new FontSpanStrategy());
    }

    @Override
    public SpanStrategy spanStrategy() {
        return new FontSpanStrategy();
    }

    private static final class FontElementMatcher
    implements ElementMatcher<DocumentBuilder.SpanType> {
        private FontElementMatcher() {
        }

        @Override
        public boolean matches(DocumentBuilder.SpanType elementType, Attributes attributes) {
            String cssStyle;
            if (elementType == DocumentBuilder.SpanType.SPAN && (cssStyle = attributes.getCssStyle()) != null) {
                Iterator rules = new CssParser().createRuleIterator(cssStyle);
                while (rules.hasNext()) {
                    CssRule rule = (CssRule)rules.next();
                    if (!rule.name.equals("color") && !rule.name.equals("font-size") && !rule.name.equals("font-family")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class FontSpanStrategy
    implements SpanStrategy {
        private boolean elementOpened = false;

        private FontSpanStrategy() {
        }

        @Override
        public void beginSpan(DocumentBuilder builder, DocumentBuilder.SpanType type, Attributes attributes) {
            if (builder instanceof HtmlDocumentBuilder) {
                TreeMap fontAttributes = null;
                String cssStyle = attributes.getCssStyle();
                if (cssStyle != null) {
                    fontAttributes = Maps.newTreeMap();
                    Iterator rules = new CssParser().createRuleIterator(cssStyle);
                    while (rules.hasNext()) {
                        CssRule rule = (CssRule)rules.next();
                        if (rule.name.equals("color")) {
                            fontAttributes.put("color", rule.value);
                            continue;
                        }
                        if (rule.name.equals("font-size")) {
                            fontAttributes.put("size", rule.value);
                            continue;
                        }
                        if (!rule.name.equals("font-family")) continue;
                        fontAttributes.put("face", rule.value);
                    }
                }
                if (fontAttributes != null && !fontAttributes.isEmpty()) {
                    this.elementOpened = true;
                    HtmlDocumentBuilder htmlBuilder = (HtmlDocumentBuilder)builder;
                    XmlStreamWriter writer = htmlBuilder.getWriter();
                    writer.writeStartElement(htmlBuilder.getHtmlNsUri(), "font");
                    for (Map.Entry attribute : fontAttributes.entrySet()) {
                        writer.writeAttribute((String)attribute.getKey(), (String)attribute.getValue());
                    }
                }
            } else {
                builder.beginSpan(type, attributes);
            }
        }

        @Override
        public void endSpan(DocumentBuilder builder) {
            if (builder instanceof HtmlDocumentBuilder) {
                if (this.elementOpened) {
                    HtmlDocumentBuilder htmlBuilder = (HtmlDocumentBuilder)builder;
                    XmlStreamWriter writer = htmlBuilder.getWriter();
                    writer.writeEndElement();
                }
            } else {
                builder.endSpan();
            }
        }
    }
}

