/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.RowGroupExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModelListener;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

public class RowGroupExpandCollapseLayer<T>
extends AbstractRowHideShowLayer
implements IRowGroupModelListener {
    private final IRowGroupModel<T> model;

    public RowGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, IRowGroupModel<T> model) {
        super(underlyingLayer);
        this.model = model;
        model.registerRowGroupModelListener(this);
        this.registerCommandHandler(new RowGroupExpandCollapseCommandHandler(this));
    }

    public IRowGroupModel<T> getModel() {
        return this.model;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        boolean isCollapsedAndNotStaticRow;
        if (rowIndex >= this.model.getDataProvider().getRowCount()) {
            return true;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        boolean isHiddeninUnderlyingLayer = RowGroupUtils.isRowIndexHiddenInUnderLyingLayer(rowIndex, this, underlyingLayer);
        T row = this.model.getRowFromIndexCache(rowIndex);
        IRowGroup<T> rowGroup = this.model.getRowGroupForRow(row);
        if (rowGroup == null) {
            return true;
        }
        boolean bl = isCollapsedAndNotStaticRow = RowGroupUtils.isCollapsed(this.model, rowGroup) && !rowGroup.getOwnStaticMemberRows().contains(row);
        return isHiddeninUnderlyingLayer || isCollapsedAndNotStaticRow;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        HashSet<Integer> hiddenRowIndexes = new HashSet<Integer>();
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getRowCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(i);
            if (this.isRowIndexHidden(rowIndex)) {
                hiddenRowIndexes.add(rowIndex);
            }
            ++i;
        }
        return hiddenRowIndexes;
    }

    @Override
    public void rowGroupModelChanged() {
        this.invalidateCache();
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        this.model.invalidateIndexCache();
    }
}

