/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDialog<VIEWER extends Viewer>
extends TitleAreaDialog {
    public static final int DEFAULT_SHELL_STYLE = 1264;
    private String title;
    private String message;
    private Image image;
    private IDialogSettings settings;
    private VIEWER currentViewer;
    private MenuManager contextMenu;

    public BaseDialog(Shell parentShell, int shellStyle, String title, String message, IDialogSettings settings, ImageDescriptor descriptor) {
        super(parentShell);
        this.setShellStyle(shellStyle);
        this.title = title;
        this.message = message;
        this.settings = settings;
        if (descriptor != null) {
            this.image = descriptor.createImage((Device)parentShell.getDisplay());
        }
    }

    public BaseDialog(Shell parentShell, int shellStyle, String title, String message, IDialogSettings settings) {
        this(parentShell, 1264, title, message, settings, null);
    }

    public BaseDialog(Shell parentShell, String title, String message, IDialogSettings settings) {
        this(parentShell, 1264, title, message, settings);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        if (this.image != null) {
            this.setTitleImage(this.image);
        }
        this.contextMenu = new MenuManager("#PopupMenu");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object viewer = BaseDialog.this.getCurrentViewer();
                if (viewer != null) {
                    BaseDialog.this.fillContextMenu(manager, viewer);
                }
            }
        });
        this.createUI(composite);
        return composite;
    }

    protected abstract void createUI(Composite var1);

    public VIEWER getCurrentViewer() {
        return this.currentViewer;
    }

    public void setCurrentViewer(VIEWER currentViewer) {
        Control control;
        if (this.currentViewer != null) {
            control = this.currentViewer.getControl();
            control.setMenu(null);
        }
        this.currentViewer = currentViewer;
        if (this.currentViewer != null) {
            control = this.currentViewer.getControl();
            Menu menu = this.contextMenu.createContextMenu(control);
            control.setMenu(menu);
        }
    }

    protected void hookContextMenu() {
        this.contextMenu = new MenuManager("#PopupMenu");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BaseDialog.this.fillContextMenu(manager, BaseDialog.this.getCurrentViewer());
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager, VIEWER viewer) {
    }

    protected IDialogSettings getDialogSettings() {
        return this.settings;
    }

    protected IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return null;
        }
        sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + sectionName;
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings("bounds");
    }

    public boolean close() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        return super.close();
    }
}

