/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.ArrayList;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmWritableBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.StackBalanceAnalyzer;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MoveCodeToCallOrigAdapter
extends AbstractTransformableClassNode {
    private Method method;
    private int boundMethodId;
    private int firstArgIndex;
    private int argOffset;
    private Method callOrig;

    public MoveCodeToCallOrigAdapter(AsmWritableBoundClass clazz, Method method, int boundMethodId) {
        this.method = method;
        this.boundMethodId = boundMethodId;
        if (method.isStatic()) {
            this.firstArgIndex = 0;
            this.argOffset = clazz.isRole() ? 2 : 0;
            this.callOrig = clazz.getCallOrigStatic();
        } else {
            this.firstArgIndex = 1;
            this.callOrig = ConstantMembers.callOrig;
        }
    }

    @Override
    public boolean transform() {
        MethodNode orgMethod = this.getMethod(this.method);
        if ((orgMethod.access & 0x400) != 0) {
            return false;
        }
        MethodNode callOrig = this.getMethod(this.callOrig);
        Type returnType = Type.getReturnType((String)orgMethod.desc);
        InsnList newInstructions = new InsnList();
        Type[] args = Type.getArgumentTypes((String)orgMethod.desc);
        int boundMethodIdSlot = this.firstArgIndex;
        if (args.length > 0) {
            newInstructions.add((AbstractInsnNode)new IntInsnNode(21, boundMethodIdSlot));
            boundMethodIdSlot = callOrig.maxLocals + 1;
            newInstructions.add((AbstractInsnNode)new IntInsnNode(54, boundMethodIdSlot));
            newInstructions.add((AbstractInsnNode)new IntInsnNode(25, this.firstArgIndex + this.argOffset + 1));
            int slot = this.firstArgIndex + this.argOffset;
            int i = this.argOffset;
            while (i < args.length) {
                if (i < args.length - 1) {
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                }
                newInstructions.add(this.createLoadIntConstant(i));
                newInstructions.add((AbstractInsnNode)new InsnNode(50));
                Type arg = args[i];
                if (arg.getSort() != 9 && arg.getSort() != 10) {
                    String objectType = AsmTypeHelper.getObjectType(arg);
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                    newInstructions.add(AsmTypeHelper.getUnboxingInstructionForType(arg, objectType));
                } else {
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, arg.getInternalName()));
                }
                newInstructions.add((AbstractInsnNode)new IntInsnNode(args[i].getOpcode(54), slot));
                slot += arg.getSize();
                ++i;
            }
        }
        this.adjustSuperCalls(orgMethod.instructions, orgMethod.name, args, returnType, boundMethodIdSlot);
        this.replaceReturn(orgMethod.instructions, returnType);
        newInstructions.add(orgMethod.instructions);
        this.addNewLabelToSwitch(callOrig.instructions, newInstructions, this.boundMethodId);
        callOrig.maxStack = Math.max(Math.max(callOrig.maxStack, orgMethod.maxStack), 3);
        if (returnType.getSort() == 0) {
            ++callOrig.maxStack;
        }
        callOrig.maxLocals = Math.max(callOrig.maxLocals, orgMethod.maxLocals);
        return true;
    }

    private void adjustSuperCalls(InsnList instructions, String selector, Type[] args, Type returnType, int boundMethodIdSlot) {
        ArrayList<MethodInsnNode> toReplace = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode orgMethodNode : instructions) {
            if (orgMethodNode.getOpcode() != 183 || !((MethodInsnNode)orgMethodNode).name.equals(selector)) continue;
            toReplace.add((MethodInsnNode)orgMethodNode);
        }
        if (toReplace.isEmpty()) {
            return;
        }
        for (MethodInsnNode oldNode : toReplace) {
            AbstractInsnNode[] insertionPoints = StackBalanceAnalyzer.findInsertionPointsBefore((AbstractInsnNode)oldNode, args);
            MethodInsnNode firstInsert = insertionPoints.length > 0 ? insertionPoints[0] : oldNode;
            instructions.insertBefore((AbstractInsnNode)firstInsert, (AbstractInsnNode)new IntInsnNode(21, boundMethodIdSlot));
            instructions.insertBefore((AbstractInsnNode)firstInsert, (AbstractInsnNode)new IntInsnNode(16, args.length));
            instructions.insertBefore((AbstractInsnNode)firstInsert, (AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
            int i = 0;
            while (i < insertionPoints.length) {
                instructions.insertBefore(insertionPoints[i], (AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insertionPoints[i], (AbstractInsnNode)new IntInsnNode(16, i));
                MethodInsnNode insertAt = i + 1 < insertionPoints.length ? insertionPoints[i + 1] : oldNode;
                instructions.insertBefore((AbstractInsnNode)insertAt, AsmTypeHelper.getBoxingInstructionForType(args[i]));
                instructions.insertBefore((AbstractInsnNode)insertAt, (AbstractInsnNode)new InsnNode(83));
                ++i;
            }
            if (returnType == Type.VOID_TYPE) {
                instructions.insert((AbstractInsnNode)oldNode, (AbstractInsnNode)new InsnNode(87));
            } else {
                instructions.insert((AbstractInsnNode)oldNode, AsmTypeHelper.getUnboxingInstructionForType(returnType));
            }
            instructions.set((AbstractInsnNode)oldNode, (AbstractInsnNode)new MethodInsnNode(183, oldNode.owner, this.callOrig.getName(), this.callOrig.getSignature()));
        }
    }
}

