/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAccumulator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoolean;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcorePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGFinalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInteger;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNavigationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGReal;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePartCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.IterationHelper;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.library.oclany.OclAnyEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyNotEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclIsInvalidOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclIsUndefinedOperation;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.ecore.EObjectOperation;
import org.eclipse.ocl.examples.pivot.ecore.EObjectProperty;
import org.eclipse.ocl.examples.pivot.internal.impl.TuplePartImpl;
import org.eclipse.ocl.examples.pivot.library.CompositionProperty;
import org.eclipse.ocl.examples.pivot.library.ConstrainedOperation;
import org.eclipse.ocl.examples.pivot.library.ConstrainedProperty;
import org.eclipse.ocl.examples.pivot.library.EInvokeOperation;
import org.eclipse.ocl.examples.pivot.library.ExplicitNavigationProperty;
import org.eclipse.ocl.examples.pivot.library.ImplicitNonCompositionProperty;
import org.eclipse.ocl.examples.pivot.library.StaticProperty;
import org.eclipse.ocl.examples.pivot.library.StereotypeProperty;
import org.eclipse.ocl.examples.pivot.library.TuplePartProperty;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class AS2CGVisitor
extends AbstractExtendingVisitor<CGNamedElement, CodeGenAnalyzer> {
    @NonNull
    protected final CodeGenerator codeGenerator;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final GenModelHelper genModelHelper;
    @NonNull
    private Variables variablesStack = new Variables(null);
    @NonNull
    private Map<OpaqueExpression, ExpressionInOCL> inlinePrototypes = new HashMap<OpaqueExpression, ExpressionInOCL>();

    public AS2CGVisitor(@NonNull CodeGenAnalyzer analyzer) {
        super((Object)analyzer);
        this.codeGenerator = ((CodeGenAnalyzer)this.context).getCodeGenerator();
        this.metaModelManager = this.codeGenerator.getMetaModelManager();
        this.genModelHelper = this.codeGenerator.getGenModelHelper();
    }

    protected void addParameter(@NonNull Variable aParameter, @NonNull CGParameter cgParameter) {
        this.variablesStack.putParameter(aParameter, cgParameter);
    }

    @Nullable
    public CGVariable basicGetParameter(@NonNull Variable aParameter) {
        return this.variablesStack.getParameter(aParameter);
    }

    @NonNull
    public CGVariable createCGVariable(@NonNull Variable asVariable) {
        CGVariable cgVariable = this.variablesStack.getVariable((VariableDeclaration)asVariable);
        if (cgVariable == null) {
            CGFinalVariable cgVariable2 = CGModelFactory.eINSTANCE.createCGFinalVariable();
            cgVariable = cgVariable2;
            this.variablesStack.putVariable((VariableDeclaration)asVariable, cgVariable);
        } else assert (cgVariable.eContainer() == null);
        this.setAst(cgVariable, (TypedElement)asVariable);
        return cgVariable;
    }

    protected CGVariable createCGVariable(@NonNull Variable contextVariable, @NonNull OCLExpression source) {
        CGVariable cgVariable = this.createCGVariable(contextVariable);
        cgVariable.setInit((CGValuedElement)source.accept((Visitor)this));
        return cgVariable;
    }

    @NonNull
    public <T extends CGElement> T doVisit(@NonNull java.lang.Class<T> requiredClass, @Nullable Element pElement) {
        if (pElement == null) {
            throw new NullPointerException("null source for mapping to " + requiredClass.getName());
        }
        CGNamedElement cgElement = (CGNamedElement)pElement.accept((Visitor)this);
        if (cgElement == null) {
            throw new NullPointerException("null result of mapping to " + requiredClass.getName());
        }
        java.lang.Class<?> actualClass = cgElement.getClass();
        if (!requiredClass.isAssignableFrom(actualClass)) {
            throw new ClassCastException("cannot cast " + actualClass.getName() + " result of mapping to " + requiredClass.getName());
        }
        CGNamedElement cgElement2 = cgElement;
        return (T)cgElement2;
    }

    @NonNull
    public CodeGenAnalyzer getAnalyzer() {
        return (CodeGenAnalyzer)this.context;
    }

    @NonNull
    public CGIterator getIterator(@NonNull VariableDeclaration asVariable) {
        CGParameter cgParameter = (CGParameter)this.variablesStack.getVariable(asVariable);
        if (cgParameter == null) {
            cgParameter = CGModelFactory.eINSTANCE.createCGIterator();
            this.setAst(cgParameter, (TypedElement)asVariable);
            cgParameter.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)TypeId.OCL_VOID));
            this.variablesStack.putVariable(asVariable, cgParameter);
        }
        return (CGIterator)cgParameter;
    }

    @NonNull
    public CGVariable getLocalVariable(@NonNull VariableDeclaration asVariable) {
        CGVariable cgVariable = this.variablesStack.getLocalVariable(asVariable);
        if (cgVariable == null) {
            cgVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
            this.setAst(cgVariable, (TypedElement)asVariable);
            this.variablesStack.putVariable(asVariable, cgVariable);
        }
        return cgVariable;
    }

    @NonNull
    public CGParameter getParameter(@NonNull Variable aParameter) {
        CGParameter cgParameter = this.variablesStack.getParameter(aParameter);
        if (cgParameter == null) {
            cgParameter = CGModelFactory.eINSTANCE.createCGParameter();
            ((CodeGenAnalyzer)this.context).setNames(cgParameter, aParameter);
            this.setAst(cgParameter, (TypedElement)aParameter);
            cgParameter.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)TypeId.OCL_VOID));
            this.addParameter(aParameter, cgParameter);
            cgParameter.setRequired(aParameter.isRequired());
            if (aParameter.isRequired()) {
                cgParameter.setNonNull();
            }
        }
        return cgParameter;
    }

    @NonNull
    public CGParameter getSelfParameter(@NonNull Variable aParameter) {
        return this.getParameter(aParameter);
    }

    @NonNull
    public CGVariable getVariable(@NonNull VariableDeclaration asVariable) {
        CGVariable cgVariable = this.variablesStack.getVariable(asVariable);
        if (cgVariable == null) {
            cgVariable = CGModelFactory.eINSTANCE.createCGFinalVariable();
            this.setAst(cgVariable, (TypedElement)asVariable);
            this.variablesStack.putVariable(asVariable, cgVariable);
        }
        return cgVariable;
    }

    @NonNull
    public Variables getVariablesStack() {
        return this.variablesStack;
    }

    @Nullable
    protected CGValuedElement inlineOperationCall(@NonNull OperationCallExp callExp, @NonNull OpaqueExpression bodyExpression) {
        ExpressionInOCL prototype = this.inlinePrototypes.get(bodyExpression);
        if (prototype == null) {
            try {
                prototype = PivotUtil.getExpressionInOCL((MetaModelManager)this.metaModelManager, (OpaqueExpression)bodyExpression);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (prototype == null) {
                return null;
            }
            this.inlinePrototypes.put(bodyExpression, prototype);
        }
        this.variablesStack = new Variables(this.variablesStack);
        try {
            CGVariable cgParameterVariable;
            Variable parameterVariable;
            Variable contextVariable = (Variable)DomainUtil.nonNullModel((Object)prototype.getContextVariable());
            CGVariable cgContextVariable = this.getLocalVariable((VariableDeclaration)contextVariable);
            OCLExpression source = callExp.getSource();
            CGValuedElement cgSource = this.doVisit(CGValuedElement.class, (Element)source);
            cgContextVariable.setInit(cgSource);
            cgSource.setName(cgContextVariable.getName());
            List arguments = callExp.getArgument();
            List parameterVariables = prototype.getParameterVariable();
            int iMax = Math.min(arguments.size(), parameterVariables.size());
            int i = 0;
            while (i < iMax) {
                OCLExpression argument = (OCLExpression)arguments.get(i);
                CGValuedElement cgArgument = this.doVisit(CGValuedElement.class, (Element)argument);
                parameterVariable = (Variable)parameterVariables.get(i);
                cgParameterVariable = this.getLocalVariable((VariableDeclaration)parameterVariable);
                cgParameterVariable.setInit(cgArgument);
                cgArgument.setName(cgParameterVariable.getName());
                ++i;
            }
            CGLetExp cgOuterLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
            cgOuterLetExp.setInit(cgContextVariable);
            cgOuterLetExp.setAst((Element)callExp);
            CGLetExp cgInnerLetExp = cgOuterLetExp;
            int i2 = iMax - 1;
            while (i2 >= 0) {
                parameterVariable = (Variable)parameterVariables.get(i2);
                cgParameterVariable = this.getVariable((VariableDeclaration)parameterVariable);
                CGLetExp cgLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
                cgLetExp.setInit(cgParameterVariable);
                cgLetExp.setAst((Element)callExp);
                cgInnerLetExp.setIn(cgLetExp);
                cgInnerLetExp = cgLetExp;
                --i2;
            }
            CGValuedElement cgResult = this.doVisit(CGValuedElement.class, (Element)prototype.getBodyExpression());
            boolean isValidating = callExp.getReferredOperation().isValidating();
            if (!isValidating) {
                int i3 = iMax - 1;
                while (i3 >= 0) {
                    Variable parameterVariable2 = (Variable)parameterVariables.get(i3);
                    CGVariable cgParameterVariable2 = this.getVariable((VariableDeclaration)parameterVariable2);
                    CGValuedElement cgArgument = cgParameterVariable2.getInit();
                    if (!cgArgument.isNonInvalid()) {
                        CGThrowExp cgThrowExp = CGModelFactory.eINSTANCE.createCGThrowExp();
                        cgThrowExp.setTypeId(cgResult.getTypeId());
                        cgThrowExp.setAst(cgResult.getAst());
                        cgThrowExp.setSource(cgArgument);
                        cgResult = cgThrowExp;
                    }
                    --i3;
                }
            }
            cgInnerLetExp.setIn(cgResult);
            CGValuedElement cgLetExp = cgOuterLetExp;
            while (cgLetExp != cgResult) {
                cgLetExp.setTypeId(cgResult.getTypeId());
                cgLetExp = cgLetExp.getIn();
            }
            CGLetExp cGLetExp = cgOuterLetExp;
            return cGLetExp;
        }
        finally {
            Variables outerVariables = this.variablesStack.outerVariables;
            if (outerVariables != null) {
                this.variablesStack = outerVariables;
            }
        }
    }

    protected boolean isEcoreProperty(@NonNull LibraryProperty libraryProperty) {
        return libraryProperty instanceof ExplicitNavigationProperty || libraryProperty instanceof CompositionProperty || libraryProperty instanceof ImplicitNonCompositionProperty || libraryProperty instanceof StaticProperty || libraryProperty instanceof StereotypeProperty || libraryProperty instanceof ConstrainedProperty || libraryProperty instanceof EObjectProperty;
    }

    protected void setAst(@NonNull CGNamedElement cgElement, @NonNull NamedElement asElement) {
        cgElement.setAst((Element)asElement);
        cgElement.setName(asElement.getName());
    }

    protected void setAst(@NonNull CGTypedElement cgElement, @NonNull TypedElement asElement) {
        cgElement.setAst((Element)asElement);
        TypeId asTypeId = asElement.getTypeId();
        cgElement.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asTypeId));
        cgElement.setName(asElement.getName());
    }

    @Nullable
    public CGConstantExp visitBooleanLiteralExp(@NonNull BooleanLiteralExp element) {
        CGBoolean constant = ((CodeGenAnalyzer)this.context).getBoolean(element.isBooleanSymbol());
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, constant);
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @Nullable
    public CGClass visitClass(@NonNull Class element) {
        CGClass cgClass = CGModelFactory.eINSTANCE.createCGClass();
        this.setAst(cgClass, (NamedElement)element);
        for (Constraint asConstraint : element.getOwnedInvariant()) {
            CGConstraint cgConstraint = this.doVisit(CGConstraint.class, (Element)asConstraint);
            cgClass.getInvariants().add(cgConstraint);
        }
        for (Operation asOperation : element.getOwnedOperation()) {
            CGOperation cgOperation = this.doVisit(CGOperation.class, (Element)asOperation);
            cgClass.getOperations().add(cgOperation);
        }
        for (Property asProperty : element.getOwnedAttribute()) {
            CGProperty cgProperty = this.doVisit(CGProperty.class, (Element)asProperty);
            cgClass.getProperties().add(cgProperty);
        }
        return cgClass;
    }

    @Nullable
    public CGCollectionPart visitCollectionItem(@NonNull CollectionItem element) {
        CGCollectionPart cgCollectionPart = CGModelFactory.eINSTANCE.createCGCollectionPart();
        this.setAst(cgCollectionPart, (TypedElement)element);
        cgCollectionPart.setFirst(this.doVisit(CGValuedElement.class, (Element)element.getItem()));
        return cgCollectionPart;
    }

    @Nullable
    public CGCollectionExp visitCollectionLiteralExp(@NonNull CollectionLiteralExp element) {
        CGCollectionExp cgCollectionExp = CGModelFactory.eINSTANCE.createCGCollectionExp();
        this.setAst(cgCollectionExp, (TypedElement)element);
        cgCollectionExp.setName(element.getKind().getName());
        List<CGCollectionPart> cgParts = cgCollectionExp.getParts();
        for (CollectionLiteralPart asPart : element.getPart()) {
            cgParts.add((CGCollectionPart)asPart.accept((Visitor)this));
        }
        ((CodeGenAnalyzer)this.context).getTypeId(element.getTypeId());
        return cgCollectionExp;
    }

    @Nullable
    public CGCollectionPart visitCollectionRange(@NonNull CollectionRange element) {
        CGCollectionPart cgCollectionPart = CGModelFactory.eINSTANCE.createCGCollectionPart();
        this.setAst(cgCollectionPart, (TypedElement)element);
        cgCollectionPart.setFirst(this.doVisit(CGValuedElement.class, (Element)element.getFirst()));
        cgCollectionPart.setLast(this.doVisit(CGValuedElement.class, (Element)element.getLast()));
        cgCollectionPart.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)TypeId.INTEGER_RANGE));
        return cgCollectionPart;
    }

    @Nullable
    public CGConstraint visitConstraint(@NonNull Constraint element) {
        ExpressionInOCL expressionInOCL;
        CGConstraint cgConstraint = CGModelFactory.eINSTANCE.createCGConstraint();
        this.setAst((CGNamedElement)cgConstraint, (NamedElement)element);
        OpaqueExpression specification = element.getSpecification();
        if (specification != null && (expressionInOCL = PivotUtil.getExpressionInOCL((MetaModelManager)this.metaModelManager, (OpaqueExpression)specification)) != null) {
            Variable contextVariable = expressionInOCL.getContextVariable();
            if (contextVariable != null) {
                CGParameter cgParameter = this.getSelfParameter(contextVariable);
                cgConstraint.getParameters().add(cgParameter);
            }
            for (Variable parameterVariable : expressionInOCL.getParameterVariable()) {
                CGParameter cgParameter = this.getParameter(parameterVariable);
                cgConstraint.getParameters().add(cgParameter);
            }
            cgConstraint.setBody(this.doVisit(CGValuedElement.class, (Element)expressionInOCL.getBodyExpression()));
        }
        return cgConstraint;
    }

    @Nullable
    public CGConstructorExp visitConstructorExp(@NonNull ConstructorExp element) {
        CGConstructorExp cgConstructorExp = null;
        Type type = element.getType();
        if (type != null) {
            CGConstructorExp cgEConstructorExp;
            EObject eTarget = type.getETarget();
            if (eTarget instanceof EDataType) {
                cgEConstructorExp = CGModelFactory.eINSTANCE.createCGEcoreDataTypeConstructorExp();
                cgEConstructorExp.setEDataType((EDataType)eTarget);
                cgEConstructorExp.setString(element.getValue());
                cgConstructorExp = cgEConstructorExp;
            } else if (eTarget instanceof EClass) {
                cgEConstructorExp = CGModelFactory.eINSTANCE.createCGEcoreClassConstructorExp();
                cgEConstructorExp.setEClass((EClass)eTarget);
                cgConstructorExp = cgEConstructorExp;
            }
        }
        if (cgConstructorExp != null) {
            CGExecutorType cgExecutorType = ((CodeGenAnalyzer)this.context).createExecutorType((Type)DomainUtil.nonNullState((Object)element.getType()));
            cgConstructorExp.setExecutorType(cgExecutorType);
            cgConstructorExp.getOwns().add(cgExecutorType);
            this.setAst(cgConstructorExp, (TypedElement)element);
            List<CGConstructorPart> cgParts = cgConstructorExp.getParts();
            for (ConstructorPart asPart : element.getPart()) {
                cgParts.add((CGConstructorPart)asPart.accept((Visitor)this));
            }
        }
        return cgConstructorExp;
    }

    @Nullable
    public CGConstructorPart visitConstructorPart(@NonNull ConstructorPart element) {
        CGConstructorPart cgConstructorPart = CGModelFactory.eINSTANCE.createCGConstructorPart();
        this.setAst(cgConstructorPart, (TypedElement)element);
        cgConstructorPart.setInit(this.doVisit(CGValuedElement.class, (Element)element.getInitExpression()));
        Property referredProperty = element.getReferredProperty();
        if (referredProperty != null) {
            CGExecutorConstructorPart cgExecutorConstructorPart = ((CodeGenAnalyzer)this.context).createExecutorConstructorPart(referredProperty);
            cgConstructorPart.setExecutorPart(cgExecutorConstructorPart);
        }
        return cgConstructorPart;
    }

    @Nullable
    public CGConstantExp visitEnumLiteralExp(@NonNull EnumLiteralExp element) {
        CGElementId constant = ((CodeGenAnalyzer)this.context).getElementId((ElementId)element.getReferredEnumLiteral().getEnumerationLiteralId());
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, constant);
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @NonNull
    public CGValuedElement visitExpressionInOCL(@NonNull ExpressionInOCL element) {
        Variable contextVariable = element.getContextVariable();
        if (contextVariable != null) {
            CGParameter cgContext = this.getParameter(contextVariable);
            cgContext.setNonInvalid();
        }
        for (Variable parameterVariable : element.getParameterVariable()) {
            CGParameter cGParameter = this.getParameter(parameterVariable);
        }
        CGValuedElement cgBody = this.doVisit(CGValuedElement.class, (Element)element.getBodyExpression());
        return cgBody;
    }

    @NonNull
    public CGIfExp visitIfExp(@NonNull IfExp element) {
        CGIfExp cgIfExp = CGModelFactory.eINSTANCE.createCGIfExp();
        this.setAst(cgIfExp, (TypedElement)element);
        CGValuedElement cgCondition = this.doVisit(CGValuedElement.class, (Element)element.getCondition());
        CGValuedElement cgThenExpression = this.doVisit(CGValuedElement.class, (Element)element.getThenExpression());
        CGValuedElement cgElseExpression = this.doVisit(CGValuedElement.class, (Element)element.getElseExpression());
        cgIfExp.setCondition(cgCondition);
        cgIfExp.setThenExpression(cgThenExpression);
        cgIfExp.setElseExpression(cgElseExpression);
        return cgIfExp;
    }

    @Nullable
    public CGConstantExp visitIntegerLiteralExp(@NonNull IntegerLiteralExp element) {
        Number integerSymbol = element.getIntegerSymbol();
        CGInteger constant = ((CodeGenAnalyzer)this.context).getInteger(integerSymbol != null ? (Number)integerSymbol : (Number)0);
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, constant);
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @Nullable
    public CGConstantExp visitInvalidLiteralExp(@NonNull InvalidLiteralExp element) {
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getInvalid());
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @NonNull
    public CGIterationCallExp visitIterateExp(@NonNull IterateExp element) {
        Iteration asIteration = element.getReferredIteration();
        CGValuedElement cgSource = this.doVisit(CGValuedElement.class, (Element)element.getSource());
        LibraryIteration libraryIteration = (LibraryIteration)asIteration.getImplementation();
        IterationHelper iterationHelper = this.codeGenerator.getIterationHelper(asIteration);
        if (iterationHelper != null) {
            CGBuiltInIterationCallExp cgBuiltInIterationCallExp = CGModelFactory.eINSTANCE.createCGBuiltInIterationCallExp();
            cgBuiltInIterationCallExp.setReferredIteration(asIteration);
            cgBuiltInIterationCallExp.setSource(cgSource);
            for (Variable iterator : element.getIterator()) {
                CGIterator cgIterator = this.getIterator((VariableDeclaration)iterator);
                cgIterator.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(iterator.getTypeId()));
                cgIterator.setRequired(iterator.isRequired());
                if (iterator.isRequired()) {
                    cgIterator.setNonNull();
                }
                cgIterator.setNonInvalid();
                cgBuiltInIterationCallExp.getIterators().add(cgIterator);
            }
            if (((Parameter)asIteration.getOwnedParameter().get(0)).isRequired()) {
                cgBuiltInIterationCallExp.getBody().setRequired(true);
            }
            cgBuiltInIterationCallExp.setInvalidating(false);
            cgBuiltInIterationCallExp.setValidating(false);
            this.setAst(cgBuiltInIterationCallExp, (TypedElement)element);
            Variable accumulator = element.getResult();
            CGIterator cgAccumulator = this.getIterator((VariableDeclaration)accumulator);
            cgAccumulator.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(accumulator.getTypeId()));
            cgAccumulator.setRequired(accumulator.isRequired());
            if (accumulator.isRequired()) {
                cgAccumulator.setNonNull();
            }
            cgAccumulator.setInit(this.doVisit(CGValuedElement.class, (Element)accumulator.getInitExpression()));
            cgAccumulator.setNonInvalid();
            cgBuiltInIterationCallExp.setAccumulator(cgAccumulator);
            cgBuiltInIterationCallExp.setBody(this.doVisit(CGValuedElement.class, (Element)element.getBody()));
            return cgBuiltInIterationCallExp;
        }
        CGLibraryIterateCallExp cgLibraryIterateCallExp = CGModelFactory.eINSTANCE.createCGLibraryIterateCallExp();
        cgLibraryIterateCallExp.setLibraryIteration(libraryIteration);
        cgLibraryIterateCallExp.setReferredIteration(asIteration);
        this.setAst(cgLibraryIterateCallExp, (TypedElement)element);
        cgLibraryIterateCallExp.setInvalidating(asIteration.isInvalidating());
        cgLibraryIterateCallExp.setValidating(asIteration.isValidating());
        cgLibraryIterateCallExp.setSource(cgSource);
        for (Variable iterator : element.getIterator()) {
            cgLibraryIterateCallExp.getIterators().add(this.getIterator((VariableDeclaration)iterator));
        }
        Variable result = element.getResult();
        if (result != null) {
            CGIterator cgResult = this.getIterator((VariableDeclaration)result);
            cgLibraryIterateCallExp.setResult(cgResult);
            CGValuedElement cgInitExpression = this.doVisit(CGValuedElement.class, (Element)result.getInitExpression());
            cgResult.setInit(cgInitExpression);
        }
        cgLibraryIterateCallExp.setBody(this.doVisit(CGValuedElement.class, (Element)element.getBody()));
        cgLibraryIterateCallExp.setRequired(asIteration.isRequired());
        return cgLibraryIterateCallExp;
    }

    @NonNull
    public CGIterationCallExp visitIteratorExp(@NonNull IteratorExp element) {
        Iteration asIteration = element.getReferredIteration();
        CGValuedElement cgSource = this.doVisit(CGValuedElement.class, (Element)element.getSource());
        LibraryIteration libraryIteration = (LibraryIteration)asIteration.getImplementation();
        IterationHelper iterationHelper = this.codeGenerator.getIterationHelper(asIteration);
        if (iterationHelper != null) {
            CGBuiltInIterationCallExp cgBuiltInIterationCallExp = CGModelFactory.eINSTANCE.createCGBuiltInIterationCallExp();
            cgBuiltInIterationCallExp.setReferredIteration(asIteration);
            cgBuiltInIterationCallExp.setSource(cgSource);
            for (Variable iterator : element.getIterator()) {
                CGIterator cgIterator = this.getIterator((VariableDeclaration)iterator);
                cgIterator.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(iterator.getTypeId()));
                cgIterator.setRequired(iterator.isRequired());
                if (iterator.isRequired()) {
                    cgIterator.setNonNull();
                }
                cgBuiltInIterationCallExp.getIterators().add(cgIterator);
            }
            cgBuiltInIterationCallExp.setInvalidating(false);
            cgBuiltInIterationCallExp.setValidating(false);
            this.setAst(cgBuiltInIterationCallExp, (TypedElement)element);
            CGTypeId cgAccumulatorId = iterationHelper.getAccumulatorTypeId((CodeGenAnalyzer)this.context, cgBuiltInIterationCallExp);
            if (cgAccumulatorId != null) {
                CGAccumulator cgAccumulator = CGModelFactory.eINSTANCE.createCGAccumulator();
                cgAccumulator.setName("accumulator");
                cgAccumulator.setTypeId(cgAccumulatorId);
                if (asIteration.isRequired() || element.getBody().isRequired()) {
                    cgAccumulator.setNonNull();
                    cgBuiltInIterationCallExp.setNonNull();
                }
                if (!asIteration.isValidating()) {
                    cgAccumulator.setNonInvalid();
                }
                cgBuiltInIterationCallExp.setAccumulator(cgAccumulator);
            }
            cgBuiltInIterationCallExp.setBody(this.doVisit(CGValuedElement.class, (Element)element.getBody()));
            if (((Parameter)asIteration.getOwnedParameter().get(0)).isRequired()) {
                cgBuiltInIterationCallExp.getBody().setRequired(true);
            }
            cgBuiltInIterationCallExp.setRequired(asIteration.isRequired());
            return cgBuiltInIterationCallExp;
        }
        CGLibraryIterationCallExp cgLibraryIterationCallExp = CGModelFactory.eINSTANCE.createCGLibraryIterationCallExp();
        cgLibraryIterationCallExp.setLibraryIteration(libraryIteration);
        cgLibraryIterationCallExp.setReferredIteration(asIteration);
        this.setAst(cgLibraryIterationCallExp, (TypedElement)element);
        cgLibraryIterationCallExp.setInvalidating(asIteration.isInvalidating());
        cgLibraryIterationCallExp.setValidating(asIteration.isValidating());
        cgLibraryIterationCallExp.setSource(cgSource);
        for (Variable iterator : element.getIterator()) {
            cgLibraryIterationCallExp.getIterators().add(this.getIterator((VariableDeclaration)iterator));
        }
        cgLibraryIterationCallExp.setBody(this.doVisit(CGValuedElement.class, (Element)element.getBody()));
        cgLibraryIterationCallExp.setRequired(asIteration.isRequired());
        return cgLibraryIterationCallExp;
    }

    @Nullable
    public CGLetExp visitLetExp(@NonNull LetExp element) {
        CGLetExp cgLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
        this.setAst(cgLetExp, (TypedElement)element);
        Variable variable = element.getVariable();
        CGValuedElement initExpression = this.doVisit(CGValuedElement.class, (Element)variable.getInitExpression());
        initExpression.setName(variable.getName());
        CGFinalVariable cgVariable = (CGFinalVariable)this.createCGVariable(variable);
        cgVariable.setInit(initExpression);
        cgLetExp.setInit(cgVariable);
        cgLetExp.setIn(this.doVisit(CGValuedElement.class, (Element)element.getIn()));
        return cgLetExp;
    }

    @Nullable
    public CGConstantExp visitNullLiteralExp(@NonNull NullLiteralExp element) {
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getNull());
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @Nullable
    public CGOperation visitOperation(@NonNull Operation element) {
        ExpressionInOCL expressionInOCL;
        EOperation eOperation;
        CGOperation cgOperation = null;
        LibraryOperation libraryOperation = this.metaModelManager.getImplementation(element);
        if (libraryOperation instanceof EObjectOperation && (eOperation = (EOperation)element.getETarget()) != null) {
            CGEcoreOperation cgEcoreOperation = CGModelFactory.eINSTANCE.createCGEcoreOperation();
            cgEcoreOperation.setEOperation(eOperation);
            cgOperation = cgEcoreOperation;
        }
        if (cgOperation == null) {
            cgOperation = CGModelFactory.eINSTANCE.createCGLibraryOperation();
        }
        this.setAst(cgOperation, (TypedElement)element);
        cgOperation.setRequired(element.isRequired());
        OpaqueExpression specification = element.getBodyExpression();
        if (specification != null && (expressionInOCL = PivotUtil.getExpressionInOCL((MetaModelManager)this.metaModelManager, (OpaqueExpression)specification)) != null) {
            Variable contextVariable = expressionInOCL.getContextVariable();
            if (contextVariable != null) {
                CGParameter cgParameter = this.getSelfParameter(contextVariable);
                cgOperation.getParameters().add(cgParameter);
            }
            for (Variable parameterVariable : expressionInOCL.getParameterVariable()) {
                CGParameter cgParameter = this.getParameter(parameterVariable);
                cgOperation.getParameters().add(cgParameter);
            }
            cgOperation.setBody(this.doVisit(CGValuedElement.class, (Element)expressionInOCL.getBodyExpression()));
        }
        return cgOperation;
    }

    @NonNull
    public CGValuedElement visitOperationCallExp(@NonNull OperationCallExp element) {
        CGValuedElement cgOperationCallExp;
        OpaqueExpression bodyExpression;
        DomainOperation finalOperation;
        Operation asOperation = (Operation)DomainUtil.nonNullState((Object)element.getReferredOperation());
        OCLExpression pSource = element.getSource();
        boolean isRequired = asOperation.isRequired();
        CGValuedElement cgSource = pSource != null ? this.doVisit(CGValuedElement.class, (Element)pSource) : null;
        LibraryOperation libraryOperation = this.metaModelManager.getImplementation(asOperation);
        if (libraryOperation instanceof OclAnyOclIsInvalidOperation) {
            CGIsInvalidExp cgIsInvalidExp = CGModelFactory.eINSTANCE.createCGIsInvalidExp();
            cgIsInvalidExp.setSource(cgSource);
            this.setAst(cgIsInvalidExp, (TypedElement)element);
            cgIsInvalidExp.setInvalidating(false);
            cgIsInvalidExp.setValidating(true);
            return cgIsInvalidExp;
        }
        if (libraryOperation instanceof OclAnyOclIsUndefinedOperation) {
            CGIsUndefinedExp cgIsUndefinedExp = CGModelFactory.eINSTANCE.createCGIsUndefinedExp();
            cgIsUndefinedExp.setSource(cgSource);
            this.setAst(cgIsUndefinedExp, (TypedElement)element);
            cgIsUndefinedExp.setInvalidating(false);
            cgIsUndefinedExp.setValidating(true);
            return cgIsUndefinedExp;
        }
        if (libraryOperation instanceof OclAnyEqualOperation) {
            OCLExpression pArgument = (OCLExpression)element.getArgument().get(0);
            CGValuedElement cgArgument = pArgument != null ? this.doVisit(CGValuedElement.class, (Element)pArgument) : null;
            CGIsEqualExp cgIsEqualExp = CGModelFactory.eINSTANCE.createCGIsEqualExp();
            cgIsEqualExp.setNotEquals(libraryOperation instanceof OclAnyNotEqualOperation);
            cgIsEqualExp.setSource(cgSource);
            cgIsEqualExp.setArgument(cgArgument);
            this.setAst(cgIsEqualExp, (TypedElement)element);
            cgIsEqualExp.setInvalidating(false);
            cgIsEqualExp.setValidating(true);
            return cgIsEqualExp;
        }
        if (libraryOperation instanceof ConstrainedOperation && pSource != null && (finalOperation = this.codeGenerator.isFinal(asOperation, (Type)DomainUtil.nonNullState((Object)pSource.getType()))) != null && (bodyExpression = asOperation.getBodyExpression()) != null && (cgOperationCallExp = this.inlineOperationCall(element, bodyExpression)) != null) {
            return cgOperationCallExp;
        }
        CGOperationCallExp cgOperationCallExp2 = null;
        if (!(libraryOperation instanceof EObjectOperation) && !(libraryOperation instanceof EInvokeOperation)) {
            CGValuedElement cgOperationCallExp22;
            bodyExpression = asOperation.getBodyExpression();
            if (bodyExpression != null && (cgOperationCallExp22 = this.inlineOperationCall(element, bodyExpression)) != null) {
                return cgOperationCallExp22;
            }
            CGLibraryOperationCallExp cgLibraryOperationCallExp = CGModelFactory.eINSTANCE.createCGLibraryOperationCallExp();
            cgLibraryOperationCallExp.setLibraryOperation(libraryOperation);
            cgOperationCallExp2 = cgLibraryOperationCallExp;
        } else {
            EOperation eOperation = (EOperation)asOperation.getETarget();
            if (eOperation != null) {
                try {
                    this.genModelHelper.getOperationAccessor(asOperation);
                    CGEcoreOperationCallExp cgEcoreOperationCallExp = CGModelFactory.eINSTANCE.createCGEcoreOperationCallExp();
                    cgEcoreOperationCallExp.setEOperation(eOperation);
                    Boolean ecoreIsRequired = this.codeGenerator.isNonNull(element);
                    if (ecoreIsRequired != null) {
                        isRequired = ecoreIsRequired;
                    }
                    cgOperationCallExp2 = cgEcoreOperationCallExp;
                }
                catch (GenModelException cgEcoreOperationCallExp) {
                    // empty catch block
                }
            }
        }
        if (cgOperationCallExp2 == null) {
            CGExecutorOperationCallExp cgExecutorOperationCallExp = CGModelFactory.eINSTANCE.createCGExecutorOperationCallExp();
            CGExecutorOperation cgExecutorOperation = ((CodeGenAnalyzer)this.context).createExecutorOperation(asOperation);
            cgExecutorOperationCallExp.setExecutorOperation(cgExecutorOperation);
            cgExecutorOperationCallExp.getOwns().add(cgExecutorOperation);
            cgOperationCallExp2 = cgExecutorOperationCallExp;
        }
        cgOperationCallExp2.setReferredOperation(asOperation);
        this.setAst(cgOperationCallExp2, (TypedElement)element);
        cgOperationCallExp2.setInvalidating(asOperation.isInvalidating());
        cgOperationCallExp2.setValidating(asOperation.isValidating());
        cgOperationCallExp2.setRequired(isRequired);
        cgOperationCallExp2.setSource(cgSource);
        for (OCLExpression pArgument : element.getArgument()) {
            CGValuedElement cgArgument = this.doVisit(CGValuedElement.class, (Element)pArgument);
            cgOperationCallExp2.getArguments().add(cgArgument);
        }
        return cgOperationCallExp2;
    }

    @NonNull
    public CGValuedElement visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp element) {
        Property asOppositeProperty = (Property)DomainUtil.nonNullModel((Object)element.getReferredProperty());
        Property asProperty = (Property)DomainUtil.nonNullModel((Object)asOppositeProperty.getOpposite());
        boolean isRequired = asProperty.isRequired();
        LibraryProperty libraryProperty = this.metaModelManager.getImplementation(null, asProperty);
        CGNavigationCallExp cgPropertyCallExp = null;
        if (this.isEcoreProperty(libraryProperty)) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asProperty.getETarget();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    CGEcoreOppositePropertyCallExp cgEcorePropertyCallExp = CGModelFactory.eINSTANCE.createCGEcoreOppositePropertyCallExp();
                    cgEcorePropertyCallExp.setEStructuralFeature(eStructuralFeature);
                    Boolean ecoreIsRequired = this.codeGenerator.isNonNull(asProperty);
                    if (ecoreIsRequired != null) {
                        isRequired = ecoreIsRequired;
                    }
                    cgPropertyCallExp = cgEcorePropertyCallExp;
                }
                catch (GenModelException cgEcorePropertyCallExp) {}
            }
        } else {
            throw new UnsupportedOperationException();
        }
        if (cgPropertyCallExp == null) {
            CGExecutorOppositePropertyCallExp cgExecutorPropertyCallExp = CGModelFactory.eINSTANCE.createCGExecutorOppositePropertyCallExp();
            CGExecutorProperty cgExecutorProperty = ((CodeGenAnalyzer)this.context).createExecutorOppositeProperty(asProperty);
            cgExecutorPropertyCallExp.setExecutorProperty(cgExecutorProperty);
            cgExecutorPropertyCallExp.getOwns().add(cgExecutorProperty);
            cgPropertyCallExp = cgExecutorPropertyCallExp;
        }
        cgPropertyCallExp.setReferredProperty(asProperty);
        this.setAst(cgPropertyCallExp, (TypedElement)element);
        cgPropertyCallExp.setRequired(isRequired);
        CGValuedElement cgSource = this.doVisit(CGValuedElement.class, (Element)element.getSource());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    @Nullable
    public CGPackage visitPackage(@NonNull Package element) {
        CGPackage cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        this.setAst(cgPackage, (NamedElement)element);
        for (Type asType : element.getOwnedType()) {
            CGClass cgClass = this.doVisit(CGClass.class, (Element)asType);
            cgPackage.getClasses().add(cgClass);
        }
        return cgPackage;
    }

    @Nullable
    public CGProperty visitProperty(@NonNull Property element) {
        ExpressionInOCL expressionInOCL;
        CGProperty cgProperty = CGModelFactory.eINSTANCE.createCGProperty();
        this.setAst(cgProperty, (TypedElement)element);
        cgProperty.setRequired(element.isRequired());
        OpaqueExpression specification = element.getDefaultExpression();
        if (specification != null && (expressionInOCL = PivotUtil.getExpressionInOCL((MetaModelManager)this.metaModelManager, (OpaqueExpression)specification)) != null) {
            Variable contextVariable = expressionInOCL.getContextVariable();
            if (contextVariable != null) {
                this.getSelfParameter(contextVariable);
            }
            cgProperty.setBody(this.doVisit(CGValuedElement.class, (Element)expressionInOCL.getBodyExpression()));
        }
        return cgProperty;
    }

    @NonNull
    public CGValuedElement visitPropertyCallExp(@NonNull PropertyCallExp element) {
        Property asProperty = (Property)DomainUtil.nonNullModel((Object)element.getReferredProperty());
        boolean isRequired = asProperty.isRequired();
        LibraryProperty libraryProperty = this.metaModelManager.getImplementation(null, asProperty);
        CGNavigationCallExp cgPropertyCallExp = null;
        if (this.isEcoreProperty(libraryProperty)) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)asProperty.getETarget();
            if (eStructuralFeature != null) {
                try {
                    this.genModelHelper.getGetAccessor(eStructuralFeature);
                    CGEcorePropertyCallExp cgEcorePropertyCallExp = CGModelFactory.eINSTANCE.createCGEcorePropertyCallExp();
                    cgEcorePropertyCallExp.setEStructuralFeature(eStructuralFeature);
                    Boolean ecoreIsRequired = this.codeGenerator.isNonNull(asProperty);
                    if (ecoreIsRequired != null) {
                        isRequired = ecoreIsRequired;
                    }
                    cgPropertyCallExp = cgEcorePropertyCallExp;
                }
                catch (GenModelException cgEcorePropertyCallExp) {}
            }
        } else if (libraryProperty instanceof TuplePartProperty) {
            CGTuplePartCallExp cgTuplePartCallExp = CGModelFactory.eINSTANCE.createCGTuplePartCallExp();
            cgTuplePartCallExp.setAstTuplePartId(((TuplePartImpl)asProperty).getTuplePartId());
            cgPropertyCallExp = cgTuplePartCallExp;
        } else {
            CGLibraryPropertyCallExp cgLibraryPropertyCallExp = CGModelFactory.eINSTANCE.createCGLibraryPropertyCallExp();
            cgLibraryPropertyCallExp.setLibraryProperty(libraryProperty);
            cgPropertyCallExp = cgLibraryPropertyCallExp;
        }
        if (cgPropertyCallExp == null) {
            CGExecutorPropertyCallExp cgExecutorPropertyCallExp = CGModelFactory.eINSTANCE.createCGExecutorPropertyCallExp();
            CGExecutorProperty cgExecutorProperty = ((CodeGenAnalyzer)this.context).createExecutorProperty(asProperty);
            cgExecutorPropertyCallExp.setExecutorProperty(cgExecutorProperty);
            cgExecutorPropertyCallExp.getOwns().add(cgExecutorProperty);
            cgPropertyCallExp = cgExecutorPropertyCallExp;
        }
        cgPropertyCallExp.setReferredProperty(asProperty);
        this.setAst(cgPropertyCallExp, (TypedElement)element);
        cgPropertyCallExp.setRequired(isRequired);
        CGValuedElement cgSource = this.doVisit(CGValuedElement.class, (Element)element.getSource());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    @Nullable
    public CGConstantExp visitRealLiteralExp(@NonNull RealLiteralExp element) {
        Number realSymbol = element.getRealSymbol();
        CGReal cgReal = ((CodeGenAnalyzer)this.context).getReal(realSymbol != null ? (Number)realSymbol : (Number)0.0);
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, cgReal);
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @Nullable
    public CGNamedElement visitStateExp(@NonNull StateExp element) {
        return (CGNamedElement)super.visitStateExp(element);
    }

    @Nullable
    public CGConstantExp visitStringLiteralExp(@NonNull StringLiteralExp element) {
        String stringSymbol = element.getStringSymbol();
        CGString cgString = ((CodeGenAnalyzer)this.context).getString(stringSymbol != null ? stringSymbol : "");
        CGConstantExp cgLiteralExp = ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, cgString);
        return cgLiteralExp;
    }

    @Nullable
    public CGTupleExp visitTupleLiteralExp(@NonNull TupleLiteralExp element) {
        CGTupleExp cgTupleExp = CGModelFactory.eINSTANCE.createCGTupleExp();
        this.setAst(cgTupleExp, (TypedElement)element);
        ArrayList<CGTuplePart> cgParts = new ArrayList<CGTuplePart>();
        for (TupleLiteralPart asPart : element.getPart()) {
            cgParts.add((CGTuplePart)asPart.accept((Visitor)this));
        }
        Collections.sort(cgParts, CGTuplePartNameComparator.INSTANCE);
        cgTupleExp.getParts().addAll(cgParts);
        ((CodeGenAnalyzer)this.context).getTypeId(element.getTypeId());
        return cgTupleExp;
    }

    @Nullable
    public CGTuplePart visitTupleLiteralPart(@NonNull TupleLiteralPart element) {
        CGTuplePart cgTuplePart = CGModelFactory.eINSTANCE.createCGTuplePart();
        this.setAst(cgTuplePart, (TypedElement)element);
        cgTuplePart.setInit(this.doVisit(CGValuedElement.class, (Element)element.getInitExpression()));
        TuplePartId partId = element.getPartId();
        if (partId != null) {
            ((CodeGenAnalyzer)this.context).getElementId((ElementId)partId);
        }
        return cgTuplePart;
    }

    @Nullable
    public CGTypeExp visitTypeExp(@NonNull TypeExp pTypeExp) {
        CGTypeExp cgTypeExp = CGModelFactory.eINSTANCE.createCGTypeExp();
        cgTypeExp.setAst((Element)pTypeExp);
        CGExecutorType cgExecutorType = ((CodeGenAnalyzer)this.context).createExecutorType((Type)DomainUtil.nonNullState((Object)pTypeExp.getReferredType()));
        cgTypeExp.setExecutorType(cgExecutorType);
        cgTypeExp.getOwns().add(cgExecutorType);
        cgTypeExp.setName(cgExecutorType.getName());
        return cgTypeExp;
    }

    @Nullable
    public CGConstantExp visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp element) {
        Number unlimitedNaturalSymbol = element.getUnlimitedNaturalSymbol();
        CGConstantExp cgLiteralExp = unlimitedNaturalSymbol instanceof UnlimitedValue ? ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getUnlimited()) : (unlimitedNaturalSymbol instanceof Unlimited ? ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getUnlimited()) : (unlimitedNaturalSymbol != null ? ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getInteger(unlimitedNaturalSymbol)) : ((CodeGenAnalyzer)this.context).createCGConstantExp((OCLExpression)element, ((CodeGenAnalyzer)this.context).getInteger(0))));
        this.setAst(cgLiteralExp, (TypedElement)element);
        return cgLiteralExp;
    }

    @Nullable
    public CGNamedElement visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp element) {
        return (CGNamedElement)super.visitUnspecifiedValueExp(element);
    }

    @Nullable
    public CGValuedElement visitVariableExp(@NonNull VariableExp asVariableExp) {
        VariableDeclaration referredVariable = asVariableExp.getReferredVariable();
        CGVariableExp cgVariableExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        this.setAst(cgVariableExp, (TypedElement)asVariableExp);
        if (referredVariable != null) {
            cgVariableExp.setReferredVariable(this.getVariable(referredVariable));
        }
        return cgVariableExp;
    }

    @Nullable
    public CGValuedElement visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    private static final class CGTuplePartNameComparator
    implements Comparator<CGTuplePart> {
        @NonNull
        public static final CGTuplePartNameComparator INSTANCE = new CGTuplePartNameComparator();

        private CGTuplePartNameComparator() {
        }

        @Override
        public int compare(CGTuplePart o1, CGTuplePart o2) {
            return DomainUtil.safeCompareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }

    protected static class Variables {
        @Nullable
        private Variables outerVariables;
        @NonNull
        private final Map<Variable, CGParameter> cgParameters = new HashMap<Variable, CGParameter>();
        @NonNull
        private Map<VariableDeclaration, CGVariable> cgVariables = new HashMap<VariableDeclaration, CGVariable>();

        public Variables(@Nullable Variables outerVariables) {
            this.outerVariables = outerVariables;
        }

        public CGVariable getLocalVariable(@NonNull VariableDeclaration asVariable) {
            return this.cgVariables.get(asVariable);
        }

        public CGParameter getParameter(@NonNull Variable asVariable) {
            CGParameter cgVariable = this.cgParameters.get(asVariable);
            if (cgVariable != null) {
                return cgVariable;
            }
            if (this.outerVariables != null) {
                return this.outerVariables.getParameter(asVariable);
            }
            return null;
        }

        public CGVariable getVariable(@NonNull VariableDeclaration asVariable) {
            CGVariable cgVariable = this.cgVariables.get(asVariable);
            if (cgVariable != null) {
                return cgVariable;
            }
            if (this.outerVariables != null) {
                return this.outerVariables.getVariable(asVariable);
            }
            return null;
        }

        public void putParameter(@NonNull Variable aParameter, @NonNull CGParameter cgParameter) {
            this.cgParameters.put(aParameter, cgParameter);
            this.cgVariables.put((VariableDeclaration)aParameter, cgParameter);
        }

        public void putVariable(@NonNull VariableDeclaration asVariable, @NonNull CGVariable cgVariable) {
            this.cgVariables.put(asVariable, cgVariable);
        }
    }
}

