/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoolean;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInteger;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGReal;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnlimited;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;

public class CodeGenAnalyzer {
    @NonNull
    protected final CodeGenerator codeGenerator;
    @NonNull
    protected final NameManager nameManager;
    @NonNull
    private Map<ElementId, CGElementId> cgElementIds = new HashMap<ElementId, CGElementId>();
    @NonNull
    protected final CGBoolean cgFalse;
    @NonNull
    protected final CGBoolean cgTrue;
    private CGUnlimited cgUnlimited = null;
    private CGInvalid cgInvalid = null;
    @NonNull
    protected final CGNull cgNull;
    @NonNull
    private final Map<Number, CGInteger> cgIntegers = new HashMap<Number, CGInteger>();
    @NonNull
    private final Map<Number, CGReal> cgReals = new HashMap<Number, CGReal>();
    @NonNull
    private final Map<String, CGString> cgStrings = new HashMap<String, CGString>();

    public CodeGenAnalyzer(@NonNull CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
        this.nameManager = codeGenerator.getNameManager();
        this.cgFalse = this.createCGBoolean(false);
        this.cgTrue = this.createCGBoolean(true);
        this.cgNull = this.createCGNull();
    }

    public void analyze(@NonNull CGElement cgRoot) {
        AnalysisVisitor analysisVisitor = this.codeGenerator.createAnalysisVisitor();
        cgRoot.accept(analysisVisitor);
        BoxingAnalyzer boxingAnalyzer = this.codeGenerator.createBoxingAnalyzer();
        cgRoot.accept(boxingAnalyzer);
        FieldingAnalyzer fieldingAnalyzer = this.codeGenerator.createFieldingAnalyzer();
        fieldingAnalyzer.analyze(cgRoot, false);
    }

    @NonNull
    public CGConstantExp createCGConstantExp(@NonNull OCLExpression element, @NonNull CGConstant constant) {
        CGConstantExp cgLiteralExp = CGModelFactory.eINSTANCE.createCGConstantExp();
        cgLiteralExp.setAst((Element)element);
        cgLiteralExp.setReferredConstant(constant);
        cgLiteralExp.setTypeId(this.getTypeId(element.getTypeId()));
        return cgLiteralExp;
    }

    @NonNull
    protected CGBoolean createCGBoolean(boolean booleanValue) {
        CGBoolean cgBoolean = CGModelFactory.eINSTANCE.createCGBoolean();
        this.setExplicitNames(cgBoolean, booleanValue);
        cgBoolean.setBooleanValue(booleanValue);
        cgBoolean.setTypeId(this.getTypeId((TypeId)TypeId.BOOLEAN));
        return cgBoolean;
    }

    @NonNull
    protected CGNull createCGNull() {
        CGNull cgNull = CGModelFactory.eINSTANCE.createCGNull();
        this.setExplicitNames(cgNull, null);
        cgNull.setTypeId(this.getTypeId((TypeId)TypeId.OCL_VOID));
        return cgNull;
    }

    @NonNull
    public CGExecutorConstructorPart createExecutorConstructorPart(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGExecutorConstructorPart cgPart = CGModelFactory.eINSTANCE.createCGExecutorConstructorPart();
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        cgPart.setUnderlyingPropertyId(cgPropertyId);
        cgPart.setAst((Element)asProperty);
        cgPart.setName("CTORid_" + asProperty.getName());
        cgPart.getDependsOn().add(cgPropertyId);
        return cgPart;
    }

    @NonNull
    public CGExecutorOperation createExecutorOperation(@NonNull Operation asOperation) {
        OperationId operationId = asOperation.getOperationId();
        CGExecutorOperation cgOperation = CGModelFactory.eINSTANCE.createCGExecutorOperation();
        CGElementId cgOperationId = this.getElementId((ElementId)operationId);
        cgOperation.setUnderlyingOperationId(cgOperationId);
        cgOperation.setAst((Element)asOperation);
        cgOperation.setName(this.nameManager.getGlobalSymbolName(asOperation, new String[0]));
        cgOperation.getDependsOn().add(cgOperationId);
        return cgOperation;
    }

    @NonNull
    public CGExecutorProperty createExecutorOppositeProperty(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGExecutorProperty cgProperty = null;
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        Property asOppositeProperty = (Property)DomainUtil.nonNullState((Object)asProperty.getOpposite());
        if (asOppositeProperty.isComposite()) {
            cgPropertyId = this.getElementId((ElementId)propertyId);
            cgProperty = CGModelFactory.eINSTANCE.createCGExecutorCompositionProperty();
        } else {
            cgPropertyId = this.getElementId((ElementId)asOppositeProperty.getPropertyId());
            cgProperty = CGModelFactory.eINSTANCE.createCGExecutorOppositeProperty();
        }
        cgProperty.setUnderlyingPropertyId(cgPropertyId);
        cgProperty.setAst((Element)asProperty);
        cgProperty.setName("IMPPROPid_" + asProperty.getName());
        cgProperty.getDependsOn().add(cgPropertyId);
        return cgProperty;
    }

    @NonNull
    public CGExecutorProperty createExecutorProperty(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        CGExecutorNavigationProperty cgProperty = CGModelFactory.eINSTANCE.createCGExecutorNavigationProperty();
        cgProperty.setUnderlyingPropertyId(cgPropertyId);
        cgProperty.setAst((Element)asProperty);
        cgProperty.setName("IMPPROPid_" + asProperty.getName());
        cgProperty.getDependsOn().add(cgPropertyId);
        return cgProperty;
    }

    @NonNull
    public CGExecutorType createExecutorType(@NonNull Type asType) {
        TypeId typeId = asType.getTypeId();
        CGExecutorType cgType = CGModelFactory.eINSTANCE.createCGExecutorType();
        CGTypeId cgTypeId = this.getTypeId(typeId);
        cgType.setUnderlyingTypeId(cgTypeId);
        cgType.setAst((Element)asType);
        cgType.setName(this.getNameManager().getGlobalSymbolName(asType, new String[0]));
        cgType.getDependsOn().add(cgTypeId);
        return cgType;
    }

    @NonNull
    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NonNull
    public CGBoolean getBoolean(boolean aBoolean) {
        return aBoolean ? this.cgTrue : this.cgFalse;
    }

    @NonNull
    public CGElementId getElementId(@NonNull ElementId elementId) {
        CGElementId cgElementId = this.cgElementIds.get(elementId);
        if (cgElementId == null) {
            if (elementId instanceof TypeId) {
                return this.getTypeId((TypeId)elementId);
            }
            cgElementId = CGModelFactory.eINSTANCE.createCGElementId();
            cgElementId.setElementId(elementId);
            this.setNames(cgElementId, elementId);
            this.cgElementIds.put(elementId, cgElementId);
        }
        return cgElementId;
    }

    @NonNull
    public CGValuedElement getExpression(@Nullable CGValuedElement cgExpression) {
        if (cgExpression == null) {
            CGConstantExp cgLiteralExp = CGModelFactory.eINSTANCE.createCGConstantExp();
            cgLiteralExp.setReferredConstant(this.cgInvalid);
            cgLiteralExp.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
            cgExpression = cgLiteralExp;
        }
        return cgExpression;
    }

    @NonNull
    public CGInteger getInteger(@NonNull Number aNumber) {
        CGInteger cgInteger = this.cgIntegers.get(aNumber);
        if (cgInteger == null) {
            cgInteger = CGModelFactory.eINSTANCE.createCGInteger();
            this.setNames(cgInteger, aNumber);
            cgInteger.setNumericValue(aNumber);
            cgInteger.setTypeId(this.getTypeId((TypeId)TypeId.INTEGER));
            this.cgIntegers.put(aNumber, cgInteger);
        }
        return cgInteger;
    }

    @NonNull
    public CGInvalid getInvalid() {
        CGInvalid cgInvalid2 = this.cgInvalid;
        if (cgInvalid2 == null) {
            this.cgInvalid = cgInvalid2 = CGModelFactory.eINSTANCE.createCGInvalid();
            this.setNames(cgInvalid2, ValuesUtil.INVALID_VALUE);
            cgInvalid2.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
        }
        return cgInvalid2;
    }

    @NonNull
    public CGInvalid getInvalid(String messageTemplate, Object ... bindings) {
        CGInvalid cgInvalid = CGModelFactory.eINSTANCE.createCGInvalid();
        this.setNames(cgInvalid, ValuesUtil.INVALID_VALUE);
        cgInvalid.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
        cgInvalid.setMessageTemplate(messageTemplate);
        Object[] objectArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Object binding = objectArray[n2];
            cgInvalid.getBindings().add(binding);
            ++n2;
        }
        return cgInvalid;
    }

    @NonNull
    public CGNull getNull() {
        return this.cgNull;
    }

    @NonNull
    public CGReal getReal(@NonNull Number aNumber) {
        CGReal cgReal = this.cgReals.get(aNumber);
        if (cgReal == null) {
            cgReal = CGModelFactory.eINSTANCE.createCGReal();
            this.setNames(cgReal, aNumber);
            cgReal.setNumericValue(aNumber);
            cgReal.setTypeId(this.getTypeId((TypeId)TypeId.REAL));
            this.cgReals.put(aNumber, cgReal);
        }
        return cgReal;
    }

    @NonNull
    public CGString getString(@NonNull String aString) {
        CGString cgString = this.cgStrings.get(aString);
        if (cgString == null) {
            cgString = CGModelFactory.eINSTANCE.createCGString();
            this.setNames(cgString, aString);
            cgString.setStringValue(aString);
            cgString.setTypeId(this.getTypeId((TypeId)TypeId.STRING));
            this.cgStrings.put(aString, cgString);
        }
        return cgString;
    }

    @NonNull
    public NameManager getNameManager() {
        return (NameManager)DomainUtil.nonNullState((Object)this.nameManager);
    }

    @NonNull
    public CGTypeId getTypeId(@NonNull TypeId typeId) {
        CGElementId cgElementId = this.cgElementIds.get(typeId);
        CGTypeId cgTypeId = (CGTypeId)cgElementId;
        if (cgTypeId == null) {
            cgTypeId = CGModelFactory.eINSTANCE.createCGTypeId();
            cgTypeId.setElementId((ElementId)typeId);
            cgTypeId.setName(this.nameManager.getGlobalSymbolName(typeId, new String[0]));
            cgTypeId.setValueName((String)DomainUtil.nonNullState((Object)cgTypeId.getName()));
            this.cgElementIds.put((ElementId)typeId, cgTypeId);
        }
        return cgTypeId;
    }

    @NonNull
    public CGUnlimited getUnlimited() {
        CGUnlimited cgUnlimited2 = this.cgUnlimited;
        if (cgUnlimited2 == null) {
            this.cgUnlimited = cgUnlimited2 = CGModelFactory.eINSTANCE.createCGUnlimited();
            this.setNames(cgUnlimited2, ValuesUtil.UNLIMITED_VALUE);
            cgUnlimited2.setTypeId(this.getTypeId((TypeId)TypeId.UNLIMITED_NATURAL));
        }
        return cgUnlimited2;
    }

    @NonNull
    public CGValuedElement replace(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement newElement, String messageTemplate, Object ... bindings) {
        if (oldElement.isRequired() && newElement.isNull()) {
            newElement = this.getInvalid(messageTemplate, bindings);
        }
        return CGUtils.replace(oldElement, newElement);
    }

    public void setConstant(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement aConstant) {
        CGConstantExp newElement = CGModelFactory.eINSTANCE.createCGConstantExp();
        newElement.setReferredConstant(aConstant);
        newElement.setTypeId(oldElement.getTypeId());
        newElement.setAst(oldElement.getAst());
        CGUtils.replace(oldElement, newElement);
    }

    public void setExplicitNames(@NonNull CGValuedElement cgValue, @Nullable Object anObject) {
        String name = this.nameManager.getExplicitName(anObject);
        cgValue.setName(name);
        cgValue.setValueName(name);
    }

    public void setNames(@NonNull CGValuedElement cgValue, @NonNull Object anObject) {
        String name = this.nameManager.getGlobalSymbolName(anObject, new String[0]);
        cgValue.setName(name);
        cgValue.setValueName(name);
    }
}

