/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;

public class NameQueries {
    private static Map<Element, NameAllocation<Constraint>> uniqueConstraints = new HashMap<Element, NameAllocation<Constraint>>();
    private static Map<Element, NameAllocation<Operation>> uniqueOperations = new HashMap<Element, NameAllocation<Operation>>();
    private static Map<Element, NameAllocation<Package>> uniquePackages = new HashMap<Element, NameAllocation<Package>>();
    private static Map<Element, NameAllocation<Property>> uniqueProperties = new HashMap<Element, NameAllocation<Property>>();
    private static Map<Element, NameAllocation<String>> uniqueStrings = new HashMap<Element, NameAllocation<String>>();
    private static Map<Element, TuplePartAllocation> uniqueTupleParts = new HashMap<Element, TuplePartAllocation>();
    private static Map<Element, NameAllocation<TupleType>> uniqueTupleTypes = new HashMap<Element, NameAllocation<TupleType>>();
    private static Map<Element, NameAllocation<Type>> uniqueTypes = new HashMap<Element, NameAllocation<Type>>();
    private static Map<Element, NameAllocation<Variable>> uniqueVariables = new HashMap<Element, NameAllocation<Variable>>();

    protected static void appendJavaCharacters(StringBuilder s, String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    protected static void appendJavaCharacters(StringBuilder s, String string, int iMax) {
        int i = 0;
        while (i < Math.min(iMax, string.length())) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    public static String getUniqueText(Element context, Constraint constraint) {
        NameAllocation<Constraint> allocation = uniqueConstraints.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Constraint>(){

                @Override
                protected String computeUniqueText(Constraint constraint) {
                    StringBuilder s = new StringBuilder();
                    String name = constraint.getName();
                    if (name == null) {
                        List constraints = (List)constraint.eContainer().eGet((EStructuralFeature)constraint.eContainmentFeature());
                        name = Integer.toString(constraints.indexOf(constraint));
                    }
                    NameQueries.appendJavaCharacters(s, name);
                    if (this.isUsed(s.toString())) {
                        s.append("___");
                        if (this.isUsed(s.toString())) {
                            int i = 1;
                            while (true) {
                                if (!this.isUsed(String.valueOf(s.toString()) + Integer.toString(i))) {
                                    s.append(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    return s.toString();
                }
            };
            uniqueConstraints.put(context, allocation);
        }
        return allocation.get(constraint);
    }

    public static String getUniqueText(Element context, Operation operation) {
        NameAllocation<Operation> allocation = uniqueOperations.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Operation>(){

                @Override
                protected String computeUniqueText(Operation operation) {
                    StringBuilder s = new StringBuilder();
                    NameQueries.appendJavaCharacters(s, operation.getOwningType().getName());
                    s.append('_');
                    int arity = operation.getOwnedParameter().size();
                    String string = operation.getName();
                    int i = 0;
                    while (i < string.length()) {
                        char c = string.charAt(i);
                        if (Character.isJavaIdentifierPart(c)) {
                            s.append(c);
                        } else if (c == '=') {
                            s.append("_eq_");
                        } else if (c == '+') {
                            s.append("_add_");
                        } else if (c == '-') {
                            if (arity == 0) {
                                s.append("_neg_");
                            } else {
                                s.append("_sub_");
                            }
                        } else if (c == '/') {
                            s.append("_div_");
                        } else if (c == '*') {
                            s.append("_mul_");
                        } else if (c == '<') {
                            s.append("_lt_");
                        } else if (c == '>') {
                            s.append("_gt_");
                        } else {
                            s.append('_');
                        }
                        ++i;
                    }
                    if (this.isUsed(s.toString())) {
                        i = 1;
                        while (true) {
                            if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                                s.append(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniqueOperations.put(context, allocation);
        }
        return allocation.get(operation);
    }

    public static String getUniqueText(Element context, Package pkg) {
        NameAllocation<Package> allocation = uniquePackages.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Package>(){

                @Override
                protected String computeUniqueText(Package pkg) {
                    StringBuilder s = new StringBuilder();
                    NameQueries.appendJavaCharacters(s, pkg.getName());
                    if (this.isUsed(s.toString())) {
                        int i = 1;
                        while (true) {
                            if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                                s.append(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniquePackages.put(context, allocation);
        }
        return allocation.get(pkg);
    }

    public static String getUniqueText(Element context, Property property) {
        if (property.eContainer() instanceof TupleType) {
            TuplePartAllocation allocation = uniqueTupleParts.get(context);
            if (allocation == null) {
                allocation = new TuplePartAllocation();
                uniqueTupleParts.put(context, allocation);
            }
            return allocation.get(property.getName(), property.getType());
        }
        NameAllocation<Property> allocation = uniqueProperties.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Property>(){

                @Override
                protected String computeUniqueText(Property property) {
                    StringBuilder s = new StringBuilder();
                    NameQueries.appendJavaCharacters(s, property.getOwningType().getName());
                    s.append('_');
                    NameQueries.appendJavaCharacters(s, property.getName());
                    if (this.isUsed(s.toString())) {
                        int i = 1;
                        while (true) {
                            if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                                s.append(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniqueProperties.put(context, allocation);
        }
        return allocation.get(property);
    }

    public static String getUniqueText(Element context, String string) {
        NameAllocation<String> allocation = uniqueStrings.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<String>(){

                @Override
                protected String computeUniqueText(String string) {
                    StringBuilder s = new StringBuilder();
                    int iSize = string.length();
                    int iMax = 8;
                    NameQueries.appendJavaCharacters(s, string, iMax);
                    if (iSize > 8 || this.isUsed(s.toString())) {
                        s.append("___");
                        if (this.isUsed(s.toString())) {
                            int i = 1;
                            while (true) {
                                if (!this.isUsed(String.valueOf(s.toString()) + Integer.toString(i))) {
                                    s.append(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    return s.toString();
                }
            };
            uniqueStrings.put(context, allocation);
        }
        return allocation.get(string);
    }

    public static String getUniqueText(Element context, TupleLiteralPart part) {
        TuplePartAllocation allocation = uniqueTupleParts.get(context);
        if (allocation == null) {
            allocation = new TuplePartAllocation();
            uniqueTupleParts.put(context, allocation);
        }
        return allocation.get(part.getName(), part.getType());
    }

    public static String getUniqueText(Element context, TupleType type) {
        NameAllocation<TupleType> allocation = uniqueTupleTypes.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<TupleType>(){

                @Override
                protected String computeUniqueText(TupleType type) {
                    StringBuilder s = new StringBuilder();
                    String name = String.valueOf(type);
                    NameQueries.appendJavaCharacters(s, name);
                    if (this.isUsed(s.toString())) {
                        int i = 1;
                        while (true) {
                            if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                                s.append(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniqueTupleTypes.put(context, allocation);
        }
        return allocation.get(type);
    }

    public static String getUniqueText(Element context, Type type) {
        NameAllocation<Type> allocation = uniqueTypes.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Type>(){

                @Override
                protected String computeUniqueText(Type type) {
                    StringBuilder s = new StringBuilder();
                    NameQueries.appendJavaCharacters(s, String.valueOf(type));
                    if (this.isUsed(s.toString())) {
                        int i = 1;
                        while (true) {
                            if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                                s.append(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniqueTypes.put(context, allocation);
        }
        return allocation.get(type);
    }

    public static String getUniqueText(Element context, Variable variable) {
        NameAllocation<Variable> allocation = uniqueVariables.get(context);
        if (allocation == null) {
            allocation = new NameAllocation<Variable>(){

                @Override
                protected String computeUniqueText(Variable variable) {
                    StringBuilder s = new StringBuilder();
                    NameQueries.appendJavaCharacters(s, variable.getName());
                    if (this.isUsed(s.toString())) {
                        int i = 1;
                        while (true) {
                            String suffix = String.valueOf('_') + Integer.toString(i);
                            if (!this.isUsed(String.valueOf(s.toString()) + suffix)) {
                                s.append(suffix);
                                break;
                            }
                            ++i;
                        }
                    }
                    return s.toString();
                }
            };
            uniqueVariables.put(context, allocation);
        }
        String string = allocation.get(variable);
        return string;
    }

    public static abstract class NameAllocation<T> {
        private Map<T, String> mappings = new HashMap<T, String>();
        private Set<String> used = new HashSet<String>();

        protected abstract String computeUniqueText(T var1);

        public String get(T string) {
            String uniqueString = this.mappings.get(string);
            if (uniqueString == null) {
                uniqueString = this.computeUniqueText(string);
                this.used.add(uniqueString);
                this.mappings.put(string, uniqueString);
            }
            return uniqueString;
        }

        protected boolean isUsed(String string) {
            return this.used.contains(string);
        }
    }

    public static class TuplePartAllocation {
        private Map<String, Map<Type, String>> mappings = new HashMap<String, Map<Type, String>>();
        private Set<String> used = new HashSet<String>();

        protected String computeUniqueText(String partName, Type partType) {
            StringBuilder s = new StringBuilder();
            NameQueries.appendJavaCharacters(s, partName);
            s.append('_');
            NameQueries.appendJavaCharacters(s, String.valueOf(partType));
            if (this.isUsed(s.toString())) {
                int i = 1;
                while (true) {
                    if (!this.isUsed(String.valueOf(s.toString()) + '_' + Integer.toString(i))) {
                        s.append(i);
                        break;
                    }
                    ++i;
                }
            }
            return s.toString();
        }

        public String get(String partName, Type partType) {
            String uniqueString;
            Map<Type, String> typeMaps = this.mappings.get(partName);
            if (typeMaps == null) {
                typeMaps = new HashMap<Type, String>();
                this.mappings.put(partName, typeMaps);
            }
            if ((uniqueString = typeMaps.get(partType)) == null) {
                uniqueString = this.computeUniqueText(partName, partType);
                this.used.add(uniqueString);
                typeMaps.put(partType, uniqueString);
            }
            return uniqueString;
        }

        protected boolean isUsed(String string) {
            return this.used.contains(string);
        }
    }
}

