/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLocalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.SimpleAnalysis;

public class CommonAnalysis
extends AbstractAnalysis {
    private SimpleAnalysis primaryAnalysis = null;
    @NonNull
    protected final List<SimpleAnalysis> simpleAnalyses = new ArrayList<SimpleAnalysis>();
    private int minDepth = Integer.MAX_VALUE;
    private int maxDepth = Integer.MIN_VALUE;

    public CommonAnalysis(@NonNull SimpleAnalysis firstAnalysis, @NonNull SimpleAnalysis secondAnalysis) {
        firstAnalysis.setCommonAnalysis(this);
        if (secondAnalysis != firstAnalysis) {
            secondAnalysis.setCommonAnalysis(this);
        }
    }

    @Override
    @NonNull
    public CommonAnalysis addAnalysis(@NonNull AbstractAnalysis anAnalysis) {
        return anAnalysis.addCommonAnalysis(this);
    }

    @Override
    @NonNull
    public CommonAnalysis addCommonAnalysis(@NonNull CommonAnalysis commonAnalysis) {
        for (SimpleAnalysis simpleAnalysis : new ArrayList<SimpleAnalysis>(commonAnalysis.simpleAnalyses)) {
            this.addSimpleAnalysis(simpleAnalysis);
        }
        return this;
    }

    @Override
    @NonNull
    public CommonAnalysis addSimpleAnalysis(@NonNull SimpleAnalysis simpleAnalysis) {
        simpleAnalysis.setCommonAnalysis(this);
        return this;
    }

    @NonNull
    public CommonAnalysis addedSimpleAnalysis(@NonNull SimpleAnalysis simpleAnalysis) {
        this.simpleAnalyses.add(simpleAnalysis);
        int depth = simpleAnalysis.getDepth();
        if (this.primaryAnalysis == null) {
            this.primaryAnalysis = simpleAnalysis;
            this.minDepth = depth;
            this.maxDepth = depth;
        } else if (depth < this.minDepth) {
            this.primaryAnalysis = simpleAnalysis;
            this.minDepth = depth;
        } else if (depth > this.maxDepth) {
            this.maxDepth = depth;
        }
        assert (this.primaryAnalysis.isStructurallyEqualTo(simpleAnalysis));
        return this;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public int getMinDepth() {
        return this.minDepth;
    }

    @NonNull
    public SimpleAnalysis getPrimaryAnalysis() {
        return this.primaryAnalysis;
    }

    @Override
    @NonNull
    public CGValuedElement getPrimaryElement() {
        return this.primaryAnalysis.getElement();
    }

    @Override
    public int getStructuralHashCode() {
        return this.primaryAnalysis.getStructuralHashCode();
    }

    @Override
    public boolean isStructurallyEqualTo(@NonNull AbstractAnalysis thatAnalysis) {
        return this.primaryAnalysis.isStructurallyEqualTo(thatAnalysis);
    }

    @Override
    public boolean isStructurallyEqualTo(@NonNull SimpleAnalysis thatAnalysis) {
        return this.primaryAnalysis.isStructurallyEqualTo(thatAnalysis);
    }

    public void removedSimpleAnalysis(SimpleAnalysis simpleAnalysis) {
        this.simpleAnalyses.remove(simpleAnalysis);
    }

    public void rewrite(@NonNull CodeGenAnalyzer analyzer, @NonNull CGValuedElement controlElement) {
        CGValuedElement cgCSE = this.primaryAnalysis.getElement();
        if (this.simpleAnalyses.size() > 1 || !cgCSE.isUncommonable()) {
            CGLocalVariable cgVariable = CGModelFactory.eINSTANCE.createCGLocalVariable();
            cgVariable.setTypeId(cgCSE.getTypeId());
            cgVariable.setRequired(cgCSE.isNonNull());
            cgVariable.setAst(cgCSE.getAst());
            cgVariable.setName(analyzer.getNameManager().getGlobalSymbolName(cgVariable, "_cse"));
            for (SimpleAnalysis simpleAnalysis : this.simpleAnalyses) {
                CGValuedElement commonElement = simpleAnalysis.getElement();
                CGElement cgParent = commonElement.getParent();
                assert (cgParent != null);
                if (cgParent.rewriteAs(commonElement, cgCSE)) continue;
                this.rewriteAsVariableExp(commonElement, cgVariable);
            }
            this.rewriteAsLet(controlElement, cgVariable);
            cgVariable.setInit(cgCSE);
        }
    }

    @NonNull
    protected CGLetExp rewriteAsLet(@NonNull CGValuedElement cgIn, @NonNull CGVariable cgVariable) {
        CGLetExp cgLetExp = CGModelFactory.eINSTANCE.createCGLetExp();
        cgLetExp.setTypeId(cgIn.getTypeId());
        cgLetExp.setAst(cgIn.getAst());
        CGUtils.replace(cgIn, cgLetExp);
        cgLetExp.setIn(cgIn);
        cgLetExp.setInit(cgVariable);
        return cgLetExp;
    }

    protected void rewriteAsVariableExp(@NonNull CGValuedElement cgElement, @NonNull CGVariable cgVariable) {
        CGVariableExp cgVarExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        cgVarExp.setTypeId(cgVariable.getTypeId());
        cgVarExp.setAst(cgVariable.getAst());
        cgVarExp.setReferredVariable(cgVariable);
        CGUtils.replace(cgElement, cgVarExp);
    }

    public void rewriteGlobal(@NonNull CodeGenAnalyzer analyzer) {
        if (this.simpleAnalyses.size() > 1) {
            CGConstantExp primaryConstantExp;
            CGValuedElement primaryElement = this.primaryAnalysis.getElement();
            if (primaryElement instanceof CGConstantExp) {
                primaryConstantExp = (CGConstantExp)primaryElement;
            } else {
                CGElement primaryParent = primaryElement.getParent();
                if (primaryParent instanceof CGConstantExp) {
                    primaryConstantExp = (CGConstantExp)primaryParent;
                } else {
                    primaryConstantExp = CGModelFactory.eINSTANCE.createCGConstantExp();
                    primaryConstantExp.setReferredConstant(primaryElement);
                    primaryConstantExp.setAst(primaryElement.getAst());
                    primaryConstantExp.setTypeId(primaryElement.getTypeId());
                    primaryConstantExp.setName(primaryElement.getName());
                    CGUtils.replace(primaryElement, primaryConstantExp);
                }
            }
            for (SimpleAnalysis secondaryAnalysis : this.simpleAnalyses) {
                CGConstantExp secondaryConstantExp;
                if (secondaryAnalysis == this.primaryAnalysis) continue;
                CGValuedElement secondaryElement = secondaryAnalysis.getElement();
                if (secondaryElement instanceof CGConstantExp) {
                    secondaryConstantExp = (CGConstantExp)secondaryElement;
                } else {
                    CGElement secondaryParent = secondaryElement.getParent();
                    if (secondaryParent instanceof CGConstantExp) {
                        secondaryConstantExp = (CGConstantExp)secondaryParent;
                    } else {
                        secondaryConstantExp = CGModelFactory.eINSTANCE.createCGConstantExp();
                        secondaryConstantExp.setReferredConstant(secondaryElement);
                        secondaryConstantExp.setAst(secondaryElement.getAst());
                        secondaryConstantExp.setTypeId(secondaryElement.getTypeId());
                        secondaryConstantExp.setName(secondaryElement.getName());
                        CGUtils.replace(secondaryElement, secondaryConstantExp);
                    }
                }
                secondaryConstantExp.setReferredConstant(primaryConstantExp.getReferredConstant());
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.simpleAnalyses.size()) + "," + this.minDepth + ".." + this.maxDepth + " ");
        s.append(this.primaryAnalysis);
        for (SimpleAnalysis simpleAnalysis : this.simpleAnalyses) {
            if (simpleAnalysis == this.primaryAnalysis) continue;
            s.append(" ++ " + simpleAnalysis);
        }
        return s.toString();
    }
}

