/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.CommonAnalysis;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.HashedAnalyses;
import org.eclipse.ocl.examples.codegen.cse.LocalPlace;
import org.eclipse.ocl.examples.codegen.cse.SimpleAnalysis;
import org.eclipse.ocl.examples.codegen.cse.StackPlace;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class ControlPlace
extends LocalPlace {
    @NonNull
    protected final LocalPlace parentPlace;
    @NonNull
    protected final CGValuedElement placedElement;
    private SimpleAnalysis controlAnalysis = null;
    @NonNull
    protected final HashedAnalyses hashedAnalyses = new HashedAnalyses();

    @NonNull
    public static AbstractPlace createControlPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGValuedElement cgElement) {
        if (cgElement.isGlobal()) {
            return (AbstractPlace)DomainUtil.nonNullState((Object)element2place.get(null));
        }
        CGElement cgParent = cgElement.getParent();
        AbstractPlace parentPlace = element2place.get(cgParent);
        if (parentPlace instanceof ControlPlace) {
            return parentPlace;
        }
        return new ControlPlace(ControlPlace.getLocalPlace(element2place, cgParent), cgElement);
    }

    @NonNull
    public static ControlPlace getControlPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGValuedElement cgElement) {
        AbstractPlace place = element2place.get(cgElement);
        if (place instanceof ControlPlace) {
            return (ControlPlace)place;
        }
        if (place != null) {
            throw new IllegalStateException("Non-ControlPlace " + place.getClass().getName() + " for " + cgElement);
        }
        CGElement cgParent = cgElement.getParent();
        AbstractPlace parentPlace = element2place.get(cgParent);
        ControlPlace controlPlace = parentPlace instanceof ControlPlace ? (ControlPlace)parentPlace : new ControlPlace(ControlPlace.getLocalPlace(element2place, cgParent), cgElement);
        element2place.put(cgElement, controlPlace);
        return controlPlace;
    }

    public ControlPlace(@NonNull LocalPlace parentPlace, @NonNull CGValuedElement cgElement) {
        super(parentPlace.getGlobalPlace());
        this.parentPlace = parentPlace;
        this.placedElement = cgElement;
        parentPlace.addControlPlace(this);
    }

    public void addAnalysis(@NonNull AbstractAnalysis anAnalysis) {
        this.hashedAnalyses.add(anAnalysis);
    }

    public int getDepth() {
        return this.controlAnalysis.getDepth();
    }

    @NonNull
    public HashedAnalyses getHashedAnalyses() {
        return this.hashedAnalyses;
    }

    @Override
    @NonNull
    public LocalPlace getParentPlace() {
        return this.parentPlace;
    }

    @NonNull
    public SimpleAnalysis getSimpleAnalysis() {
        SimpleAnalysis controlAnalysis2 = this.controlAnalysis;
        if (controlAnalysis2 == null) {
            controlAnalysis2 = this.globalPlace.getSimpleAnalysis(this.placedElement);
            assert (controlAnalysis2 != null);
            this.controlAnalysis = controlAnalysis2;
        }
        return controlAnalysis2;
    }

    @Override
    @NonNull
    public StackPlace getStackPlace() {
        return this.parentPlace.getStackPlace();
    }

    @Override
    public void printHierarchy(@NonNull Appendable appendable, @NonNull String indentation) {
        TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + this));
        if (!this.hashedAnalyses.isEmpty()) {
            for (AbstractAnalysis analysis : this.hashedAnalyses) {
                TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + "    " + analysis.getStructuralHashCode() + "," + analysis));
            }
        } else {
            TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + "    <empty>"));
        }
        super.printHierarchy(appendable, String.valueOf(indentation) + "  ");
    }

    @Override
    public void prune() {
        if (!this.hashedAnalyses.isEmpty()) {
            ArrayList<AbstractAnalysis> removals = null;
            HashMultimap depth2commonAnalyses = HashMultimap.create();
            for (AbstractAnalysis analysis : this.hashedAnalyses) {
                if (analysis instanceof CommonAnalysis) {
                    CommonAnalysis commonAnalysis = (CommonAnalysis)analysis;
                    int depth = commonAnalysis.getMinDepth();
                    depth2commonAnalyses.put((Object)depth, (Object)commonAnalysis);
                    continue;
                }
                if (removals == null) {
                    removals = new ArrayList<AbstractAnalysis>();
                }
                removals.add(analysis);
            }
            if (removals != null) {
                for (AbstractAnalysis removal : removals) {
                    this.hashedAnalyses.remove(removal);
                }
            }
        }
    }

    @Override
    public void pullUp() {
        ArrayList<AbstractAnalysis> removals = null;
        block0: for (AbstractAnalysis analysis : this.hashedAnalyses) {
            AbstractPlace localPlace = this;
            while (!((localPlace = localPlace.getParentPlace()) instanceof GlobalPlace)) {
                AbstractPlace controlPlace;
                HashedAnalyses controlAnalyses;
                AbstractAnalysis parentAnalysis;
                if (!(localPlace instanceof ControlPlace) || (parentAnalysis = (controlAnalyses = ((ControlPlace)(controlPlace = localPlace)).getHashedAnalyses()).get(analysis)) == null) continue;
                ((ControlPlace)controlPlace).addAnalysis(analysis);
                if (removals == null) {
                    removals = new ArrayList<AbstractAnalysis>();
                }
                removals.add(analysis);
                continue block0;
            }
        }
        if (removals != null) {
            for (AbstractAnalysis removal : removals) {
                this.hashedAnalyses.remove(removal);
            }
        }
        super.pullUp();
    }

    @Override
    public void rewrite() {
        super.rewrite();
        CodeGenAnalyzer analyzer = this.globalPlace.getAnalyzer();
        if (!this.hashedAnalyses.isEmpty()) {
            HashMap<CGValuedElement, AbstractAnalysis> locals = new HashMap<CGValuedElement, AbstractAnalysis>();
            for (AbstractAnalysis analysis : this.hashedAnalyses) {
                locals.put(analysis.getPrimaryElement(), analysis);
            }
            DependencyVisitor dependencyVisitor = analyzer.getCodeGenerator().createDependencyVisitor();
            HashSet allElements = new HashSet(locals.keySet());
            dependencyVisitor.visitAll(allElements);
            List<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies(false);
            for (CGValuedElement primaryElement : sortedDependencies) {
                AbstractAnalysis abstractAnalysis = (AbstractAnalysis)locals.get(primaryElement);
                if (!(abstractAnalysis instanceof CommonAnalysis)) continue;
                ((CommonAnalysis)abstractAnalysis).rewrite(analyzer, this.placedElement);
            }
        }
    }

    public String toString() {
        SimpleAnalysis controlAnalysis2 = this.controlAnalysis;
        if (controlAnalysis2 == null) {
            controlAnalysis2 = this.globalPlace.getSimpleAnalysis(this.placedElement);
        }
        return String.valueOf(this.getClass().getSimpleName()) + ": " + String.valueOf(controlAnalysis2);
    }
}

