/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.ControlPlace;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.StackPlace;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public abstract class LocalPlace
extends AbstractPlace {
    @NonNull
    protected final GlobalPlace globalPlace;
    private HashSet<ControlPlace> controlPlaces = null;

    @NonNull
    public static AbstractPlace createLocalPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGValuedElement cgElement) {
        boolean isGlobal = cgElement.isGlobal();
        if (isGlobal) {
            return (AbstractPlace)DomainUtil.nonNullState((Object)element2place.get(null));
        }
        return ControlPlace.createControlPlace(element2place, cgElement);
    }

    @NonNull
    protected static GlobalPlace getGlobalPlace(@NonNull Map<CGElement, AbstractPlace> element2place) {
        AbstractPlace abstractPlace = element2place.get(null);
        if (abstractPlace instanceof GlobalPlace) {
            return (GlobalPlace)abstractPlace;
        }
        throw new IllegalStateException("No GlobalPlace");
    }

    @NonNull
    protected static LocalPlace getLocalPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @Nullable CGElement cgElement) {
        if (cgElement == null) {
            throw new IllegalStateException("No LocalPlace for null element");
        }
        AbstractPlace abstractPlace = element2place.get(cgElement);
        return LocalPlace.getLocalPlace(abstractPlace, cgElement);
    }

    @NonNull
    protected static LocalPlace getLocalPlace(@Nullable AbstractPlace abstractPlace, @NonNull CGElement cgElement) {
        if (abstractPlace instanceof LocalPlace) {
            return (LocalPlace)abstractPlace;
        }
        throw new IllegalStateException("No LocalPlace for " + cgElement);
    }

    protected LocalPlace(@NonNull GlobalPlace globalPlace) {
        this.globalPlace = globalPlace;
    }

    public void addControlPlace(@NonNull ControlPlace controlPlace) {
        if (this.controlPlaces == null) {
            this.controlPlaces = new HashSet();
        }
        this.controlPlaces.add(controlPlace);
    }

    @Override
    @NonNull
    public GlobalPlace getGlobalPlace() {
        return this.globalPlace;
    }

    @Override
    @NonNull
    public abstract StackPlace getStackPlace();

    @Override
    public void printHierarchy(@NonNull Appendable appendable, @NonNull String indentation) {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.printHierarchy(appendable, indentation);
            }
        }
    }

    public void prune() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.prune();
            }
        }
    }

    public void pullUp() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.pullUp();
            }
        }
    }

    public void pushUp() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.pushUp();
            }
        }
    }

    public void rewrite() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.rewrite();
            }
        }
    }
}

