/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ImportUtils {
    public static final String IMPORTS_MARKER = "<%**imports**%>";
    public static final String IMPORTS_PREFIX = "<%";
    public static final String IMPORTS_SUFFIX = "%>";

    @NonNull
    public static String getAffixedName(@NonNull Class<?> javaClass) {
        return IMPORTS_PREFIX + javaClass.getName() + IMPORTS_SUFFIX;
    }

    @NonNull
    public static String getAffixedName(@NonNull String className) {
        return IMPORTS_PREFIX + className + IMPORTS_SUFFIX;
    }

    @NonNull
    public static Map<String, String> getLong2ShortImportNames(@NonNull Iterable<String> allImports) {
        String shortName;
        HashMap<String, String> long2shortNames = new HashMap<String, String>();
        HashMap<String, String> shortables = new HashMap<String, String>();
        for (String longName : allImports) {
            int index = longName.lastIndexOf(".");
            String string = shortName = index >= 0 ? longName.substring(index + 1) : longName;
            if (shortables.containsKey(shortName)) {
                String oldImport = (String)shortables.get(shortName);
                long2shortNames.put(oldImport, null);
                long2shortNames.put(longName, null);
                shortables.put(shortName, null);
                continue;
            }
            long2shortNames.put(longName, shortName);
            shortables.put(shortName, longName);
        }
        HashMap<String, String> long2short = new HashMap<String, String>();
        Iterator iterator = long2shortNames.keySet().iterator();
        while (iterator.hasNext()) {
            String longName;
            shortName = (String)long2shortNames.get(longName = (String)iterator.next());
            long2short.put(longName, shortName != null ? shortName : longName);
        }
        return long2short;
    }

    @NonNull
    public static String resolveImports(@NonNull String source, @NonNull Map<String, String> long2short) {
        int iSuffix;
        int iPrefix;
        int iMax = source.length();
        int iStart = source.indexOf(IMPORTS_MARKER);
        if (iStart < 0) {
            return source;
        }
        StringBuilder s = new StringBuilder();
        s.append(source, 0, iStart);
        ArrayList<String> sortedImports = new ArrayList<String>(long2short.keySet());
        Collections.sort(sortedImports);
        for (String anImport : sortedImports) {
            if (anImport.startsWith("java.lang.")) continue;
            s.append("import " + anImport + ";\n");
        }
        iStart += IMPORTS_MARKER.length();
        while ((iPrefix = source.indexOf(IMPORTS_PREFIX, iStart)) >= 0 && (iSuffix = source.indexOf(IMPORTS_SUFFIX, iPrefix)) >= 0) {
            s.append(source, iStart, iPrefix);
            String longName = source.substring(iPrefix + IMPORTS_PREFIX.length(), iSuffix);
            String shortname = long2short.get(longName);
            s.append(shortname != null ? shortname : longName);
            iStart = iSuffix + IMPORTS_SUFFIX.length();
        }
        s.append(source, iStart, iMax);
        String string = s.toString();
        return string;
    }
}

