/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.BooleanPrimitiveDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleValueDescriptor;
import org.eclipse.ocl.examples.domain.ids.ElementId;

public class BooleanObjectDescriptor
extends SimpleValueDescriptor
implements SimpleDescriptor {
    @NonNull
    protected final BooleanPrimitiveDescriptor primitiveTypeDescriptor;

    public BooleanObjectDescriptor(@NonNull ElementId elementId) {
        super(elementId, Boolean.class);
        this.primitiveTypeDescriptor = new BooleanPrimitiveDescriptor(elementId);
    }

    @Override
    public void appendNotEqualsTerm(@NonNull JavaStream js, @NonNull CGValuedElement thisValue, @NonNull TypeDescriptor thatTypeDescriptor, @NonNull String thatName) {
        if (thatTypeDescriptor instanceof BooleanPrimitiveDescriptor) {
            js.append("(");
            js.appendValueName(thisValue);
            js.append(" == null) || (");
            js.appendValueName(thisValue);
            js.append(" != ");
            js.append(thatName);
            js.append(")");
        } else {
            js.appendValueName(thisValue);
            js.append(" != ");
            js.append(thatName);
        }
    }

    @Override
    public void appendEqualsValue(@NonNull JavaStream js, @NonNull CGValuedElement thisValue, @NonNull CGValuedElement thatValue, boolean notEquals) {
        super.appendEqualsValue(js, thisValue, thatValue, notEquals);
    }

    @Override
    @NonNull
    public TypeDescriptor getPrimitiveDescriptor() {
        return this.primitiveTypeDescriptor;
    }
}

