/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BooleanObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedValuesDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EnumerationValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.FutureEObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.FutureEObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.IntegerValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.examples.codegen.java.types.RealValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.RootObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleDataTypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedElementsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnlimitedNaturalValueDescriptor;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.NestedPackageId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OclInvalidTypeId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TemplateableTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.UnspecifiedId;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;

public class Id2BoxedDescriptorVisitor
implements IdVisitor<BoxedDescriptor> {
    @NonNull
    protected final GenModelHelper genModelHelper;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final PivotIdResolver idResolver;

    public Id2BoxedDescriptorVisitor(@NonNull JavaCodeGenerator javaCodeGenerator) {
        this.genModelHelper = javaCodeGenerator.getGenModelHelper();
        this.metaModelManager = javaCodeGenerator.getMetaModelManager();
        this.idResolver = this.metaModelManager.getIdResolver();
    }

    protected EClassifier getEClassifier(@NonNull Type type) {
        for (DomainType dType : this.metaModelManager.getPartialTypes((DomainType)type)) {
            Type pType;
            EClassifier eClass;
            if (!(dType instanceof Type) || (eClass = (EClassifier)(pType = (Type)dType).getETarget()) == null) continue;
            return eClass;
        }
        return null;
    }

    @NonNull
    public BoxedDescriptor visitClassId(@NonNull ClassId id) {
        block4: {
            Type type = this.idResolver.getType((TypeId)id, null);
            EClassifier eClassifier = this.getEClassifier(type);
            if (eClassifier != null) {
                try {
                    Class<?> javaClass = this.genModelHelper.getEcoreInterfaceClassifier(eClassifier);
                    return new EObjectDescriptor((ElementId)id, eClassifier, javaClass);
                }
                catch (Exception e) {
                    String instanceClassName = type.getInstanceClassName();
                    if (instanceClassName == null) {
                        instanceClassName = this.genModelHelper.getEcoreInterfaceClassifierName(eClassifier);
                    }
                    if (instanceClassName == null) break block4;
                    return new FutureEObjectDescriptor((ElementId)id, eClassifier, instanceClassName);
                }
            }
        }
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitCollectionTypeId(@NonNull CollectionTypeId id) {
        AbstractCollectionDescriptor unboxedDescriptor;
        Type type;
        CollectionTypeId generalizedId;
        block7: {
            generalizedId = id.getGeneralizedId();
            if (generalizedId == id) {
                type = this.idResolver.getType((TypeId)id, null);
            } else {
                TypeId typeId = id.getElementTypeId();
                type = this.idResolver.getType(typeId, null);
            }
            unboxedDescriptor = null;
            EClassifier eClassifier = this.getEClassifier(type);
            if (eClassifier != null) {
                try {
                    Class<?> javaClass = this.genModelHelper.getEcoreInterfaceClassifier(eClassifier);
                    unboxedDescriptor = new EObjectsDescriptor(id, eClassifier, javaClass);
                }
                catch (Exception e) {
                    String instanceClassName = type.getInstanceClassName();
                    if (instanceClassName == null) {
                        instanceClassName = this.genModelHelper.getEcoreInterfaceClassifierName(eClassifier);
                    }
                    if (instanceClassName == null) break block7;
                    unboxedDescriptor = new FutureEObjectsDescriptor(id, eClassifier, instanceClassName);
                }
            }
        }
        if (unboxedDescriptor == null) {
            unboxedDescriptor = new UnboxedElementsDescriptor(id, (DomainStandardLibrary)this.metaModelManager, type);
        }
        Class boxedClass = generalizedId == TypeId.BAG ? BagValue.class : (generalizedId == TypeId.COLLECTION ? CollectionValue.class : (generalizedId == TypeId.ORDERED_SET ? OrderedSetValue.class : (generalizedId == TypeId.SEQUENCE ? SequenceValue.class : (generalizedId == TypeId.SET ? SetValue.class : CollectionValue.class))));
        return new BoxedValuesDescriptor((ElementId)id, boxedClass, unboxedDescriptor);
    }

    @NonNull
    public BoxedDescriptor visitDataTypeId(@NonNull DataTypeId id) {
        Type type = this.idResolver.getType((TypeId)id, null);
        String instanceClassName = type.getInstanceClassName();
        if (instanceClassName != null) {
            if (BigDecimal.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, BigDecimal.class));
            }
            if (BigInteger.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, BigInteger.class));
            }
            if (Byte.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Byte.class));
            }
            if (Double.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Double.class));
            }
            if (Float.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Float.class));
            }
            if (Integer.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Integer.class));
            }
            if (Long.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Long.class));
            }
            if (Short.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Short.class));
            }
            if (Byte.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Byte.TYPE));
            }
            if (Character.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Character.TYPE));
            }
            if (Double.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Double.TYPE));
            }
            if (Float.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Float.TYPE));
            }
            if (Integer.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Integer.TYPE));
            }
            if (Long.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Long.TYPE));
            }
            if (Short.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Short.TYPE));
            }
            return new SimpleDataTypeDescriptor((ElementId)id, instanceClassName);
        }
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitEnumerationId(@NonNull EnumerationId id) {
        return new EnumerationValueDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitInvalidId(@NonNull OclInvalidTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, InvalidValueException.class);
    }

    @NonNull
    public BoxedDescriptor visitLambdaTypeId(@NonNull LambdaTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainLambdaType.class);
    }

    @NonNull
    public BoxedDescriptor visitMetaclassId(@NonNull MetaclassId id) {
        if (id.getElementId() instanceof EnumerationLiteralId) {
            return new BoxedValueDescriptor((ElementId)id, EnumerationLiteralId.class, new UnboxedValueDescriptor((ElementId)id, Enumerator.class));
        }
        return new SimpleValueDescriptor((ElementId)id, DomainType.class);
    }

    @NonNull
    public BoxedDescriptor visitNestedPackageId(@NonNull NestedPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainPackage.class);
    }

    @NonNull
    public BoxedDescriptor visitNsURIPackageId(@NonNull NsURIPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainPackage.class);
    }

    @NonNull
    public BoxedDescriptor visitNullId(@NonNull OclVoidTypeId id) {
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitOperationId(@NonNull OperationId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainOperation.class);
    }

    @NonNull
    public BoxedDescriptor visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        if (id instanceof JavaTypeId) {
            Class<?> javaClass = ((JavaTypeId)id).getJavaClass();
            if (javaClass == Object.class) {
                return new RootObjectDescriptor((ElementId)id);
            }
            return new SimpleValueDescriptor((ElementId)id, javaClass);
        }
        if (id == TypeId.BOOLEAN) {
            return new BooleanObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.INTEGER) {
            return new IntegerValueDescriptor((ElementId)id);
        }
        if (id == TypeId.INTEGER_RANGE) {
            return new SimpleValueDescriptor((ElementId)id, IntegerRange.class);
        }
        if (id == TypeId.OCL_ANY) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.OCL_COMPARABLE) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.OCL_SUMMABLE) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.REAL) {
            return new RealValueDescriptor((ElementId)id);
        }
        if (id == TypeId.STRING) {
            return new SimpleValueDescriptor((ElementId)id, String.class);
        }
        if (id == TypeId.UNLIMITED_NATURAL) {
            return new UnlimitedNaturalValueDescriptor((ElementId)id);
        }
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitPropertyId(@NonNull PropertyId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainProperty.class);
    }

    @NonNull
    public BoxedDescriptor visitRootPackageId(@NonNull RootPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainPackage.class);
    }

    @NonNull
    public BoxedDescriptor visitTemplateBinding(@NonNull TemplateBinding id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitTemplateParameterId(@NonNull TemplateParameterId id) {
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainType.class);
    }

    @NonNull
    public BoxedDescriptor visitTuplePartId(@NonNull TuplePartId id) {
        return new SimpleValueDescriptor((ElementId)id, DomainProperty.class);
    }

    @NonNull
    public BoxedDescriptor visitTupleTypeId(@NonNull TupleTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, TupleValue.class);
    }

    @NonNull
    public BoxedDescriptor visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visiting(@NonNull ElementId id) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
    }
}

