/*******************************************************************************
 * Copyright (c) 2010, 2012 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.examples.domain.values.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.ids.TypeId;

/**
 * @generated NOT
 */
public class JavaObjectValueImpl extends ObjectValueImpl
{
	protected final @NonNull Object object;
//	protected DomainType type = null;
	protected TypeId typeId = null;
	
	public JavaObjectValueImpl(@NonNull TypeId typeId, @NonNull Object object) {
		this.object = object;
		this.typeId = typeId;
	}

	@Override
	public @NonNull Object asObject() {
		return object;
	}

	@Override
	public @NonNull Object getObject() {
		return object;
	}

/*	public @NonNull DomainType getType(@NonNull DomainStandardLibrary standardLibrary) {
		DomainType type2 = type;
		if (type2 == null) {										// WIP A better type
			if (object instanceof Comparable) {
				type2 = type = standardLibrary.getOclComparableType();
			}
			else {
				type2 = type = standardLibrary.getMetaclassType();
			}
		}
		return type2;
	} */

	public @NonNull TypeId getTypeId() {
//		return getType(valueFactory.getStandardLibrary()).getTypeId();
		TypeId typeId2 = typeId;
		if (typeId2 == null) {
			if (object instanceof Comparable) {
				typeId = typeId2 = TypeId.OCL_COMPARABLE;
			}
			else {
				typeId = typeId2 = TypeId.METACLASS;
			}
		}
		return typeId2;
	}

	@Override
	public int hashCode() {
		return object.hashCode();
	}
}
