/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.domain.elements.DomainIteration;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.elements.Labelable;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainUtil {
    private static final String maxIntValue = Integer.toString(Integer.MAX_VALUE);
    private static final int maxIntSize = maxIntValue.length();
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    public static final NameableComparator NAMEABLE_COMPARATOR = NameableComparator.INSTANCE;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Nullable
    public static EAnnotation basicGetMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation asMetamodelAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        return asMetamodelAnnotation;
    }

    @NonNull
    public static String bind(String messageTemplate, Object ... bindings) {
        String result = NLS.bind((String)messageTemplate, (Object[])bindings);
        return result;
    }

    @NonNull
    public static String convertFromOCLString(@NonNull String javaString) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                if ((aChar = in[off++]) == 'u') {
                    int value = 0;
                    if (off + 4 > end) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToOCLString(String theString) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(DomainUtil.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(DomainUtil.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(DomainUtil.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(DomainUtil.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    @NonNull
    public static Number createNumberFromString(@NonNull String aValue) throws NumberFormatException {
        if ("*".equals(aValue)) {
            return Unlimited.INSTANCE;
        }
        int len = aValue.length();
        if (len < maxIntSize || len == maxIntSize && maxIntValue.compareTo(aValue) >= 0) {
            Integer result = Integer.valueOf(aValue);
            assert (result != null);
            return result;
        }
        if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
            Long result = Long.valueOf(aValue);
            assert (result != null);
            return result;
        }
        return new BigInteger(aValue);
    }

    public static String debugEventType(int eventType) {
        switch (eventType) {
            case 1: {
                return "SET";
            }
            case 2: {
                return "UNSET";
            }
            case 3: {
                return "ADD";
            }
            case 4: {
                return "REMOVE";
            }
            case 5: {
                return "ADD_MANY";
            }
            case 6: {
                return "REMOVE_MANY";
            }
            case 7: {
                return "MOVE";
            }
            case 8: {
                return "REMOVING_ADAPTER";
            }
            case 9: {
                return "RESOLVE";
            }
        }
        return "Unknown-EventType-" + eventType;
    }

    public static String debugFullName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String debugSimpleName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static void formatMultiplicity(@NonNull StringBuilder s, long lower, long upper) {
        s.append("[");
        if (upper < 0L) {
            if (lower == 1L) {
                s.append("+");
            } else {
                if (lower != 0L) {
                    s.append(lower);
                    s.append("..");
                }
                s.append("*");
            }
        } else if (lower == 0L && upper == 1L) {
            s.append("?");
        } else {
            s.append(lower);
            if (lower != upper) {
                s.append("..");
                s.append(upper);
            }
        }
        s.append("]");
    }

    @NonNull
    public static EAnnotation getEAnnotation(@NonNull EModelElement eModelElement, String sourceURI) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(sourceURI);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static String getLabel(EObject eObject) {
        String text;
        if (eObject instanceof Labelable && (text = ((Labelable)eObject).getText()) != null) {
            return text;
        }
        return EcoreUtils.qualifiedNameFor((Object)eObject);
    }

    public static String getIndentation(int depth, @NonNull String string) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
        return s.toString();
    }

    public static String getLabel(EClassifier eClassifier, Object object, Map<Object, Object> context) {
        if (eClassifier instanceof EDataType) {
            return EObjectValidator.getValueLabel((EDataType)((EDataType)eClassifier), (Object)object, context);
        }
        if (object instanceof EObject) {
            if (context != null) {
                return EObjectValidator.getObjectLabel((EObject)((EObject)object), context);
            }
            return DomainUtil.getLabel((EObject)object);
        }
        return String.valueOf(object);
    }

    @NonNull
    public static DomainType[] getLambdaParameterTypes(@NonNull DomainLambdaType lambdaType) {
        int iParameter = 0;
        List<? extends DomainType> ownedParameters = lambdaType.getParameterTypes();
        DomainType[] parameterTypes = new DomainType[ownedParameters.size() + 2];
        parameterTypes[iParameter++] = lambdaType.getContextType();
        parameterTypes[iParameter++] = lambdaType.getResultType();
        for (DomainType domainType : ownedParameters) {
            parameterTypes[iParameter++] = domainType;
        }
        return parameterTypes;
    }

    @NonNull
    public static EAnnotation getMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/OCL/ASMetamodel");
            ePackage.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static <T extends Nameable> T getNamedElement(Iterable<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (Nameable element : elements) {
            if (!ClassUtils.equals((Object)name, (Object)element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    @NonNull
    public static DomainType[] getOperationParameterTypes(@NonNull DomainOperation anOperation) {
        DomainType[] parameterTypes;
        int iParameter = 0;
        List<? extends DomainTypedElement> ownedParameters = anOperation.getOwnedParameter();
        if (anOperation instanceof DomainIteration) {
            DomainIteration domainIteration = (DomainIteration)anOperation;
            List<? extends DomainTypedElement> ownedIterators = domainIteration.getOwnedIterator();
            List<? extends DomainTypedElement> ownedAccumulators = domainIteration.getOwnedAccumulator();
            parameterTypes = new DomainType[ownedIterators.size() + ownedAccumulators.size() + ownedParameters.size()];
            for (DomainTypedElement domainTypedElement : ownedIterators) {
                parameterTypes[iParameter++] = domainTypedElement.getType();
            }
            for (DomainTypedElement domainTypedElement : ownedAccumulators) {
                parameterTypes[iParameter++] = domainTypedElement.getType();
            }
        } else {
            parameterTypes = new DomainType[ownedParameters.size()];
        }
        for (DomainTypedElement domainTypedElement : ownedParameters) {
            parameterTypes[iParameter++] = domainTypedElement.getType();
        }
        return parameterTypes;
    }

    @NonNull
    public static String getSafeName(@Nullable Nameable aNameable) {
        if (aNameable == null) {
            return "";
        }
        String name = aNameable.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static boolean isRegistered(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceSet() == null;
    }

    @NonNull
    public static <T> T nonNullEMF(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullModel(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullPivot(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullState(@Nullable T aT) {
        if (aT == null) {
            throw new IllegalStateException();
        }
        return aT;
    }

    public static <T extends Comparable<T>> int safeCompareTo(@Nullable T object, @Nullable T otherObject) {
        if (object == null) {
            return otherObject == null ? 1 : 0;
        }
        return otherObject == null ? -1 : object.compareTo(otherObject);
    }

    public static boolean safeEquals(@Nullable Object object, @Nullable Object otherObject) {
        return object == null ? otherObject == null : object.equals(otherObject);
    }

    @Deprecated
    public static void suppressThrowWarnings() {
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EAnnotationComparator
    implements Comparator<EAnnotation> {
        @NonNull
        public static final EAnnotationComparator INSTANCE = new EAnnotationComparator();

        @Override
        public int compare(EAnnotation o1, EAnnotation o2) {
            String n1 = o1.getSource();
            String n2 = o2.getSource();
            return DomainUtil.safeCompareTo(n1, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ENamedElementComparator
    implements Comparator<ENamedElement> {
        @NonNull
        public static final ENamedElementComparator INSTANCE = new ENamedElementComparator();

        @Override
        public int compare(ENamedElement o1, ENamedElement o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return DomainUtil.safeCompareTo(n1, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NameableComparator
    implements Comparator<Nameable> {
        @NonNull
        public static final NameableComparator INSTANCE = new NameableComparator();

        @Override
        public int compare(Nameable o1, Nameable o2) {
            String n1 = DomainUtil.getSafeName(o1);
            String n2 = DomainUtil.getSafeName(o2);
            return DomainUtil.safeCompareTo(n1, n2);
        }
    }
}

