/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.compatibility.EMF_2_9;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMap
extends StandaloneProjectMap {
    @Nullable
    public static StandaloneProjectMap findAdapter(@NonNull ResourceSet resourceSet) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            return StandaloneProjectMap.findAdapter(resourceSet);
        }
        return (StandaloneProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ProjectMap.class);
    }

    @NonNull
    public static synchronized StandaloneProjectMap getAdapter(@NonNull ResourceSet resourceSet) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            return StandaloneProjectMap.getAdapter(resourceSet);
        }
        StandaloneProjectMap adapter = ProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new ProjectMap();
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    @Override
    @NonNull
    protected StandaloneProjectMap.IProjectDescriptor createProjectDescriptor(@NonNull String projectName, @NonNull URI locationURI) {
        return new ProjectDescriptor(this, projectName, locationURI);
    }

    @Override
    public URI getLocation(@NonNull String projectName) {
        URI uri = super.getLocation(projectName);
        if (uri == null && EMFPlugin.IS_ECLIPSE_RUNNING) {
            uri = URI.createPlatformPluginURI((String)("/" + projectName + "/"), (boolean)true);
        }
        return uri;
    }

    @Override
    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap && !EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.initializePlatformResourceMap(force);
        }
    }

    @Override
    public synchronized void initializeURIMap(@Nullable ResourceSet resourceSet) {
        super.initializeURIMap(resourceSet);
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Map<URI, URI> uriMap = ProjectMap.getURIMap(resourceSet);
            URI resourceURI = URI.createPlatformResourceURI((String)"/", (boolean)true);
            URI pluginURI = URI.createPlatformPluginURI((String)"/", (boolean)true);
            uriMap.put(resourceURI, pluginURI);
        }
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(ProjectMap.class);
    }

    @Override
    protected void scanClassPath(@NonNull Map<String, StandaloneProjectMap.IProjectDescriptor> projectDescriptors, @NonNull SAXParser saxParser) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.scanClassPath(projectDescriptors, saxParser);
        } else {
            this.scanProjects(projectDescriptors);
            this.scanGenModels(saxParser);
        }
    }

    protected void scanGenModels(@NonNull SAXParser saxParser) {
        Map<Object, Object> nsURI2className;
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
        HashMap<URI, HashMap<URI, String>> genModel2nsURI2className = new HashMap<URI, HashMap<URI, String>>();
        for (String ePackageNsURI : ePackageNsURIToGenModelLocationMap.keySet()) {
            URI genModelURI = ePackageNsURIToGenModelLocationMap.get(ePackageNsURI);
            if (genModelURI == null) continue;
            nsURI2className = (HashMap<URI, Object>)genModel2nsURI2className.get(genModelURI);
            if (nsURI2className == null) {
                nsURI2className = new HashMap<URI, Object>();
                genModel2nsURI2className.put(genModelURI, (HashMap<URI, String>)nsURI2className);
            }
            nsURI2className.put(URI.createURI((String)ePackageNsURI), null);
        }
        for (URI genModelURI : genModel2nsURI2className.keySet()) {
            if (!genModelURI.isPlatformPlugin()) continue;
            StandaloneProjectMap.IProjectDescriptor projectDescriptor = this.getProjectDescriptorInternal(genModelURI);
            nsURI2className = (Map)genModel2nsURI2className.get(genModelURI);
            URI deresolvedGenModelURI = genModelURI.deresolve(projectDescriptor.getLocationURI(), true, true, true);
            String genModelString = deresolvedGenModelURI.toString();
            StandaloneProjectMap.IResourceDescriptor resourceDescriptor = projectDescriptor.createResourceDescriptor(genModelString, nsURI2className);
            StandaloneProjectMap.GenModelReader genModelReader = new StandaloneProjectMap.GenModelReader(resourceDescriptor);
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uriConverter.createInputStream(genModelURI);
                    saxParser.parse(inputStream, (DefaultHandler)genModelReader);
                }
                catch (Exception e) {
                    this.logException("Failed to parse '" + genModelURI + "'", e);
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (inputStream == null) continue;
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void scanProjects(@NonNull Map<String, StandaloneProjectMap.IProjectDescriptor> projectDescriptors) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                String projectName = project.getName();
                String projectKey = "/" + projectName + "/";
                URI platformResourceURI = URI.createPlatformResourceURI((String)projectKey, (boolean)true);
                projectDescriptors.put(projectName, this.createProjectDescriptor(projectName, platformResourceURI));
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectDescriptor
    extends StandaloneProjectMap.ProjectDescriptor {
        public ProjectDescriptor(@NonNull ProjectMap projectMap, @NonNull String name, @NonNull URI locationURI) {
            super(projectMap, name, locationURI);
        }

        @Override
        public void initializeURIMap(@NonNull Map<URI, URI> uriMap) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                super.initializeURIMap(uriMap);
            } else if (this.locationURI.isPlatformResource()) {
                URI resourceURI = this.locationURI;
                URI pluginURI = this.getPlatformPluginURI();
                uriMap.put(resourceURI, resourceURI);
                uriMap.put(pluginURI, resourceURI);
                if (PROJECT_MAP_ADD_URI_MAP.isActive()) {
                    PROJECT_MAP_ADD_URI_MAP.println(resourceURI + " => " + resourceURI);
                    PROJECT_MAP_ADD_URI_MAP.println(pluginURI + " => " + resourceURI);
                }
            }
        }
    }
}

