/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.NumberValueImpl;

public class UnlimitedValueImpl
extends NumberValueImpl
implements UnlimitedValue {
    private static final long serialVersionUID = 8556985089778234910L;

    protected EClass eStaticClass() {
        return ValuesPackage.Literals.UNLIMITED_VALUE;
    }

    @NonNull
    public UnlimitedValueImpl abs() {
        return this;
    }

    @NonNull
    public IntegerValue addInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @NonNull
    public RealValue addReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @NonNull
    public Object asEcoreObject(@NonNull IdResolver idResolver) {
        return Unlimited.INSTANCE;
    }

    @NonNull
    public Number asNumber() {
        return Unlimited.INSTANCE;
    }

    @NonNull
    public Object asObject() {
        return Unlimited.INSTANCE;
    }

    @NonNull
    public RealValue asRealValue() {
        return this;
    }

    @NonNull
    public Value asUnlimitedNaturalValue() {
        return this;
    }

    @NonNull
    public BigDecimal bigDecimalValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "bigDecimalValue", "UnlimitedValue");
    }

    @NonNull
    public BigInteger bigIntegerValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "bigIntegerValue", "UnlimitedValue");
    }

    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue commutatedDiv(@NonNull IntegerValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue commutatedMod(@NonNull IntegerValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    public int compareTo(RealValue left) {
        return -left.compareToUnlimited(this);
    }

    public int compareToInteger(@NonNull IntegerValue right) {
        return 1;
    }

    public int compareToReal(@NonNull RealValue right) {
        return 1;
    }

    public int compareToUnlimited(@NonNull UnlimitedValue right) {
        return 0;
    }

    @NonNull
    public IntegerValue divInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue divUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    @NonNull
    public RealValue divideReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    public double doubleValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidReal, null, null, this);
    }

    public float floatValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidReal, null, null, this);
    }

    @NonNull
    public IntegerValue floor() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "floor", "UnlimitedValue");
    }

    @NonNull
    public DomainType getType(@NonNull DomainStandardLibrary standardLibrary) {
        return standardLibrary.getUnlimitedNaturalType();
    }

    @NonNull
    public TypeId getTypeId() {
        return TypeId.UNLIMITED_NATURAL;
    }

    public int intValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, null, null, this);
    }

    @Nullable
    public IntegerValue isIntegerValue() {
        return null;
    }

    public boolean isUnlimited() {
        return true;
    }

    public boolean isUnlimitedNatural() {
        return true;
    }

    public long longValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, null, null, this);
    }

    @NonNull
    public RealValue max(@NonNull RealValue rightValue) {
        return this;
    }

    @NonNull
    public IntegerValue maxInteger(@NonNull IntegerValue right) {
        return this;
    }

    @NonNull
    public RealValue maxReal(@NonNull RealValue right) {
        return this;
    }

    @NonNull
    public RealValue maxUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @NonNull
    public RealValue min(@NonNull RealValue rightValue) {
        return rightValue;
    }

    @NonNull
    public RealValue minUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @NonNull
    public IntegerValue minInteger(@NonNull IntegerValue right) {
        return right;
    }

    @NonNull
    public RealValue minReal(@NonNull RealValue right) {
        return right;
    }

    @NonNull
    public IntegerValue modInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue modUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @NonNull
    public RealValue multiplyReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @NonNull
    public UnlimitedValue negate() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "negate", "UnlimitedValue");
    }

    @NonNull
    public IntegerValue round() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "round", "UnlimitedValue");
    }

    public int signum() {
        return 1;
    }

    @NonNull
    public IntegerValue subtractInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    @NonNull
    public RealValue subtractReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    public String toString() {
        return "*";
    }
}

