/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter2;

public abstract class AbstractExporter
implements IValidityExporter2 {
    @NonNull
    protected final List<LeafConstrainingNode> validationErrors = new ArrayList<LeafConstrainingNode>();
    @NonNull
    protected final List<LeafConstrainingNode> validationFailures = new ArrayList<LeafConstrainingNode>();
    @NonNull
    protected final List<LeafConstrainingNode> validationInfos = new ArrayList<LeafConstrainingNode>();
    @NonNull
    protected final List<LeafConstrainingNode> validationSuccess = new ArrayList<LeafConstrainingNode>();
    @NonNull
    protected final List<LeafConstrainingNode> validationWarnings = new ArrayList<LeafConstrainingNode>();

    private void clearMaps() {
        this.validationSuccess.clear();
        this.validationErrors.clear();
        this.validationFailures.clear();
        this.validationWarnings.clear();
        this.validationInfos.clear();
    }

    @Deprecated
    protected abstract void createContents(@NonNull Appendable var1, @Nullable Resource var2, @NonNull RootNode var3, @Nullable String var4) throws IOException;

    protected void createContents(@NonNull Appendable s, @NonNull RootNode rootNode, @Nullable String exportedFileName) throws IOException {
        this.createContents(s, null, rootNode, exportedFileName);
    }

    @Override
    @Deprecated
    @NonNull
    public String export(@Nullable Resource unused, @NonNull RootNode rootNode, @Nullable String exportedFileName) {
        return this.export(rootNode, exportedFileName);
    }

    @Override
    @Deprecated
    public void export(@NonNull Appendable s, @Nullable Resource unused, @NonNull RootNode rootNode, @Nullable String exportedFileName) throws IOException {
        this.export(s, rootNode, exportedFileName);
    }

    @Override
    @NonNull
    public String export(@NonNull RootNode rootNode, @Nullable String exportedFileName) {
        StringBuilder s = new StringBuilder();
        try {
            this.export(s, rootNode, exportedFileName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = s.toString();
        return string;
    }

    @Override
    public void export(@NonNull Appendable s, @NonNull RootNode rootNode, @Nullable String exportedFileName) throws IOException {
        this.populateMaps(rootNode);
        this.createContents(s, rootNode, exportedFileName);
        this.clearMaps();
    }

    protected int getConstraintCount() {
        return this.validationErrors.size() + this.validationFailures.size() + this.validationInfos.size() + this.validationSuccess.size() + this.validationWarnings.size();
    }

    @Override
    @NonNull
    public IValidityExporter getExporter() {
        return this;
    }

    protected String getMessage(Result result) {
        if (result == null) {
            return null;
        }
        StringWriter message = new StringWriter();
        Object diagnostic = result.getDiagnostic();
        if (diagnostic != null) {
            if (diagnostic instanceof Diagnostic) {
                boolean isFirst = true;
                List diagnosticChildren = ((Diagnostic)diagnostic).getChildren();
                if (diagnosticChildren != null && !diagnosticChildren.isEmpty()) {
                    for (Diagnostic child : diagnosticChildren) {
                        if (isFirst) {
                            message.append(child.getMessage());
                            isFirst = false;
                            continue;
                        }
                        message.append("\n" + child.getMessage());
                    }
                } else {
                    message.append(((Diagnostic)diagnostic).getMessage());
                }
                return message.toString();
            }
            return diagnostic.toString();
        }
        message.append("null diagnostic message");
        Throwable exception = result.getException();
        if (exception != null) {
            message.append('\n');
            exception.printStackTrace(new PrintWriter(message));
        }
        return message.toString();
    }

    protected String getSeverity(Result result) {
        if (result != null) {
            return result.getSeverity().getName();
        }
        return null;
    }

    private void populateMaps(RootNode rootNode) {
        for (ValidatableNode validatableNode : rootNode.getValidatableNodes()) {
            this.populateMaps(validatableNode);
        }
    }

    private void populateMaps(ValidatableNode validatableNode) {
        if (validatableNode instanceof ResultValidatableNode) {
            ResultValidatableNode resultValidatableNode = (ResultValidatableNode)validatableNode;
            Result result = resultValidatableNode.getWorstResult();
            if (result != null) {
                LeafConstrainingNode leafConstrainingNode = result.getLeafConstrainingNode();
                Severity severity = result.getSeverity();
                switch (severity.getValue()) {
                    case 1: {
                        this.validationSuccess.add(leafConstrainingNode);
                        break;
                    }
                    case 4: {
                        this.validationErrors.add(leafConstrainingNode);
                        break;
                    }
                    case 5: {
                        this.validationFailures.add(leafConstrainingNode);
                        break;
                    }
                    case 3: {
                        this.validationWarnings.add(leafConstrainingNode);
                        break;
                    }
                    case 2: {
                        this.validationInfos.add(leafConstrainingNode);
                        break;
                    }
                }
            }
        } else {
            for (ValidatableNode node : validatableNode.getChildren()) {
                this.populateMaps(node);
            }
        }
    }
}

