/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.export.AbstractExporter;
import org.eclipse.ocl.examples.emf.validation.validity.messages.ValidityMessages;

public class HTMLExporter
extends AbstractExporter {
    @NonNull
    public static final String EXPORTER_TYPE = "html";
    @NonNull
    public static final HTMLExporter INSTANCE = new HTMLExporter();

    private void appendTitlesTable(@NonNull Appendable s) throws IOException {
        s.append("\t\t\t<tr>\n");
        s.append("\t\t\t\t<td><b>Resource</b></td>\n");
        s.append("\t\t\t\t<td><b>Invariant</b></td>\n");
        s.append("\t\t\t\t<td><b>Expression</b></td>\n");
        s.append("\t\t\t\t<td><b>Severity</b></td>\n");
        s.append("\t\t\t\t<td><b>Message</b></td>\n");
        s.append("\t\t\t</tr>\n");
    }

    private void appendLogFile(LeafConstrainingNode node, @NonNull Appendable s, String severity) throws IOException {
        s.append("\t\t\t<tr>\n");
        Resource resource = node.getConstraintResource();
        if (resource != null) {
            s.append("\t\t\t<td> Resource: " + resource.getURI().lastSegment() + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>" + ValidityMessages.ValidityView_Constraints_LabelProvider_UnexistingResource + "</td>\n");
        }
        s.append("\t\t\t\t<td>" + node.getLabel() + "</td>\n");
        String expression = node.getConstraintString();
        if (expression != null) {
            s.append("\t\t\t\t<td>" + expression + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>" + ValidityMessages.ValidityView_Constraints_LabelProvider_UnattainableExpression + "</td>\n");
        }
        s.append("\t\t\t\t<td>" + severity + "</td>\n");
        s.append("\t\t\t\t<td>" + StringEscapeUtils.escapeHtml((String)this.getMessage(node.getWorstResult())) + "</td>\n");
        s.append("\t\t\t</tr>\n");
    }

    @Override
    public void createContents(@NonNull Appendable html, @Nullable Resource unused, @NonNull RootNode rootNode, @Nullable String exportedFileName) throws IOException {
        html.append("<html>\n");
        html.append("\t<head></head>\n");
        html.append("\t<body>\n");
        html.append("\t\t<h1>1. GENERAL INFORMATION</h1>\n");
        html.append("\t\t<table border=\"1\">\n");
        if (exportedFileName != null) {
            html.append("\t\t\t<tr>\n");
            html.append("\t\t\t\t<td><b>Output file name: </b></td>\n");
            html.append("\t\t\t\t<td>" + exportedFileName + "</td>\n");
            html.append("\t\t\t</tr>\n");
        }
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Author: </b></td>\n");
        html.append("\t\t\t\t<td>" + System.getProperty("user.name") + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t</table>\n");
        html.append("\n");
        html.append("\n");
        html.append("\t\t<h1>2. RESOURCES USED</h1>\n");
        html.append("\t\t\t<h2>2.1. Model checked</h2>\n");
        html.append("\t\t\t<ul>\n");
        ArrayList<String> uriStrings = new ArrayList<String>();
        for (RootValidatableNode rootValidatableNode : rootNode.getValidatableNodes()) {
            Resource eResource = rootValidatableNode.getConstrainedObject().eResource();
            uriStrings.add(eResource.getURI().toString());
        }
        Collections.sort(uriStrings);
        for (String uriString : uriStrings) {
            html.append("\t\t\t\t<li>" + uriString + "</li>\n");
        }
        html.append("\t\t\t</ul>\n");
        html.append("<br/>\n");
        html.append("\t\t<h1>3. METRICS</h1>\n");
        html.append("\t\t<table border=\"1\">\n");
        int total = this.getConstraintCount();
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Total number of evaluated constraints: </b></td>\n");
        html.append("\t\t\t\t<td>" + total + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Success: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.validationSuccess.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Infos: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.validationInfos.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Warnings: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.validationWarnings.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Errors: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.validationErrors.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Failures: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.validationFailures.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t</table>\n");
        html.append("\t\t<h1>4. LOGS</h1>\n");
        if (this.validationSuccess.size() == total) {
            html.append("<p>No log to display: models has been successfully validated.</p>\n");
        } else {
            int section = 1;
            HashSet<Object> loggedConstrainingObjects = new HashSet<Object>();
            if (!this.validationInfos.isEmpty()) {
                html.append("\t\t<h2>4." + section + ". Infos</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendTitlesTable(html);
                for (LeafConstrainingNode infoNode : this.validationInfos) {
                    if (!loggedConstrainingObjects.add(infoNode.getConstrainingObject())) continue;
                    this.appendLogFile(infoNode, html, Severity.INFO.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
            if (!this.validationWarnings.isEmpty()) {
                html.append("\t\t<h2>4." + section + ". Warnings</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendTitlesTable(html);
                for (LeafConstrainingNode warningNode : this.validationWarnings) {
                    if (!loggedConstrainingObjects.add(warningNode.getConstrainingObject())) continue;
                    this.appendLogFile(warningNode, html, Severity.WARNING.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
            if (!this.validationErrors.isEmpty()) {
                html.append("\t\t<h2>4." + section + ". Errors</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendTitlesTable(html);
                for (LeafConstrainingNode errorNode : this.validationErrors) {
                    if (!loggedConstrainingObjects.add(errorNode.getConstrainingObject())) continue;
                    this.appendLogFile(errorNode, html, Severity.ERROR.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
            if (!this.validationFailures.isEmpty()) {
                html.append("\t\t<h2>4." + section + ". Failures</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendTitlesTable(html);
                for (LeafConstrainingNode failureNode : this.validationFailures) {
                    if (!loggedConstrainingObjects.add(failureNode.getConstrainingObject())) continue;
                    this.appendLogFile(failureNode, html, Severity.FATAL.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
        }
        html.append("</body>\n");
        html.append("</html>\n");
    }

    @Override
    @NonNull
    public String getExporterType() {
        return EXPORTER_TYPE;
    }

    @Override
    @NonNull
    public String getPreferredExtension() {
        return EXPORTER_TYPE;
    }
}

