/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.plugin.ValidityPlugin;

public class ValidityExporterDescriptor
implements IValidityExporterDescriptor {
    private final IConfigurationElement element;
    @NonNull
    private final String exporterClassAttribute;
    @NonNull
    private final String exporterName;
    @NonNull
    private final String exporterType;
    private IValidityExporter exporter;

    public ValidityExporterDescriptor(IConfigurationElement configuration, @NonNull String exporterClassAttribute, @NonNull String exporterType, @NonNull String exporterName) {
        this.element = configuration;
        this.exporterClassAttribute = exporterClassAttribute;
        this.exporterType = exporterType;
        this.exporterName = exporterName;
    }

    @Override
    @NonNull
    public String getExporterType() {
        return this.exporterType;
    }

    @NonNull
    public String getExporterName() {
        return this.exporterName;
    }

    @Override
    @NonNull
    public IValidityExporter getExporter() {
        IValidityExporter exporter2 = this.exporter;
        if (exporter2 == null) {
            try {
                this.exporter = exporter2 = (IValidityExporter)this.element.createExecutableExtension(this.exporterClassAttribute);
            }
            catch (CoreException e) {
                ValidityPlugin.getPlugin().getLog().log(e.getStatus());
            }
        }
        assert (exporter2 != null);
        return exporter2;
    }
}

