/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.export.HTMLExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.export.ModelExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.TextExporter;

public class ValidityExporterRegistry {
    @NonNull
    public static final ValidityExporterRegistry INSTANCE = new ValidityExporterRegistry();
    private final Map<String, IValidityExporterDescriptor> EXTENSIONS = new HashMap<String, IValidityExporterDescriptor>();

    public static void initialize(@NonNull ValidityExporterRegistry registry) {
        registry.addExporter(HTMLExporter.INSTANCE);
        registry.addExporter(ModelExporter.INSTANCE);
        registry.addExporter(TextExporter.INSTANCE);
    }

    private ValidityExporterRegistry() {
    }

    public void addExporter(@NonNull IValidityExporterDescriptor exporter) {
        this.EXTENSIONS.put(exporter.getExporterType(), exporter);
    }

    public void clearRegistry() {
        this.EXTENSIONS.clear();
    }

    @Nullable
    public IValidityExporter getExporter(@NonNull String exporterType) {
        IValidityExporterDescriptor exporter = this.EXTENSIONS.get(exporterType);
        return exporter != null ? exporter.getExporter() : null;
    }

    public Collection<IValidityExporterDescriptor> getRegisteredExtensions() {
        return this.EXTENSIONS.values();
    }

    public void removeExtension(@NonNull String exporterType) {
        this.EXTENSIONS.remove(exporterType);
    }
}

