/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.ui.icons;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.modelregistry.ui.icons.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Icons {
    private static final Map<String, Image> stringToImage = new HashMap<String, Image>();

    private Icons() {
    }

    private static String getFullIconName(Enum<?> icon) {
        return String.valueOf(icon.getDeclaringClass().getName()) + "." + icon.name();
    }

    public static Image getImage(Enum<?> icon) {
        if (icon == null) {
            return null;
        }
        String key = Icons.getFullIconName(icon);
        Image img = stringToImage.get(key);
        if (img == null) {
            img = Icons.getImageDescriptor(icon).createImage();
            stringToImage.put(key, img);
        }
        return img;
    }

    public static ImageDescriptor getImageDescriptor(Enum<?> icon) {
        return ImageDescriptor.createFromFile(icon.getDeclaringClass(), (String)(String.valueOf(icon.name()) + ".gif"));
    }

    public static Image getImage(Enum<?> imageIcon, Enum<?> overlayIcon, Enum<?> underlayIcon) {
        String key;
        Image image;
        if (imageIcon == null) {
            return null;
        }
        Image baseImage = Icons.getImage(imageIcon);
        if (overlayIcon == null && underlayIcon == null) {
            return baseImage;
        }
        StringBuilder s = new StringBuilder();
        s.append(Icons.getFullIconName(imageIcon));
        s.append("+");
        if (overlayIcon != null) {
            s.append(Icons.getFullIconName(overlayIcon));
        }
        s.append("+");
        if (underlayIcon != null) {
            s.append(Icons.getFullIconName(underlayIcon));
        }
        if ((image = stringToImage.get(key = s.toString())) == null) {
            Rectangle bounds = baseImage.getBounds();
            Point size = new Point(bounds.width, bounds.height);
            ImageDescriptor overlayImageDescriptor = overlayIcon != null ? Icons.getImageDescriptor(overlayIcon) : null;
            ImageDescriptor underlayImageDescriptor = underlayIcon != null ? Icons.getImageDescriptor(underlayIcon) : null;
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[2] = overlayImageDescriptor;
            imageDescriptorArray[4] = underlayImageDescriptor;
            DecorationOverlayIcon imageDescriptor = new DecorationOverlayIcon(baseImage, imageDescriptorArray, size);
            image = imageDescriptor.createImage();
            stringToImage.put(key, image);
        }
        return image;
    }
}

