/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLDebugOptions;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.ObjectUtil;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.helper.OCLHelperImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCL {
    @NonNull
    private final EnvironmentFactory environmentFactory;
    @NonNull
    private final Environment rootEnvironment;
    private EvaluationEnvironment evalEnv;
    @Nullable
    private DomainModelManager modelManager;
    @NonNull
    private List<Constraint> constraints = new ArrayList<Constraint>();
    @Nullable
    private Diagnostic problems;
    @Nullable
    private Diagnostic evaluationProblems;
    private int parserRepairCount = 0;
    private boolean traceParsing = PivotPlugin.shouldTrace(OCLDebugOptions.PARSING);
    private boolean traceEvaluation = PivotPlugin.shouldTrace(OCLDebugOptions.EVALUATION);

    public static String initialize(@Nullable ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet != null ? resourceSet.getResourceFactoryRegistry() : Resource.Factory.Registry.INSTANCE;
        resourceFactoryRegistry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        return null;
    }

    @NonNull
    public static OCL newInstance() {
        return OCL.newInstance(new PivotEnvironmentFactory(null, new MetaModelManager()));
    }

    @NonNull
    public static OCL newInstance(@NonNull EPackage.Registry reg) {
        return OCL.newInstance(new PivotEnvironmentFactory(reg, new MetaModelManager()));
    }

    @NonNull
    public static OCL newInstance(@NonNull EnvironmentFactory envFactory) {
        return new OCL(envFactory, envFactory.createEnvironment());
    }

    @NonNull
    public static OCL newInstance(@NonNull EnvironmentFactory envFactory, @NonNull Resource resource) {
        return new OCL(envFactory, envFactory.loadEnvironment(resource));
    }

    @NonNull
    public static OCL newInstance(@NonNull Environment env) {
        return new OCL(env.getFactory(), env);
    }

    protected OCL(@NonNull EnvironmentFactory envFactory, @NonNull Environment rootEnv) {
        this.environmentFactory = envFactory;
        this.rootEnvironment = rootEnv;
        if (envFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)envFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public boolean check(Object context, @NonNull Constraint constraint) {
        OpaqueExpression specification = constraint.getSpecification();
        return specification instanceof ExpressionInOCL && this.check(context, (ExpressionInOCL)specification);
    }

    public boolean check(Object context, @NonNull ExpressionInOCL specification) {
        DomainStandardLibrary stdlib = this.getEnvironment().getOCLStandardLibrary();
        if (specification.getBodyExpression().getType() != stdlib.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        try {
            Object result = this.evaluate(context, specification);
            return result == ValuesUtil.TRUE_VALUE;
        }
        catch (InvalidValueException e) {
            return false;
        }
    }

    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@Nullable Object context, @NonNull ExpressionInOCL expression) {
        return this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, context, expression, this.modelManager);
    }

    @NonNull
    public OCLHelper createOCLHelper() {
        return new OCLHelperImpl(this);
    }

    @NonNull
    public OCLHelper createOCLHelper(@NonNull EObject element) {
        EStructuralFeature property;
        EClass eContainingClass;
        OCLHelperImpl helper = new OCLHelperImpl(this);
        if (element instanceof Type) {
            helper.setContext((Type)element);
        } else if (element instanceof Operation) {
            Operation operation = (Operation)element;
            Type owningType = operation.getOwningType();
            if (owningType != null) {
                helper.setOperationContext(owningType, operation);
            }
        } else if (element instanceof Property) {
            Property property2 = (Property)element;
            Type owningType = property2.getOwningType();
            if (owningType != null) {
                helper.setPropertyContext(owningType, property2);
            }
        } else if (element instanceof EClassifier) {
            helper.setContext((EClassifier)element);
        } else if (element instanceof EOperation) {
            EOperation operation = (EOperation)element;
            EClass eContainingClass2 = operation.getEContainingClass();
            if (eContainingClass2 != null) {
                helper.setOperationContext((EClassifier)eContainingClass2, operation);
            }
        } else if (element instanceof EStructuralFeature && (eContainingClass = (property = (EStructuralFeature)element).getEContainingClass()) != null) {
            helper.setPropertyContext((EClassifier)eContainingClass, property);
        }
        return helper;
    }

    @NonNull
    public Query createQuery(@NonNull ExpressionInOCL specification) {
        return new QueryImpl(this, specification);
    }

    public Query createQuery(@NonNull Constraint constraint) {
        OpaqueExpression specification = constraint.getSpecification();
        if (specification instanceof ExpressionInOCL) {
            return new QueryImpl(this, (ExpressionInOCL)specification);
        }
        return null;
    }

    @NonNull
    public Resource cs2pivot(@NonNull BaseResource csResource) {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        ASResource asResource = csResource.getASResource(metaModelManager);
        return asResource;
    }

    public void dispose() {
        for (Constraint constraint : this.getConstraints()) {
            Constraint eObject = constraint;
            if (eObject.eResource() != null) continue;
            ObjectUtil.dispose(constraint);
        }
        this.getConstraints().clear();
        if (this.environmentFactory != PivotEnvironmentFactory.basicGetGlobalRegistryInstance()) {
            this.getEnvironment().dispose();
            this.getMetaModelManager().dispose();
        }
    }

    @NonNull
    public ASResource ecore2pivot(@NonNull Resource ecoreResource) throws ParserException {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        Root pivotRoot = ecore2Pivot.getPivotRoot();
        ASResource asResource = (ASResource)pivotRoot.eResource();
        return (ASResource)DomainUtil.nonNullModel((Object)asResource);
    }

    @Nullable
    public Object evaluate(@Nullable Object context, @NonNull ExpressionInOCL expression) {
        this.evaluationProblems = null;
        EvaluationVisitor evaluationVisitor = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, context, expression, this.modelManager);
        try {
            Object result = expression.accept(evaluationVisitor);
            return result;
        }
        catch (EvaluationHaltedException e) {
            this.evaluationProblems = e.getDiagnostic();
            throw e;
        }
    }

    @NonNull
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    @NonNull
    public Environment getEnvironment() {
        return this.rootEnvironment;
    }

    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Deprecated
    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        EvaluationEnvironment evalEnv2 = this.evalEnv;
        if (evalEnv2 == null) {
            evalEnv2 = this.evalEnv = this.environmentFactory.createEvaluationEnvironment();
        }
        return evalEnv2;
    }

    @Nullable
    public Diagnostic getEvaluationProblems() {
        return this.evaluationProblems;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.rootEnvironment.getMetaModelManager();
    }

    @Nullable
    public DomainModelManager getModelManager() {
        return this.modelManager;
    }

    public int getParserRepairCount() {
        return this.parserRepairCount;
    }

    @Nullable
    public Diagnostic getProblems() {
        return this.problems;
    }

    @Nullable
    public ExpressionInOCL getSpecification(@NonNull Constraint constraint) throws ParserException {
        Namespace contextElement;
        String expression;
        OpaqueExpression specification = constraint.getSpecification();
        ExpressionInOCL expressionInOCL = null;
        if (specification instanceof ExpressionInOCL) {
            expressionInOCL = (ExpressionInOCL)specification;
        } else if (specification != null && (expression = PivotUtil.getBody(specification)) != null && (contextElement = constraint.getContext()) != null) {
            OCLHelper helper = this.createOCLHelper(contextElement);
            expressionInOCL = contextElement instanceof Operation ? helper.createBodyCondition(expression) : helper.createQuery(expression);
        }
        return expressionInOCL;
    }

    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public boolean isParseTracingEnabled() {
        return this.traceParsing;
    }

    @Nullable
    public BaseResource load(@NonNull URI uri) {
        ResourceSet externalResourceSet = this.getMetaModelManager().getExternalResourceSet();
        return (BaseResource)externalResourceSet.getResource(uri, true);
    }

    @Nullable
    public Resource parse(@NonNull URI uri) {
        BaseResource csResource = this.load(uri);
        return csResource != null ? this.cs2pivot(csResource) : null;
    }

    public void pivot2cs(@NonNull ASResource asResource, @NonNull BaseResource csResource) {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        csResource.updateFrom(asResource, metaModelManager);
    }

    @NonNull
    public Resource pivot2ecore(@NonNull Resource asResource, @NonNull URI uri) throws IOException {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        XMLResource ecoreResource = Pivot2Ecore.createResource(metaModelManager, asResource, uri, null);
        return ecoreResource;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
        if (this.environmentFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)this.environmentFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public void setModelManager(@Nullable DomainModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public void setParserRepairCount(int parserRepairCount) {
        if (parserRepairCount < 0) {
            throw new IllegalArgumentException("negative repair count");
        }
        this.parserRepairCount = parserRepairCount;
    }

    public void setParseTracingEnabled(boolean b) {
        this.traceParsing = b;
    }

    @NonNull
    public ASResource uml2pivot(@NonNull Resource umlResource) throws ParserException {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        UML2Pivot uml2Pivot = UML2Pivot.getAdapter(umlResource, metaModelManager);
        Root pivotRoot = uml2Pivot.getPivotRoot();
        ASResource asResource = (ASResource)pivotRoot.eResource();
        return (ASResource)DomainUtil.nonNullModel((Object)asResource);
    }

    public void validate(@NonNull OCLExpression expression) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }

    public void validate(@NonNull Constraint constraint) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }
}

