/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.delegate.DelegateInstaller;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreTypeRefVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreReferenceVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    private static final Logger logger = Logger.getLogger(Pivot2EcoreReferenceVisitor.class);
    @NonNull
    protected final Pivot2EcoreTypeRefVisitor typeRefVisitor;

    public Pivot2EcoreReferenceVisitor(@NonNull Pivot2Ecore context) {
        super(context);
        this.typeRefVisitor = new Pivot2EcoreTypeRefVisitor(context);
    }

    @Nullable
    protected OptionalType addPropertyRedefinitionEAnnotations(@NonNull EStructuralFeature eStructuralFeature, @NonNull Property pivotProperty) {
        OptionalType optionalType = null;
        Type redefiningType = pivotProperty.getType();
        EAnnotation eRedefinesAnnotation = null;
        String changedEType = null;
        String changedLower = null;
        String changedUpper = null;
        for (Property redefinedProperty : pivotProperty.getRedefinedProperty()) {
            Type redefinedType;
            EStructuralFeature eRedefined = ((Pivot2Ecore)this.context).getCreated(EStructuralFeature.class, redefinedProperty);
            if (eRedefined == null) continue;
            if (eRedefinesAnnotation == null) {
                eRedefinesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eRedefinesAnnotation.setSource("redefines");
                eStructuralFeature.getEAnnotations().add((Object)eRedefinesAnnotation);
            }
            eRedefinesAnnotation.getReferences().add((Object)eRedefined);
            IntegerValue redefinedLower = redefinedProperty.isRequired() ? ValuesUtil.ONE_VALUE : ValuesUtil.ZERO_VALUE;
            IntegerValue redefinedUpper = ValuesUtil.ONE_VALUE;
            Type redefinedElementType = redefinedType = redefinedProperty.getType();
            if (redefinedElementType instanceof CollectionType) {
                CollectionType redefinedCollectionType = (CollectionType)redefinedElementType;
                redefinedLower = redefinedCollectionType.getLowerValue();
                redefinedUpper = redefinedCollectionType.getUpperValue();
                redefinedElementType = redefinedCollectionType.getElementType();
            }
            IntegerValue redefiningLower = pivotProperty.isRequired() ? ValuesUtil.ONE_VALUE : ValuesUtil.ZERO_VALUE;
            IntegerValue redefiningUpper = ValuesUtil.ONE_VALUE;
            Type redefiningElementType = redefiningType;
            if (redefiningElementType instanceof CollectionType) {
                CollectionType redefiningCollectionType = (CollectionType)redefiningElementType;
                redefiningLower = redefiningCollectionType.getLowerValue();
                redefiningUpper = redefiningCollectionType.getUpperValue();
                redefiningElementType = redefiningCollectionType.getElementType();
            }
            if (!(redefinedType instanceof CollectionType) && redefinedElementType != redefiningElementType) {
                changedEType = redefiningElementType.toString();
            }
            if (!redefinedLower.equals(redefiningLower)) {
                changedLower = redefiningLower.toString();
            }
            if (!redefinedUpper.equals(redefiningUpper)) {
                String string = changedUpper = redefiningUpper.equals(ValuesUtil.UNLIMITED_VALUE) ? "-1" : redefiningUpper.toString();
            }
            if (redefiningType instanceof CollectionType) continue;
            if (!(redefinedType instanceof CollectionType)) {
                optionalType = new OptionalType(redefinedElementType, redefinedProperty.isRequired());
                continue;
            }
            if (redefiningType == null) continue;
            CollectionType redefinedCollectionType = (CollectionType)redefinedType;
            optionalType = new OptionalType(((Pivot2Ecore)this.context).getMetaModelManager().getCollectionType(redefinedCollectionType.isOrdered(), redefinedCollectionType.isUnique(), redefiningType, redefinedCollectionType.getLowerValue(), redefinedCollectionType.getUpperValue()), redefinedProperty.isRequired());
        }
        if (changedEType != null || changedLower != null || changedUpper != null) {
            EAnnotation eCorrection = EcoreFactory.eINSTANCE.createEAnnotation();
            eCorrection.setSource(eStructuralFeature.getName());
            EMap eDetails = eCorrection.getDetails();
            if (changedEType != null) {
                eDetails.put((Object)"eType", changedEType);
            }
            if (changedLower != null) {
                eDetails.put((Object)"lowerBound", changedLower);
            }
            if (changedUpper != null) {
                eDetails.put((Object)"upperBound", changedUpper);
            }
            EModelElement eContainer = (EModelElement)eStructuralFeature.eContainer();
            eContainer.getEAnnotations().add((Object)eCorrection);
        }
        return optionalType;
    }

    protected boolean addPropertyRenameEAnnotations(@NonNull EStructuralFeature eStructuralFeature, @NonNull Property pivotProperty) {
        for (Property redefinedProperty1 : pivotProperty.getRedefinedProperty()) {
            if (DomainUtil.safeEquals((Object)pivotProperty.getName(), (Object)redefinedProperty1.getName())) continue;
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("redefines");
            for (Property redefinedProperty2 : pivotProperty.getRedefinedProperty()) {
                EStructuralFeature eRedefined = ((Pivot2Ecore)this.context).getCreated(EStructuralFeature.class, redefinedProperty2);
                if (eRedefined == null) continue;
                eAnnotation.getReferences().add((Object)eRedefined);
            }
            eStructuralFeature.getEAnnotations().add((Object)eAnnotation);
            return true;
        }
        return false;
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    public <T extends EClassifier> void safeVisitAll(java.lang.Class<?> javaClass, List<EGenericType> eGenericTypes, List<T> eTypes, List<? extends Type> asTypes) {
        if (asTypes.size() > 0) {
            ArrayList eClasses = new ArrayList(asTypes.size());
            this.typeRefVisitor.safeVisitAll(eClasses, asTypes);
            eTypes.clear();
            eGenericTypes.clear();
            for (EObject superEClass : eClasses) {
                if (superEClass instanceof EGenericType) {
                    eGenericTypes.add((EGenericType)superEClass);
                    continue;
                }
                if (!javaClass.isAssignableFrom(superEClass.getClass())) continue;
                EClassifier castSuperEClass = (EClassifier)superEClass;
                eTypes.add(castSuperEClass);
            }
        } else {
            eGenericTypes.clear();
        }
    }

    protected void setEType(@NonNull ETypedElement eTypedElement, @NonNull Type pivotType) {
        EObject eObject = this.typeRefVisitor.safeVisit(pivotType);
        if (eObject instanceof EGenericType) {
            eTypedElement.setEGenericType((EGenericType)eObject);
        } else if (eObject instanceof EClassifier) {
            eTypedElement.setEType((EClassifier)eObject);
        } else if (eObject instanceof ETypeParameter) {
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter((ETypeParameter)eObject);
            eTypedElement.setEGenericType(eGenericType);
        } else {
            EObject eObject2 = this.typeRefVisitor.safeVisit(pivotType);
        }
    }

    protected void setETypeAndMultiplicity(@NonNull ETypedElement eTypedElement, @Nullable Type pivotType, boolean isRequired) {
        if (pivotType == null || pivotType instanceof VoidType) {
            eTypedElement.setLowerBound(0);
            eTypedElement.setUpperBound(1);
            eTypedElement.setOrdered(true);
            eTypedElement.setUnique(true);
        } else if (pivotType instanceof CollectionType && pivotType.getUnspecializedElement() != ((Pivot2Ecore)this.context).getMetaModelManager().getCollectionType()) {
            CollectionType collectionType = (CollectionType)pivotType;
            Type elementType = collectionType.getElementType();
            EObject eObject = this.typeRefVisitor.safeVisit(elementType);
            if (eObject instanceof EGenericType) {
                eTypedElement.setEGenericType((EGenericType)eObject);
            } else {
                eTypedElement.setEType((EClassifier)eObject);
            }
            eTypedElement.setOrdered(collectionType.isOrdered());
            eTypedElement.setUnique(collectionType.isUnique());
            IntegerValue lower = collectionType.getLowerValue();
            IntegerValue upper = collectionType.getUpperValue();
            try {
                eTypedElement.setLowerBound(lower.intValue());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Illegal lower bound", (Throwable)e);
            }
            try {
                eTypedElement.setUpperBound(upper.isUnlimited() ? -1 : upper.intValue());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Illegal upper bound", (Throwable)e);
            }
        } else {
            if (isRequired) {
                eTypedElement.setLowerBound(1);
                eTypedElement.setUpperBound(1);
            } else {
                eTypedElement.setLowerBound(0);
                eTypedElement.setUpperBound(1);
            }
            eTypedElement.setUnique(true);
            eTypedElement.setOrdered(true);
            this.setEType(eTypedElement, pivotType);
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Reference pass");
    }

    @Override
    public EObject visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation eAnnotation = ((Pivot2Ecore)this.context).getCreated(EAnnotation.class, pivotAnnotation);
        eAnnotation.getReferences().clear();
        for (Element pivotReference : pivotAnnotation.getReference()) {
            if (pivotReference == null) continue;
            EObject target = ((Pivot2Ecore)this.context).getCreated(EObject.class, pivotReference);
            if (target == null && pivotReference instanceof PivotObjectImpl) {
                target = ((PivotObjectImpl)((Object)pivotReference)).getTarget();
            }
            if (target == null) continue;
            eAnnotation.getReferences().add((Object)target);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        EClass eClass = ((Pivot2Ecore)this.context).getCreated(EClass.class, pivotClass);
        this.safeVisitAll(EClass.class, (List<EGenericType>)eClass.getEGenericSuperTypes(), (List)eClass.getESuperTypes(), (List<? extends Type>)pivotClass.getSuperClass());
        return eClass;
    }

    @Override
    public EObject visitConstraint(@NonNull Constraint pivotConstraint) {
        EOperation eOperation = ((Pivot2Ecore)this.context).getCreated(EOperation.class, pivotConstraint);
        EAnnotation eRedefinesAnnotation = null;
        for (Constraint redefinedConstraint : pivotConstraint.getRedefinedConstraint()) {
            EOperation eRedefined = ((Pivot2Ecore)this.context).getCreated(EOperation.class, redefinedConstraint);
            if (eRedefined == null) continue;
            if (eRedefinesAnnotation == null) {
                eRedefinesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eRedefinesAnnotation.setSource("redefines");
            }
            eRedefinesAnnotation.getReferences().add((Object)eRedefined);
        }
        if (eRedefinesAnnotation != null) {
            eOperation.getEAnnotations().add(eRedefinesAnnotation);
        }
        return eOperation;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        EDataType eDataType = ((Pivot2Ecore)this.context).getCreated(EDataType.class, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        EOperation eOperation = ((Pivot2Ecore)this.context).getCreated(EOperation.class, pivotOperation);
        this.safeVisitAll(EClassifier.class, (List<EGenericType>)eOperation.getEGenericExceptions(), (List)eOperation.getEExceptions(), (List<? extends Type>)pivotOperation.getRaisedException());
        EAnnotation eRedefinesAnnotation = null;
        for (Operation redefinedOperation : pivotOperation.getRedefinedOperation()) {
            EOperation eRedefined = ((Pivot2Ecore)this.context).getCreated(EOperation.class, redefinedOperation);
            if (eRedefined == null) continue;
            if (eRedefinesAnnotation == null) {
                eRedefinesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eRedefinesAnnotation.setSource("redefines");
            }
            eRedefinesAnnotation.getReferences().add((Object)eRedefined);
        }
        if (eRedefinesAnnotation != null) {
            eOperation.getEAnnotations().add(eRedefinesAnnotation);
        }
        return (EObject)super.visitOperation(pivotOperation);
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        EPackage ePackage = ((Pivot2Ecore)this.context).getCreated(EPackage.class, pivotPackage);
        if (ePackage == null) {
            return null;
        }
        boolean needsDelegates = DelegateInstaller.needsDelegates(ePackage);
        if (needsDelegates) {
            ((Pivot2Ecore)this.context).getDelegateInstaller().installDelegates(ePackage);
        }
        if (((Pivot2Ecore)this.context).isPivot(pivotPackage)) {
            DomainUtil.getMetamodelAnnotation((EPackage)ePackage);
        }
        return null;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        OptionalType optionalType;
        if (pivotProperty.isImplicit()) {
            return null;
        }
        EStructuralFeature eStructuralFeature = ((Pivot2Ecore)this.context).getCreated(EStructuralFeature.class, pivotProperty);
        if (eStructuralFeature == null) {
            return null;
        }
        if (eStructuralFeature instanceof EReference) {
            EReference eOpposite;
            EReference eReference = (EReference)eStructuralFeature;
            Property pivotOpposite = pivotProperty.getOpposite();
            if (pivotOpposite != null && !pivotOpposite.isImplicit() && (eOpposite = ((Pivot2Ecore)this.context).getCreated(EReference.class, pivotOpposite)) != null) {
                eReference.setEOpposite(eOpposite);
            }
            for (Property pivotKey : pivotProperty.getKeys()) {
                EAttribute eAttribute;
                if (pivotKey == null || (eAttribute = ((Pivot2Ecore)this.context).getCreated(EAttribute.class, pivotKey)) == null) continue;
                eReference.getEKeys().add((Object)eAttribute);
            }
        }
        Type pivotType = pivotProperty.getType();
        boolean pivotIsRequired = pivotProperty.isRequired();
        if (!this.addPropertyRenameEAnnotations(eStructuralFeature, pivotProperty) && (optionalType = this.addPropertyRedefinitionEAnnotations(eStructuralFeature, pivotProperty)) != null) {
            pivotType = optionalType.type;
            pivotIsRequired = optionalType.isRequired;
        }
        this.setETypeAndMultiplicity((ETypedElement)eStructuralFeature, pivotType, pivotIsRequired);
        return null;
    }

    @Override
    public EObject visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = ((Pivot2Ecore)this.context).getCreated(ETypeParameter.class, pivotTypeTemplateParameter);
        for (Type constrainingType : pivotTypeTemplateParameter.getConstrainingType()) {
            EGenericType eGenericType = this.typeRefVisitor.resolveEGenericType(constrainingType);
            eTypeParameter.getEBounds().add((Object)eGenericType);
        }
        return null;
    }

    @Override
    public EObject visitTypedElement(@NonNull TypedElement pivotTypedElement) {
        ETypedElement eTypedElement = ((Pivot2Ecore)this.context).getCreated(ETypedElement.class, pivotTypedElement);
        if (eTypedElement != null) {
            Type pivotType = pivotTypedElement.getType();
            if (pivotType == null) {
                return null;
            }
            this.setEType(eTypedElement, pivotType);
        }
        return null;
    }

    @Override
    public EObject visitTypedMultiplicityElement(@NonNull TypedMultiplicityElement pivotTypedElement) {
        ETypedElement eTypedElement = ((Pivot2Ecore)this.context).getCreated(ETypedElement.class, pivotTypedElement);
        if (eTypedElement != null) {
            Type pivotType = pivotTypedElement.getType();
            this.setETypeAndMultiplicity(eTypedElement, pivotType, pivotTypedElement.isRequired());
        }
        return null;
    }

    protected static class OptionalType {
        @Nullable
        public final Type type;
        public final boolean isRequired;

        public OptionalType(@Nullable Type type, boolean isRequired) {
            this.type = type;
            this.isRequired = isRequired;
        }
    }
}

