/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.AbstractBasicEnvironment;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationEnvironment
extends AbstractBasicEnvironment<EvaluationEnvironment>
implements EvaluationEnvironment {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final Map<DomainTypedElement, Object> variableValues = new HashMap<DomainTypedElement, Object>();

    protected AbstractEvaluationEnvironment(@NonNull MetaModelManager metaModelManager) {
        super(null);
        this.metaModelManager = metaModelManager;
    }

    protected AbstractEvaluationEnvironment(@NonNull EvaluationEnvironment parent) {
        super(parent);
        this.metaModelManager = parent.getMetaModelManager();
    }

    @Override
    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Override
    @Nullable
    public Object getValueOf(@NonNull DomainTypedElement referredVariable) {
        Object object = this.variableValues.get(referredVariable);
        if (object == null && !this.variableValues.containsKey(referredVariable)) {
            EvaluationEnvironment parent2 = (EvaluationEnvironment)this.parent;
            if (parent2 != null) {
                object = parent2.getValueOf(referredVariable);
            } else {
                throw new InvalidValueException("Undefined Variable " + referredVariable, new Object[0]);
            }
        }
        return object;
    }

    @Override
    @NonNull
    public Set<DomainTypedElement> getVariables() {
        return this.variableValues.keySet();
    }

    @Override
    public void replace(@NonNull DomainTypedElement referredVariable, @Nullable Object value) {
        this.variableValues.put(referredVariable, value);
    }

    @Override
    public void add(@NonNull DomainTypedElement referredVariable, @Nullable Object value) {
        Object oldValue;
        if (this.variableValues.containsKey(referredVariable) && (oldValue = this.variableValues.get(referredVariable)) != value && (oldValue == null || !oldValue.equals(value))) {
            String message = NLS.bind((String)OCLMessages.BindingExist_ERROR_, (Object)referredVariable, (Object)oldValue);
            throw new IllegalArgumentException(message);
        }
        this.variableValues.put(referredVariable, value);
    }

    @Override
    @Deprecated
    public Object remove(@NonNull DomainTypedElement referredVariable) {
        return this.variableValues.remove(referredVariable);
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }

    public String toString() {
        return this.variableValues.toString();
    }

    @Override
    @Deprecated
    public boolean overrides(@NonNull Operation operation, int opcode) {
        return this.getParent() != null ? ((EvaluationEnvironment)this.getParent()).overrides(operation, opcode) : false;
    }
}

