/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.LazyModelManager;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class PivotModelManager
extends LazyModelManager {
    private static final Logger logger = Logger.getLogger(PivotModelManager.class);
    @NonNull
    protected final MetaModelManager metaModelManager;
    private boolean generatedErrorMessage = false;

    public PivotModelManager(@NonNull MetaModelManager metaModelManager, EObject context) {
        super(context);
        this.metaModelManager = metaModelManager;
    }

    protected boolean isInstance(@NonNull DomainType requiredType, @NonNull EObject eObject) {
        Type objectType;
        block4: {
            EClass eClass = eObject.eClass();
            EPackage ePackage = eClass.getEPackage();
            objectType = null;
            if (ePackage == PivotPackage.eINSTANCE) {
                String name = (String)DomainUtil.nonNullEMF((Object)eClass.getName());
                objectType = this.metaModelManager.getPivotType(name);
            } else {
                try {
                    objectType = this.metaModelManager.getPivotOf(Type.class, (EObject)eClass);
                }
                catch (ParserException e) {
                    if (this.generatedErrorMessage) break block4;
                    this.generatedErrorMessage = true;
                    logger.error((Object)("Failed to load an '" + eClass.getName() + "'"), (Throwable)e);
                }
            }
        }
        return objectType != null && objectType.conformsTo((DomainStandardLibrary)this.metaModelManager, requiredType);
    }
}

