/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.library.UnsupportedOperation;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.library.BaseProperty;
import org.eclipse.ocl.examples.pivot.library.CompositionProperty;
import org.eclipse.ocl.examples.pivot.library.ConstrainedOperation;
import org.eclipse.ocl.examples.pivot.library.ConstrainedProperty;
import org.eclipse.ocl.examples.pivot.library.ExplicitNavigationProperty;
import org.eclipse.ocl.examples.pivot.library.ExtensionProperty;
import org.eclipse.ocl.examples.pivot.library.ImplicitNonCompositionProperty;
import org.eclipse.ocl.examples.pivot.library.StaticProperty;
import org.eclipse.ocl.examples.pivot.library.StereotypeProperty;
import org.eclipse.ocl.examples.pivot.library.TuplePartProperty;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationManager {
    private static final Logger logger = Logger.getLogger(ImplementationManager.class);
    @NonNull
    private static List<ExplicitNavigator> explicitNavigators = new ArrayList<ExplicitNavigator>();
    @NonNull
    protected final MetaModelManager metaModelManager;
    private List<ClassLoader> classLoaders = null;

    public static void addExplicitNavgator(@NonNull ExplicitNavigator explicitNavigator) {
        if (!explicitNavigators.contains(explicitNavigator)) {
            explicitNavigators.add(explicitNavigator);
        }
    }

    protected ImplementationManager(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void addClassLoader(@NonNull ClassLoader classLoader) {
        List<ClassLoader> classLoaders = this.getClassLoaders();
        if (!classLoaders.contains(classLoader)) {
            classLoaders.add(classLoader);
        }
    }

    @NonNull
    public List<ClassLoader> getClassLoaders() {
        List<ClassLoader> classLoaders2 = this.classLoaders;
        if (classLoaders2 == null) {
            classLoaders2 = this.classLoaders = new ArrayList<ClassLoader>();
            classLoaders2.add(this.metaModelManager.getClass().getClassLoader());
        }
        return classLoaders2;
    }

    @NonNull
    protected LibraryOperation getOperationImplementation(@NonNull Operation operation) {
        LibraryFeature implementation = operation.getImplementation();
        String implementationClassName = operation.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            try {
                implementation = this.loadImplementation(operation);
                if (implementation instanceof LibraryOperation) {
                    return (LibraryOperation)implementation;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load implementation of '" + operation + "'"), (Throwable)e);
            }
            return UnsupportedOperation.INSTANCE;
        }
        OpaqueExpression specification = this.metaModelManager.getBodyExpression(operation);
        if (specification instanceof ExpressionInOCL) {
            return new ConstrainedOperation((ExpressionInOCL)specification);
        }
        return UnsupportedOperation.INSTANCE;
    }

    @NonNull
    protected LibraryProperty getPropertyImplementation(@Nullable Object sourceValue, @NonNull Property property) {
        LibraryFeature implementation = property.getImplementation();
        String implementationClassName = property.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            try {
                implementation = this.loadImplementation(property);
                if (implementation instanceof LibraryProperty) {
                    return (LibraryProperty)implementation;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load implementation of '" + property + "'"), (Throwable)e);
            }
            return UnsupportedOperation.INSTANCE;
        }
        Type type = property.getType();
        if (type instanceof Stereotype && property.getName().startsWith("extension_")) {
            return new ExtensionProperty(property);
        }
        OpaqueExpression specification = this.metaModelManager.getDefaultExpression(property);
        if (property.isDerived() && specification != null) {
            return new ConstrainedProperty(property);
        }
        Property opposite = property.getOpposite();
        if (opposite != null && opposite.isComposite()) {
            if (property.eContainer() instanceof Stereotype) {
                return new BaseProperty(property);
            }
            if (type != null) {
                ASResource asResource;
                EReference eReference;
                Resource resource;
                EObject eTarget = opposite.getETarget();
                if (eTarget instanceof EReference) {
                    return new CompositionProperty((EReference)eTarget, opposite.getPropertyId());
                }
                if (eTarget != null && (resource = opposite.eResource()) instanceof ASResource && (eReference = (asResource = (ASResource)resource).getASResourceFactory().getEReference(asResource, eTarget)) != null) {
                    return new CompositionProperty(eReference, opposite.getPropertyId());
                }
            }
        }
        if (property.isImplicit()) {
            return new ImplicitNonCompositionProperty(property);
        }
        if (property.getOwningType() instanceof TupleType) {
            TupleType tupleType = (TupleType)property.getOwningType();
            String name = property.getName();
            assert (name != null);
            TuplePartId tuplePartId = tupleType.getTypeId().getPartId(name);
            assert (tuplePartId != null);
            return new TuplePartProperty(tuplePartId);
        }
        if (property.isStatic()) {
            return new StaticProperty(property);
        }
        if (property.getOwningType() instanceof ElementExtension || property.getOwningType() instanceof Stereotype) {
            return new StereotypeProperty(property);
        }
        for (ExplicitNavigator explicitNavigator : explicitNavigators) {
            LibraryProperty libraryProperty = explicitNavigator.getPropertyImplementation(sourceValue, property);
            if (libraryProperty == null) continue;
            return libraryProperty;
        }
        return new ExplicitNavigationProperty(property);
    }

    public void dispose() {
        this.classLoaders = null;
    }

    @Nullable
    public LibraryFeature loadImplementation(@NonNull Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String implementationClassName;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementationClassName = feature.getImplementationClass()) != null) {
            Class<?> theClass = null;
            ClassLoader featureClassLoader = feature.getClass().getClassLoader();
            if (featureClassLoader != null) {
                this.addClassLoader(featureClassLoader);
            }
            ClassNotFoundException e = null;
            for (ClassLoader classLoader : this.getClassLoaders()) {
                try {
                    theClass = classLoader.loadClass(implementationClassName);
                    e = null;
                    break;
                }
                catch (ClassNotFoundException e1) {
                    if (e != null) continue;
                    e = e1;
                }
            }
            if (e != null) {
                throw e;
            }
            if (theClass != null) {
                Field field = theClass.getField("INSTANCE");
                implementation = (LibraryFeature)field.get(null);
            }
        }
        return implementation;
    }

    public static interface ExplicitNavigator {
        @Nullable
        public LibraryProperty getPropertyImplementation(@Nullable Object var1, @NonNull Property var2);
    }
}

