/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.CollectionTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.FinalAnalysis;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaclassServer;
import org.eclipse.ocl.examples.pivot.manager.OrphanPackageServer;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.PackageServerParent;
import org.eclipse.ocl.examples.pivot.manager.PackageTracker;
import org.eclipse.ocl.examples.pivot.manager.PrimitiveTypeServer;
import org.eclipse.ocl.examples.pivot.manager.RootPackageServer;
import org.eclipse.ocl.examples.pivot.manager.RootTracker;
import org.eclipse.ocl.examples.pivot.manager.TemplateableTypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;
import org.eclipse.ocl.examples.pivot.utilities.IllegalMetamodelException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManager
implements PackageServerParent {
    private static final Logger logger = Logger.getLogger(PackageManager.class);
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final Map<String, RootPackageServer> packageServers = new HashMap<String, RootPackageServer>();
    @NonNull
    private final Set<RootTracker> rootTrackers = new HashSet<RootTracker>();
    @NonNull
    private final Map<String, PackageServer> uri2package = new HashMap<String, PackageServer>();
    @NonNull
    private final Map<String, String> synonymURI2sharedURI = new HashMap<String, String>();
    @NonNull
    private final Map<String, Set<String>> sharedURI2synonymURIs = new HashMap<String, Set<String>>();
    @NonNull
    private final Map<DomainPackage, PackageTracker> package2tracker = new HashMap<DomainPackage, PackageTracker>();
    @NonNull
    private final Map<DomainType, TypeTracker> type2tracker = new WeakHashMap<DomainType, TypeTracker>();
    @NonNull
    private final Map<String, PrimitiveTypeServer> primitiveType2server = new HashMap<String, PrimitiveTypeServer>();
    @Nullable
    private FinalAnalysis finalAnalysis = null;

    protected PackageManager(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    void addPackage(@NonNull PackageServerParent parentPackageServer, @NonNull DomainPackage pivotPackage) {
        PackageServer packageServer = null;
        String name = pivotPackage.getName();
        String nsURI = pivotPackage.getNsURI();
        if (nsURI != null) {
            packageServer = this.uri2package.get(nsURI);
        } else if (name != null) {
            packageServer = this.getMemberPackage(name);
        }
        if (packageServer == null) {
            packageServer = parentPackageServer.getMemberPackageServer(pivotPackage);
            packageServer.assertSamePackage(pivotPackage);
        }
        packageServer.addTrackedPackage(pivotPackage);
        for (DomainPackage nestedPackage : pivotPackage.getNestedPackage()) {
            if (nestedPackage == null) continue;
            this.addPackage(packageServer, nestedPackage);
        }
    }

    public void addPackageNsURISynonym(@NonNull String newURI, @NonNull String oldURI) {
        String sharedURI = this.synonymURI2sharedURI.get(newURI);
        if (oldURI.equals(sharedURI)) {
            return;
        }
        if (sharedURI != null) {
            throw new IllegalMetamodelException(oldURI, sharedURI);
        }
        if (this.sharedURI2synonymURIs.containsKey(newURI)) {
            throw new IllegalMetamodelException(newURI, sharedURI);
        }
        this.synonymURI2sharedURI.put(newURI, oldURI);
        Set<String> synonymURIs = this.sharedURI2synonymURIs.get(oldURI);
        if (synonymURIs == null) {
            synonymURIs = new HashSet<String>();
            this.sharedURI2synonymURIs.put(oldURI, synonymURIs);
        }
        synonymURIs.add(newURI);
    }

    void addPackageServer(@NonNull PackageServer packageServer) {
        String sharedNsURI;
        String nsURI = packageServer.getNsURI();
        PackageServer oldPackageServer = this.uri2package.put(nsURI, packageServer);
        if (packageServer instanceof RootPackageServer && (sharedNsURI = this.getSharedURI(nsURI)) != null && sharedNsURI == nsURI) {
            this.packageServers.put(nsURI, (RootPackageServer)packageServer);
        }
        assert (oldPackageServer == null);
    }

    void addPackageTracker(@NonNull DomainPackage pivotPackage, @NonNull PackageTracker packageTracker) {
        packageTracker.getPackageServer().assertSamePackage(pivotPackage);
        PackageTracker oldTracker = this.package2tracker.put(pivotPackage, packageTracker);
        assert (oldTracker == null);
    }

    public synchronized void addRoot(@NonNull Root pivotRoot) {
        for (Package package_ : pivotRoot.getNestedPackage()) {
            PackageId packageId;
            String nsURI = package_.getNsURI();
            String sharedURI = this.getSharedURI(nsURI);
            if (sharedURI != nsURI || (packageId = package_.getPackageId()) != IdManager.METAMODEL || nsURI == null) continue;
            this.addPackageNsURISynonym(nsURI, "$metamodel$");
        }
        this.rootTrackers.add(new RootTracker(this, pivotRoot));
        for (DomainPackage domainPackage : pivotRoot.getNestedPackage()) {
            if (domainPackage == null) continue;
            this.addPackage(this, domainPackage);
        }
    }

    void addTypeTracker(@NonNull DomainType pivotType, @NonNull TypeTracker typeTracker) {
        TypeTracker oldTracker = this.type2tracker.put(pivotType, typeTracker);
        assert (oldTracker == null);
    }

    public void addedMemberPackage(@NonNull DomainPackage pivotPackage) {
        RootPackageServer packageServer = this.getMemberPackageServer(pivotPackage);
        packageServer.addTrackedPackage(pivotPackage);
    }

    void addedNestedPrimaryPackage(@NonNull DomainPackage pivotPackage) {
        String nsURI = PivotUtil.getNsURI((DomainElement)pivotPackage);
        PackageServer primaryPackage = null;
        if (nsURI != null) {
            primaryPackage = this.getPackageByURI(nsURI);
        }
        if (primaryPackage != pivotPackage) {
            if (primaryPackage != null) {
                throw new IllegalArgumentException("Duplicate nsURI '" + nsURI + "'");
            }
            this.getPackageTracker(pivotPackage);
        }
    }

    @NonNull
    protected RootPackageServer createRootPackageServer(@NonNull DomainPackage pivotPackage) {
        RootPackageServer rootPackageServer;
        String name = pivotPackage.getName();
        String nonNullName = name;
        if (nonNullName == null) {
            nonNullName = "$anon_" + Integer.toHexString(System.identityHashCode(pivotPackage));
        }
        String nsPrefix = pivotPackage.getNsPrefix();
        String nsURI = this.getSharedURI(pivotPackage.getNsURI());
        PackageId packageId = pivotPackage.getPackageId();
        if (Orphanage.isTypeOrphanage(pivotPackage)) {
            rootPackageServer = new OrphanPackageServer(this, nonNullName, nsPrefix, nsURI, packageId);
        } else {
            PackageId metapackageId = this.metaModelManager.getMetapackageId(pivotPackage);
            rootPackageServer = new RootPackageServer(this, nonNullName, nsPrefix, nsURI, packageId, metapackageId);
        }
        if (name != null) {
            if (!this.packageServers.containsKey(name)) {
                PackageServer oldPackageServer = this.packageServers.put(name, rootPackageServer);
                assert (oldPackageServer == null);
            } else {
                this.packageServers.put(name, null);
            }
        }
        if (nsURI != null) {
            this.addPackageServer(rootPackageServer);
        }
        return rootPackageServer;
    }

    public synchronized void dispose() {
        if (!this.rootTrackers.isEmpty()) {
            ArrayList<RootTracker> savedRootTrackers = new ArrayList<RootTracker>(this.rootTrackers);
            this.rootTrackers.clear();
            for (RootTracker rootTracker : savedRootTrackers) {
                rootTracker.dispose();
            }
        }
        if (!this.package2tracker.isEmpty()) {
            ArrayList<PackageTracker> savedPackageTrackers = new ArrayList<PackageTracker>(this.package2tracker.values());
            this.package2tracker.clear();
            for (PackageTracker packageTracker : savedPackageTrackers) {
                packageTracker.dispose();
            }
        }
        if (!this.type2tracker.isEmpty()) {
            ArrayList<TypeTracker> savedTypeTrackers = new ArrayList<TypeTracker>(this.type2tracker.values());
            this.type2tracker.clear();
            for (TypeTracker typeTracker : savedTypeTrackers) {
                typeTracker.dispose();
            }
        }
        this.uri2package.clear();
        ArrayList<RootPackageServer> savedPackageServers = new ArrayList<RootPackageServer>(this.packageServers.values());
        this.packageServers.clear();
        for (RootPackageServer packageServer : savedPackageServers) {
            packageServer.dispose();
        }
    }

    public void disposedRootPackageServer(@NonNull RootPackageServer packageServer) {
        this.packageServers.remove(packageServer.getName());
        this.disposedPackageServer(packageServer.getNsURI());
    }

    void disposedPackageServer(@Nullable String nsURI) {
        if (nsURI != null) {
            this.uri2package.remove(nsURI);
            Set<String> synonymURIs = this.sharedURI2synonymURIs.remove(nsURI);
            if (synonymURIs != null) {
                for (String synonymURI : synonymURIs) {
                    this.synonymURI2sharedURI.remove(synonymURI);
                }
            }
        }
    }

    void disposedPackageTracker(@NonNull PackageTracker packageTracker) {
        if (!this.package2tracker.isEmpty()) {
            this.package2tracker.remove(packageTracker.getPackage());
        }
    }

    void disposedRootTracker(@NonNull RootTracker rootTracker) {
        this.rootTrackers.remove(rootTracker);
    }

    void disposedTypeTracker(@NonNull TypeTracker typeTracker) {
        this.type2tracker.remove(typeTracker.getTarget());
    }

    @Nullable
    PackageTracker findPackageTracker(@NonNull DomainPackage pivotPackage) {
        return this.package2tracker.get(pivotPackage);
    }

    @Nullable
    public ExtensibleTypeServer findTypeServer(@NonNull DomainType pivotType) {
        TypeTracker typeTracker = this.type2tracker.get(pivotType);
        return typeTracker != null ? typeTracker.getTypeServer() : null;
    }

    @Nullable
    private final TypeTracker findTypeTracker(@NonNull DomainType pivotType) {
        throw new UnsupportedOperationException("Not implemented since specializations have a TypeServer but no TypeTracker");
    }

    @NonNull
    public Iterable<PackageServer> getAllPackages() {
        return this.uri2package.values();
    }

    @NonNull
    public Iterable<PackageServer> getAllPackagesWithUris() {
        return this.uri2package.values();
    }

    @NonNull
    public FinalAnalysis getFinalAnalysis() {
        FinalAnalysis finalAnalysis2 = this.finalAnalysis;
        if (finalAnalysis2 == null) {
            this.finalAnalysis = finalAnalysis2 = new FinalAnalysis(this);
        }
        return finalAnalysis2;
    }

    @Nullable
    public RootPackageServer getMemberPackage(@NonNull String memberPackageName) {
        return this.packageServers.get(memberPackageName);
    }

    @Override
    @NonNull
    public RootPackageServer getMemberPackageServer(@NonNull DomainPackage pivotPackage) {
        RootPackageServer rootPackageServer;
        String sharedURI;
        PackageServer packageServer;
        String nsURI = pivotPackage.getNsURI();
        if (nsURI != null && (packageServer = this.uri2package.get(sharedURI = this.getSharedURI(nsURI))) != null) {
            return (RootPackageServer)packageServer;
        }
        String name = pivotPackage.getName();
        if (name == null) {
            String message = null;
            if (pivotPackage instanceof EObject) {
                EObject eObject = (EObject)pivotPackage;
                while (eObject != null) {
                    if (eObject instanceof Root) {
                        message = "Unnamed package for '" + nsURI + "' in '" + ((Root)eObject).getExternalURI() + "'";
                        break;
                    }
                    eObject = eObject.eContainer();
                }
            }
            if (message == null) {
                message = "Unnamed package for '" + nsURI + "'";
            }
            logger.error(message);
            name = nsURI;
            if (name == null) {
                throw new IllegalStateException(message);
            }
        }
        if ((rootPackageServer = this.packageServers.get(name)) != null) {
            String nsURI2 = rootPackageServer.getNsURI();
            if (nsURI == null || nsURI2 == null || nsURI.equals(nsURI2)) {
                return rootPackageServer;
            }
        }
        rootPackageServer = this.createRootPackageServer(pivotPackage);
        return rootPackageServer;
    }

    @NonNull
    public Iterable<RootPackageServer> getMemberPackages() {
        Collection<RootPackageServer> values = this.packageServers.values();
        return values;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Nullable
    public PackageServer getPackageByURI(@NonNull String nsURI) {
        int lastIndex = nsURI.lastIndexOf("#/");
        if (lastIndex > 0) {
            String substring;
            nsURI = substring = nsURI.substring(0, lastIndex);
        }
        String sharedURI = this.getSharedURI(nsURI);
        return this.uri2package.get(sharedURI);
    }

    @NonNull
    public PackageServer getPackageServer(@NonNull DomainPackage pivotPackage) {
        PackageServer packageServer = null;
        if (pivotPackage instanceof PackageServer) {
            ((PackageServer)pivotPackage).assertSamePackage(pivotPackage);
            packageServer = (PackageServer)pivotPackage;
        } else {
            String nsURI = pivotPackage.getNsURI();
            if (nsURI != null) {
                String sharedURI = this.getSharedURI(nsURI);
                packageServer = this.uri2package.get(sharedURI);
            }
            if (packageServer == null) {
                PackageServerParent packageServerParent;
                DomainPackage pivotPackageParent = pivotPackage.getNestingPackage();
                if (pivotPackageParent == null) {
                    packageServerParent = this;
                } else {
                    PackageTracker parentTracker = this.getPackageTracker(pivotPackageParent);
                    packageServerParent = parentTracker.getPackageServer();
                    ((PackageServer)packageServerParent).assertSamePackage(pivotPackageParent);
                }
                packageServer = packageServerParent.getMemberPackageServer(pivotPackage);
                packageServer.addTrackedPackage(pivotPackage);
                packageServer.assertSamePackage(pivotPackage);
            }
        }
        packageServer.assertSamePackage(pivotPackage);
        return packageServer;
    }

    @NonNull
    public PackageTracker getPackageTracker(@NonNull DomainPackage pivotPackage) {
        PackageTracker packageTracker = this.package2tracker.get(pivotPackage);
        if (packageTracker == null) {
            PackageServer packageServer;
            DomainPackage nestingPackage = pivotPackage.getNestingPackage();
            if (nestingPackage != null) {
                PackageServer nestingPackageServer = this.getPackageServer(nestingPackage);
                packageServer = nestingPackageServer.getMemberPackageServer(pivotPackage);
            } else {
                String sharedURI = this.getSharedURI(pivotPackage.getNsURI());
                packageServer = this.uri2package.get(sharedURI);
                if (packageServer == null) {
                    packageServer = this.createRootPackageServer(pivotPackage);
                }
            }
            packageServer.assertSamePackage(pivotPackage);
            packageTracker = packageServer.getPackageTracker(pivotPackage);
        } else {
            packageTracker.getPackageServer().assertSamePackage(pivotPackage);
        }
        return packageTracker;
    }

    @NonNull
    public PrimitiveTypeServer getPrimitiveTypeServer(@NonNull PrimitiveType primitiveType) {
        String name = primitiveType.getName();
        PrimitiveTypeServer primitiveTypeServer = this.primitiveType2server.get(name);
        if (primitiveTypeServer == null) {
            Package primitivePackage = primitiveType.getPackage();
            if (!(primitivePackage instanceof Library)) {
                AnyType oclAnyType = this.metaModelManager.getOclAnyType();
                primitivePackage = (Package)DomainUtil.nonNullState((Object)oclAnyType.getPackage());
            }
            PackageServer packageServer = this.getPackageServer(primitivePackage);
            primitiveTypeServer = new PrimitiveTypeServer(packageServer, primitiveType);
            this.primitiveType2server.put(name, primitiveTypeServer);
        }
        return primitiveTypeServer;
    }

    @Nullable
    public Package getRootPackage(@NonNull String name) {
        PackageServer packageServer = this.packageServers.get(name);
        return packageServer != null ? packageServer.getPivotPackage() : null;
    }

    @Nullable
    public String getSharedURI(@Nullable String nsURI) {
        String sharedURI = this.synonymURI2sharedURI.get(nsURI);
        if (sharedURI != null) {
            return sharedURI;
        }
        return nsURI;
    }

    @NonNull
    public TypeServer getTypeServer(@NonNull DomainType pivotType) {
        Stereotype stereotype;
        if (pivotType instanceof ElementExtension && (stereotype = ((ElementExtension)pivotType).getStereotype()) != null) {
            pivotType = stereotype;
        }
        if (pivotType instanceof TypeServer) {
            return (TypeServer)pivotType;
        }
        assert (this.metaModelManager.isTypeServeable(pivotType));
        TypeTracker typeTracker = this.type2tracker.get(pivotType);
        if (typeTracker != null) {
            return typeTracker.getTypeServer();
        }
        if (pivotType instanceof PrimitiveType) {
            PrimitiveTypeServer primitiveTypeServer = this.getPrimitiveTypeServer((PrimitiveType)pivotType);
            primitiveTypeServer.getTypeTracker(pivotType);
            return primitiveTypeServer;
        }
        DomainPackage pivotPackage = pivotType.getPackage();
        if (pivotPackage == null) {
            throw new IllegalStateException("type has no package");
        }
        PackageServer packageServer = this.getPackageServer(pivotPackage);
        return packageServer.getTypeServer(pivotType);
    }

    public synchronized void removeRoot(@NonNull Root pivotRoot) {
        for (RootTracker rootTracker : this.rootTrackers) {
            if (rootTracker.getTarget() != pivotRoot) continue;
            pivotRoot.getNestedPackage().clear();
            rootTracker.dispose();
            break;
        }
    }

    void removedPackage(@NonNull DomainPackage pivotPackage) {
        PackageTracker packageTracker = this.package2tracker.get(pivotPackage);
        if (packageTracker != null) {
            packageTracker.dispose();
        }
    }

    void removedType(@NonNull DomainType pivotType) {
        TypeTracker typeTracker = this.type2tracker.get(pivotType);
        if (typeTracker != null) {
            typeTracker.dispose();
        }
    }

    void resolveSuperClasses(@NonNull Type specializedClass, @NonNull Type unspecializedClass, Map<TemplateParameter, ParameterableElement> allBindings) {
        for (Type superType : unspecializedClass.getSuperClass()) {
            List superTemplateBindings = superType.getTemplateBinding();
            if (superTemplateBindings.size() > 0) {
                ParameterableElement templateArgument;
                ArrayList<ParameterableElement> superTemplateArgumentList = new ArrayList<ParameterableElement>();
                for (TemplateBinding superTemplateBinding : superTemplateBindings) {
                    for (TemplateParameterSubstitution superParameterSubstitution : superTemplateBinding.getParameterSubstitution()) {
                        ParameterableElement superActual = superParameterSubstitution.getActual();
                        TemplateParameter superTemplateParameter = superActual.getTemplateParameter();
                        ParameterableElement actualActual = allBindings.get(superTemplateParameter);
                        superTemplateArgumentList.add(actualActual);
                    }
                }
                Type unspecializedSuperType = PivotUtil.getUnspecializedTemplateableElement(superType);
                TypeServer superTypeServer = this.metaModelManager.getTypeServer(unspecializedSuperType);
                if (superTypeServer instanceof CollectionTypeServer && superTemplateArgumentList.size() == 1) {
                    templateArgument = (ParameterableElement)superTemplateArgumentList.get(0);
                    if (!(templateArgument instanceof Type)) continue;
                    Type specializedSuperType = ((CollectionTypeServer)superTypeServer).getSpecializedType((Type)templateArgument, null, null);
                    specializedClass.getSuperClass().add(specializedSuperType);
                    continue;
                }
                if (superTypeServer instanceof MetaclassServer && superTemplateArgumentList.size() == 1) {
                    templateArgument = (ParameterableElement)superTemplateArgumentList.get(0);
                    if (!(templateArgument instanceof Type)) continue;
                    Metaclass<?> superMetaclass = ((MetaclassServer)superTypeServer).getMetaclass((Type)templateArgument);
                    specializedClass.getSuperClass().add(superMetaclass);
                    continue;
                }
                if (!(superTypeServer instanceof TemplateableTypeServer)) continue;
                Type specializedSuperType = ((TemplateableTypeServer)superTypeServer).getSpecializedType(superTemplateArgumentList);
                specializedClass.getSuperClass().add(specializedSuperType);
                continue;
            }
            specializedClass.getSuperClass().add(superType);
        }
    }
}

