/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;

public class UMLElementExtension
extends DynamicEObjectImpl
implements Adapter.Internal {
    @NonNull
    protected final Element umlElement;
    @NonNull
    protected final org.eclipse.uml2.uml.Stereotype umlDynamicStereotype;
    @NonNull
    protected final org.eclipse.uml2.uml.Stereotype umlStaticStereotype;

    @Nullable
    public static Object getUMLElementExtension(@NonNull Stereotype staticType, @NonNull Element umlElement) {
        EObject eTarget = staticType.getETarget();
        if (eTarget instanceof org.eclipse.uml2.uml.Stereotype) {
            org.eclipse.uml2.uml.Stereotype umlDynamicStereotype = null;
            org.eclipse.uml2.uml.Stereotype umlStaticStereotype = (org.eclipse.uml2.uml.Stereotype)eTarget;
            for (org.eclipse.uml2.uml.Stereotype appliedStereotype : umlElement.getAppliedStereotypes()) {
                if (!appliedStereotype.conformsTo((Type)umlStaticStereotype)) continue;
                if (umlDynamicStereotype != null) {
                    throw new InvalidValueException("Ambiguous applied stereotype " + umlStaticStereotype, new Object[0]);
                }
                umlDynamicStereotype = appliedStereotype;
            }
            if (umlDynamicStereotype == null) {
                return null;
            }
            UMLElementExtension umlElementExtension = null;
            for (Adapter adapter : umlElement.eAdapters()) {
                UMLElementExtension extensionsAdapter;
                if (!(adapter instanceof UMLElementExtension) || (extensionsAdapter = (UMLElementExtension)adapter).getDynamicStereotype() != umlDynamicStereotype) continue;
                umlElementExtension = extensionsAdapter;
                break;
            }
            if (umlElementExtension == null) {
                umlElementExtension = new UMLElementExtension(umlElement, umlDynamicStereotype, umlStaticStereotype);
            }
            return umlElementExtension;
        }
        throw new InvalidValueException("Unable to resolve stereotype " + staticType, new Object[0]);
    }

    public UMLElementExtension(@NonNull Element umlElement, @NonNull org.eclipse.uml2.uml.Stereotype umlDynamicStereotype, @NonNull org.eclipse.uml2.uml.Stereotype umlStaticStereotype) {
        this.umlElement = umlElement;
        this.umlDynamicStereotype = umlDynamicStereotype;
        this.umlStaticStereotype = umlStaticStereotype;
        umlElement.eAdapters().add((Object)this);
    }

    @NonNull
    public org.eclipse.uml2.uml.Stereotype getDynamicStereotype() {
        return this.umlDynamicStereotype;
    }

    @NonNull
    public org.eclipse.uml2.uml.Stereotype getStaticStereotype() {
        return this.umlStaticStereotype;
    }

    @NonNull
    public Element getTarget() {
        return this.umlElement;
    }

    public Object getValue(IdResolver idResolver, @NonNull Property property) {
        Object value = this.umlElement.getValue(this.umlDynamicStereotype, property.getName());
        if (property.isMany()) {
            if (value instanceof List) {
                return idResolver.createCollectionOfAll((CollectionTypeId)property.getTypeId(), (Iterable)((List)value));
            }
            throw new InvalidValueException("List value required for " + property, new Object[0]);
        }
        return idResolver.boxedValueOf(value);
    }

    public boolean isAdapterForType(Object type) {
        return type == this.umlDynamicStereotype;
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.umlElement);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.umlElement instanceof NamedElement) {
            s.append(((NamedElement)this.umlElement).getName());
        } else {
            s.append("(");
            s.append(this.umlElement.eClass().getName());
            s.append(")");
        }
        s.append("\u00ab");
        s.append(this.umlDynamicStereotype.getName());
        if (this.umlDynamicStereotype != this.umlStaticStereotype) {
            s.append("(");
            s.append(this.umlStaticStereotype.getName());
            s.append(")");
        }
        s.append("\u00bb");
        return s.toString();
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.umlElement);
    }
}

