/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.AbstractMetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.PivotExecutorManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.NullAttribution;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotUtil
extends DomainUtil {
    private static final Logger logger = Logger.getLogger(PivotUtil.class);

    public static void appendMultiplicity(@NonNull StringBuilder s, long lower, long upper) {
        if (upper < 0L) {
            if (lower == 0L) {
                s.append("[*]");
            } else if (lower == 1L) {
                s.append("[+]");
            } else {
                s.append("[" + lower + "..*]");
            }
        } else if (upper == 1L) {
            if (lower == 0L) {
                s.append("[?]");
            }
        } else if (upper == lower) {
            s.append("[" + lower + "]");
        } else {
            s.append("[" + lower + ".." + upper + "]");
        }
    }

    public static void checkExpression(@NonNull ExpressionInOCL expressionInOCL) {
        OCLExpression bodyExpression;
        Variable contextVariable = expressionInOCL.getContextVariable();
        if (contextVariable == null && (bodyExpression = expressionInOCL.getBodyExpression()) instanceof StringLiteralExp) {
            throw new InvalidValueException(((StringLiteralExp)bodyExpression).getStringSymbol(), new Object[0]);
        }
    }

    public static void checkResourceErrors(@NonNull String message, @NonNull Resource resource) throws ParserException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            throw new SemanticException(PivotUtil.formatResourceDiagnostics((List)DomainUtil.nonNullEMF((Object)resource.getErrors()), message, "\n"));
        }
    }

    public static boolean conformsTo(@Nullable EStructuralFeature eStructuralFeature, @NonNull EClassifier contentType) {
        if (eStructuralFeature == null) {
            return true;
        }
        EClassifier targetType = eStructuralFeature.getEType();
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return PivotUtil.conformsTo(targetType, contentType);
    }

    public static boolean conformsTo(@Nullable EClassifier targetType, @NonNull EClassifier contentType) {
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return ((EClass)targetType).isSuperTypeOf((EClass)contentType);
    }

    @Deprecated
    @NonNull
    public static String convertFromOCLString(@NonNull String javaString) {
        return DomainUtil.convertFromOCLString((String)javaString);
    }

    @Deprecated
    public static String convertToOCLString(String theString) {
        return DomainUtil.convertToOCLString((String)theString);
    }

    @NonNull
    public static ExpressionInOCL createExpressionInOCLError(@NonNull String string) {
        ExpressionInOCL expressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        StringLiteralExp stringLiteral = PivotFactory.eINSTANCE.createStringLiteralExp();
        stringLiteral.setStringSymbol(string);
        expressionInOCL.setBodyExpression(stringLiteral);
        expressionInOCL.setType(stringLiteral.getType());
        return expressionInOCL;
    }

    @NonNull
    public static String createTupleValuedConstraint(@NonNull String statusText, @Nullable Integer severity, @Nullable String messageText) {
        if (severity == null && messageText == null) {
            return statusText;
        }
        StringBuilder s = new StringBuilder();
        s.append("Tuple {");
        if (messageText != null) {
            s.append("\n\tmessage : String = " + messageText + ",");
        }
        if (severity != null) {
            s.append("\n\tseverity : Integer = " + severity + ",");
        }
        s.append("\n\tstatus : Boolean = " + statusText);
        s.append("\n}.status");
        String string = s.toString();
        return string;
    }

    public static void debugObjectUsage(String prefix, EObject element) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        if (element != null) {
            s.append(element.eClass().getName());
            s.append("@");
            s.append(Integer.toHexString(element.hashCode()));
            Resource eResource = element.eResource();
            if (eResource != null) {
                if (element instanceof Element) {
                    s.append(" ");
                    s.append(AS2Moniker.toString((Element)element));
                }
                s.append(" ");
                s.append(eResource.getURI());
            } else if (element instanceof NamedElement) {
                s.append(" ");
                s.append(String.valueOf(((NamedElement)element).getName()));
            }
        } else {
            s.append("null");
        }
        System.out.println(s.toString());
    }

    public static boolean debugWellContainedness(Type type) {
        Type elementType;
        if (type.eResource() == null) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        if (type instanceof CollectionType && (elementType = ((CollectionType)type).getElementType()) != null && !PivotUtil.debugWellContainedness(elementType)) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        return true;
    }

    @Nullable
    public static MetaModelManager findMetaModelManager(@NonNull EObject eObject) {
        Resource resource;
        EObject eRoot = EcoreUtil.getRootContainer((EObject)eObject);
        if (eRoot != null && (resource = eRoot.eResource()) != null) {
            AbstractMetaModelManagerResourceAdapter<?> adapter = AbstractMetaModelManagerResourceAdapter.findAdapter(resource);
            if (adapter != null) {
                return adapter.getMetaModelManager();
            }
            return PivotUtil.findMetaModelManager(resource);
        }
        return null;
    }

    @Nullable
    public static MetaModelManager findMetaModelManager(@NonNull Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof AbstractMetaModelManagerResourceAdapter)) continue;
            return ((AbstractMetaModelManagerResourceAdapter)adapter).getMetaModelManager();
        }
        ResourceSet resourceSet = resource.getResourceSet();
        return resourceSet != null ? PivotUtil.findMetaModelManager(resourceSet) : null;
    }

    public static MetaModelManager findMetaModelManager(@NonNull ResourceSet resourceSet) {
        MetaModelManager metaModelManager = MetaModelManager.findAdapter(resourceSet);
        if (metaModelManager != null) {
            return metaModelManager;
        }
        MetaModelManagerResourceSetAdapter adapter = MetaModelManagerResourceSetAdapter.findAdapter(resourceSet);
        if (adapter != null) {
            return adapter.getMetaModelManager();
        }
        return null;
    }

    public static Type findTypeOf(@NonNull MetaModelManager metaModelManager, @NonNull EClassifier eClass) {
        Type type;
        Ecore2Pivot adapter;
        Resource resource = eClass.eResource();
        if (resource != null && (adapter = Ecore2Pivot.findAdapter(resource, metaModelManager)) != null && (type = adapter.getCreated(Type.class, (EObject)eClass)) != null) {
            return type;
        }
        return null;
    }

    public static String formatDiagnostics(@NonNull Diagnostic diagnostic, @NonNull String newLine) {
        StringBuilder s = new StringBuilder();
        PivotUtil.formatDiagnostic(s, diagnostic, newLine);
        return s.toString();
    }

    private static void formatDiagnostic(@NonNull StringBuilder s, @NonNull Diagnostic diagnostic, @NonNull String newLine) {
        if (diagnostic.getSeverity() != 0) {
            s.append(newLine);
            s.append(String.valueOf(diagnostic.getSeverity()) + " - ");
            String location = diagnostic.getSource();
            if (location != null) {
                s.append(location);
                s.append(": ");
            }
            s.append(diagnostic.getMessage());
            for (Object obj : diagnostic.getData()) {
                s.append(newLine);
                s.append("\t");
                s.append(obj);
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic == null) continue;
                PivotUtil.formatDiagnostic(s, childDiagnostic, String.valueOf(newLine) + "\t");
            }
        }
    }

    public static String formatResourceDiagnostics(@NonNull List<Resource.Diagnostic> diagnostics, @NonNull String messagePrefix, @NonNull String newLine) {
        if (diagnostics.size() <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(messagePrefix);
        for (Resource.Diagnostic diagnostic : diagnostics) {
            s.append(newLine);
            String location = diagnostic.getLocation();
            if (location != null) {
                s.append(location);
                s.append(":");
            }
            s.append(diagnostic.getLine());
            try {
                int column = diagnostic.getColumn();
                if (column >= 0) {
                    s.append(":");
                    s.append(column);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            s.append(": ");
            s.append(diagnostic.getMessage());
        }
        return s.toString();
    }

    public static <T> T getAdapter(@NonNull Class<T> adapterClass, @NonNull Notifier notifier) {
        List eAdapters = (List)DomainUtil.nonNullEMF((Object)notifier.eAdapters());
        return PivotUtil.getAdapter(adapterClass, eAdapters);
    }

    @NonNull
    public static URI getASURI(@NonNull URI uri) {
        URI asURI;
        if (uri.fragment() != null) {
            logger.error((Object)("Unexpected fragment ignored for '" + uri.toString() + "'"));
            uri = uri.trimFragment();
        }
        if (!PivotUtil.isASURI(asURI = uri.appendFileExtension("oclas"))) {
            asURI = uri.appendSegment(".oclas");
        }
        assert (PivotUtil.isASURI(asURI));
        return asURI;
    }

    public static <T> T getAdapter(@NonNull Class<T> adapterClass, @NonNull List<Adapter> eAdapters) {
        Adapter adapter = EcoreUtil.getAdapter(eAdapters, adapterClass);
        if (adapter == null) {
            return null;
        }
        if (!adapterClass.isAssignableFrom(adapter.getClass())) {
            throw new ClassCastException(String.valueOf(adapter.getClass().getName()) + " is not assignable to " + adapterClass.getName());
        }
        Adapter castAdapter = adapter;
        return (T)castAdapter;
    }

    public static List<TemplateParameter> getAllTemplateParameters(Collection<TemplateBinding> templateBindings) {
        List<TemplateParameter> list = null;
        for (TemplateBinding templateBinding : templateBindings) {
            List<TemplateParameter> templateParameters;
            TemplateSignature templateSignature = templateBinding.getSignature();
            if (templateSignature == null || (templateParameters = templateSignature.getOwnedParameter()).size() <= 0) continue;
            if (list == null) {
                list = new ArrayList<TemplateParameter>();
            }
            list.addAll(templateParameters);
        }
        return list != null ? list : Collections.emptyList();
    }

    public static List<List<TemplateParameter>> getAllTemplateParameterLists(EObject eObject) {
        List<List<TemplateParameter>> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParameterLists(eContainer);
        }
        if (eObject instanceof TemplateableElement) {
            List<TemplateParameter> templateParameters;
            TemplateSignature templateSignature;
            TemplateableElement unspecializedTemplateableElement = (TemplateableElement)eObject;
            if (eObject instanceof Type) {
                eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
            }
            if ((templateSignature = unspecializedTemplateableElement.getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getOwnedParameter()).size() > 0) {
                if (result == null) {
                    result = new ArrayList<List<TemplateParameter>>();
                }
                result.add(templateParameters);
            }
        }
        return result;
    }

    public static List<TemplateParameter> getAllTemplateParameters(EObject eObject) {
        List<TemplateParameter> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParameters(eContainer);
        }
        if (eObject instanceof TemplateableElement) {
            List<TemplateParameter> templateParameters;
            TemplateSignature templateSignature;
            TemplateableElement unspecializedTemplateableElement = (TemplateableElement)eObject;
            if (eObject instanceof Type) {
                eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
            }
            if ((templateSignature = unspecializedTemplateableElement.getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getOwnedParameter()).size() > 0) {
                if (result == null) {
                    result = new ArrayList<TemplateParameter>();
                }
                result.addAll(templateParameters);
            }
        }
        return result;
    }

    @Nullable
    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParametersAsBindings(@NonNull EObject eObject) {
        List<TemplateParameter> templateParameters;
        TemplateSignature templateSignature;
        if (eObject instanceof Type) {
            eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
        }
        Map<TemplateParameter, ParameterableElement> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParametersAsBindings(eContainer);
        }
        if (eObject instanceof TemplateableElement && (templateSignature = ((TemplateableElement)eObject).getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getOwnedParameter()).size() > 0) {
            if (result == null) {
                result = new HashMap<TemplateParameter, ParameterableElement>();
            }
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                result.put(templateParameter, null);
            }
        }
        return result;
    }

    @Nullable
    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParameterSubstitutions(@Nullable Map<TemplateParameter, ParameterableElement> map, @Nullable TemplateableElement templateableElement) {
        TemplateableElement eObject = templateableElement;
        while (eObject != null) {
            if (eObject instanceof TemplateableElement) {
                for (TemplateBinding templateBinding : eObject.getTemplateBinding()) {
                    for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                        if (map == null) {
                            map = new HashMap<TemplateParameter, ParameterableElement>();
                        }
                        map.put(templateParameterSubstitution.getFormal(), templateParameterSubstitution.getActual());
                    }
                }
            }
            if (eObject instanceof Type) {
                for (Type superType : ((Type)eObject).getSuperClass()) {
                    map = PivotUtil.getAllTemplateParameterSubstitutions(map, superType);
                }
            }
            eObject = eObject.eContainer();
        }
        return map;
    }

    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParameterSubstitutions(Map<TemplateParameter, ParameterableElement> bindings, Type argumentType, LambdaType lambdaType) {
        TemplateParameter resultTemplateParameter;
        Type resultType = lambdaType.getResultType();
        if (resultType != null && (resultTemplateParameter = resultType.getOwningTemplateParameter()) != null) {
            if (bindings == null) {
                bindings = new HashMap<TemplateParameter, ParameterableElement>();
            }
            bindings.put(resultTemplateParameter, argumentType);
        }
        return bindings;
    }

    @NonNull
    public static Attribution getAttribution(@NonNull EObject eObject) {
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getAttribution for proxy " + eObject));
            return NullAttribution.INSTANCE;
        }
        EClass eClass = eObject.eClass();
        Attribution attribution = Attribution.REGISTRY.get(eClass);
        if (attribution == null) {
            EClass superClass = eClass;
            while (superClass.getESuperTypes().size() > 0) {
                attribution = Attribution.REGISTRY.get(superClass = (EClass)superClass.getESuperTypes().get(0));
                if (attribution != null) break;
            }
            if (attribution == null) {
                attribution = NullAttribution.INSTANCE;
            }
            Attribution.REGISTRY.put((EClassifier)eClass, attribution);
        }
        return attribution;
    }

    @Deprecated
    @NonNull
    public static Type getBehavioralType(@NonNull Type type) {
        DataType dataType;
        Type behavioralType;
        if (type instanceof DataType && (behavioralType = (dataType = (DataType)type).getBehavioralType()) != null) {
            return behavioralType;
        }
        return type;
    }

    @Deprecated
    @NonNull
    public static Type getBehavioralType(@NonNull TypedElement element) {
        return PivotUtil.getBehavioralType((Type)DomainUtil.nonNullState((Object)element.getType()));
    }

    public static String getBody(OpaqueExpression specification) {
        List<String> bodies = specification.getBody();
        List<String> languages = specification.getLanguage();
        if (bodies == null || languages == null) {
            return null;
        }
        int iMax = Math.min(bodies.size(), languages.size());
        int i = 0;
        while (i < iMax) {
            if ("OCL".equalsIgnoreCase(languages.get(i))) {
                return bodies.get(i);
            }
            ++i;
        }
        return null;
    }

    @NonNull
    public static String getBodyExpression(@NonNull String umlBody) {
        String s = umlBody.trim();
        if (s.startsWith("result") && (s = s.substring(6).trim()).startsWith("=")) {
            if ((s = s.substring(1).trim()).startsWith("(") && s.endsWith(")")) {
                s = s.substring(1, s.length() - 1);
            }
            return s;
        }
        return umlBody;
    }

    public static CollectionKind getCollectionKind(CollectionType collectionType) {
        if (collectionType instanceof OrderedSetType) {
            return CollectionKind.ORDERED_SET;
        }
        if (collectionType instanceof SequenceType) {
            return CollectionKind.SEQUENCE;
        }
        if (collectionType instanceof SetType) {
            return CollectionKind.SET;
        }
        if (collectionType instanceof BagType) {
            return CollectionKind.BAG;
        }
        return CollectionKind.COLLECTION;
    }

    @Nullable
    public static Constraint getContainingConstraint(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof Constraint) {
                return (Constraint)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static ExpressionInOCL getContainingExpressionInOCL(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof ExpressionInOCL) {
                return (ExpressionInOCL)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Namespace getContainingNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Namespace) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Package getContainingPackage(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Root getContainingRoot(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Root) {
                return (Root)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Type getContainingType(@Nullable EObject element) {
        if (element != null) {
            EObject eObject = element;
            while (true) {
                if (eObject instanceof Type) {
                    return (Type)eObject;
                }
                EObject eContainer = eObject.eContainer();
                if (eContainer == null) {
                    if (!(eObject instanceof ExpressionInOCL)) break;
                    return ((ExpressionInOCL)eObject).getContextVariable().getType();
                }
                eObject = eContainer;
            }
        }
        return null;
    }

    public static int getContainmentDepth(EObject eObject) {
        int depth = 0;
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (++depth > 100000) {
                return depth;
            }
            eContainer = eContainer.eContainer();
        }
        return depth;
    }

    @NonNull
    public static DomainEvaluator getEvaluator(@NonNull EObject eObject) {
        MetaModelManager metaModelManager;
        Resource asResource = eObject.eResource();
        if (asResource != null && (metaModelManager = PivotUtil.findMetaModelManager(asResource)) != null) {
            return new PivotExecutorManager(metaModelManager, eObject);
        }
        return new EcoreExecutorManager((Object)eObject, PivotTables.LIBRARY);
    }

    @Deprecated
    @Nullable
    public static ExpressionInOCL getExpressionInOCL(@NonNull NamedElement contextElement, @NonNull OpaqueExpression specification) {
        return PivotUtil.getExpressionInOCL(specification);
    }

    @Deprecated
    @Nullable
    public static ExpressionInOCL getExpressionInOCL(@NonNull OpaqueExpression specification) {
        if (specification instanceof ExpressionInOCL) {
            return (ExpressionInOCL)specification;
        }
        String expression = PivotUtil.getBody(specification);
        return expression != null ? PivotUtil.getExpressionInOCL((NamedElement)specification, expression) : null;
    }

    @Nullable
    public static ExpressionInOCL getExpressionInOCL(@NonNull MetaModelManager metaModelManager, @NonNull OpaqueExpression specification) {
        if (specification instanceof ExpressionInOCL) {
            return (ExpressionInOCL)specification;
        }
        String expression = PivotUtil.getBody(specification);
        return expression != null ? PivotUtil.getExpressionInOCL(metaModelManager, specification, expression) : null;
    }

    @Deprecated
    @Nullable
    public static ExpressionInOCL getExpressionInOCL(@NonNull NamedElement contextElement, @NonNull String expression) {
        MetaModelManager metaModelManager;
        Resource resource = contextElement.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null) {
            metaModelManager = MetaModelManager.getAdapter(resourceSet);
        } else {
            MetaModelManagerResourceAdapter adapter = MetaModelManagerResourceAdapter.getAdapter(resource, null);
            metaModelManager = adapter.getMetaModelManager();
        }
        return PivotUtil.getExpressionInOCL(metaModelManager, contextElement, expression);
    }

    public static ExpressionInOCL getExpressionInOCL(@NonNull MetaModelManager metaModelManager, @NonNull NamedElement contextElement, @NonNull String expression) {
        ParserContext parserContext = metaModelManager.getParserContext(contextElement, new Object[0]);
        if (parserContext == null) {
            logger.error((Object)("Unknown context type for " + contextElement.eClass().getName()));
            return null;
        }
        ExpressionInOCL expressionInOCL = null;
        try {
            expressionInOCL = parserContext.parse(contextElement, expression);
        }
        catch (ParserException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            logger.error((Object)message);
            return PivotUtil.createExpressionInOCLError(message);
        }
        return expressionInOCL;
    }

    @Deprecated
    public static <T extends DomainNamedElement> T getNamedElement(Iterable<T> elements, String name) {
        return (T)((DomainNamedElement)DomainUtil.getNamedElement(elements, (String)name));
    }

    @NonNull
    public static Type getOwningType(@NonNull Feature feature) {
        Type owner = null;
        if (feature instanceof Property) {
            owner = ((Property)feature).getOwningType();
        } else if (feature instanceof Operation) {
            owner = ((Operation)feature).getOwningType();
        } else {
            throw new IllegalStateException("Unknown feature " + feature.eClass().getName());
        }
        if (owner == null) {
            throw new IllegalStateException("Orphan feature " + feature.eClass().getName());
        }
        return owner;
    }

    @Nullable
    public static Package getPackage(@NonNull EObject object) {
        EObject eObject = object;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @NonNull
    public static Element getLowerBound(@NonNull Element element) {
        Type lowerBound;
        if (element instanceof UnspecifiedType && (lowerBound = ((UnspecifiedType)element).getLowerBound()) != null) {
            return lowerBound;
        }
        return element;
    }

    @Deprecated
    @Nullable
    public static String getMessage(@NonNull OpaqueExpression specification) {
        return null;
    }

    @NonNull
    public static MetaModelManager getMetaModelManager(@NonNull Resource resource) {
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager(resource);
        if (metaModelManager == null) {
            MetaModelManagerResourceAdapter adapter = MetaModelManagerResourceAdapter.getAdapter(resource, null);
            metaModelManager = adapter.getMetaModelManager();
            assert (metaModelManager != null);
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && PivotUtil.findMetaModelManager(resourceSet) == null) {
                MetaModelManagerResourceSetAdapter.getAdapter(resourceSet, metaModelManager);
            }
        }
        return metaModelManager;
    }

    @Nullable
    public static Namespace getNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Root) {
                return null;
            }
            if (eObject instanceof Type) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Package) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @NonNull
    public static URI getNonASURI(@NonNull URI uri) {
        assert (PivotUtil.isASURI(uri));
        return uri.trimFileExtension();
    }

    @NonNull
    public static <T extends Element> T getNonNullAst(@NonNull Class<T> pivotClass, @NonNull Pivotable pivotableElement) {
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            throw new IllegalStateException("Null pivotElementfor a " + pivotClass.getName());
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    @Deprecated
    @NonNull
    public static URI getNonPivotURI(@NonNull URI uri) {
        return PivotUtil.getNonASURI(uri);
    }

    public static String getNsURI(@NonNull EModelElement element) {
        String nsURI;
        if (element instanceof EPackage && (nsURI = ((EPackage)element).getNsURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        PivotUtil.getNsURI(s, (EObject)element);
        return s.toString();
    }

    public static String getNsURI(@NonNull DomainElement element) {
        String nsURI;
        if (element instanceof DomainPackage && (nsURI = ((DomainPackage)element).getNsURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        s.append("u_r_i:");
        if (element instanceof Element) {
            PivotUtil.getNsURI(s, (Element)element);
        } else {
            s.append(element.hashCode());
        }
        return s.toString();
    }

    private static void getNsURI(@NonNull StringBuilder s, @NonNull EObject element) {
        String nsURI;
        EObject eContainer;
        String nsURI2;
        if (element instanceof Package) {
            nsURI2 = ((Package)element).getNsURI();
            if (nsURI2 != null) {
                s.append(nsURI2);
                return;
            }
        } else if (element instanceof Root) {
            nsURI2 = ((Root)element).getExternalURI();
            if (nsURI2 != null) {
                s.append(nsURI2);
                return;
            }
        } else if (element instanceof EPackage && (nsURI2 = ((EPackage)element).getNsURI()) != null) {
            s.append(nsURI2);
            return;
        }
        if ((eContainer = element.eContainer()) instanceof Package || eContainer instanceof Root) {
            nsURI = ((Package)element).getNsURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                EObject eContainer2 = eContainer;
                PivotUtil.getNsURI(s, eContainer2);
            }
        } else if (eContainer instanceof EPackage) {
            nsURI = ((EPackage)element).getNsURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                PivotUtil.getNsURI(s, eContainer);
            }
        } else {
            if (eContainer == null) {
                String name = null;
                if (element instanceof Package) {
                    name = ((Package)element).getName();
                } else if (element instanceof EPackage) {
                    name = ((EPackage)element).getName();
                }
                if (name == null) {
                    name = "$null$";
                }
                s.append(name);
                return;
            }
            PivotUtil.getNsURI(s, eContainer);
        }
        EReference eFeature = element.eContainmentFeature();
        s.append("@");
        s.append(eFeature.getName());
        if (eFeature.isMany()) {
            int index = ((List)eContainer.eGet(element.eContainingFeature())).indexOf(element);
            s.append(".");
            s.append(index);
        }
    }

    @Nullable
    public static <T extends Element> T getPivot(@NonNull Class<T> pivotClass, @Nullable Pivotable pivotableElement) {
        if (pivotableElement == null) {
            return null;
        }
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    @Deprecated
    @NonNull
    public static URI getPivotURI(@NonNull URI uri) {
        return PivotUtil.getASURI(uri);
    }

    public static Feature getReferredFeature(CallExp callExp) {
        Feature feature = null;
        if (callExp instanceof LoopExp) {
            feature = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            feature = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof OppositePropertyCallExp) {
            Property referredOppositeProperty = ((OppositePropertyCallExp)callExp).getReferredProperty();
            feature = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        } else if (callExp instanceof PropertyCallExp) {
            feature = ((PropertyCallExp)callExp).getReferredProperty();
        }
        return feature;
    }

    public static Operation getReferredOperation(CallExp callExp) {
        Operation operation = null;
        if (callExp instanceof LoopExp) {
            operation = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            operation = ((OperationCallExp)callExp).getReferredOperation();
        }
        return operation;
    }

    public static List<TemplateParameter> getTemplateParameters(TemplateableElement templateableElement) {
        TemplateSignature ownedTemplateSignature;
        if (templateableElement != null && (ownedTemplateSignature = templateableElement.getOwnedTemplateSignature()) != null) {
            return ownedTemplateSignature.getOwnedParameter();
        }
        return Collections.emptyList();
    }

    public static String getStereotype(@NonNull Constraint object) {
        EStructuralFeature eContainingFeature = object.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.TYPE__OWNED_INVARIANT) {
            return "invariant";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
            return "body";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__POSTCONDITION) {
            return "postcondition";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__PRECONDITION) {
            return "precondition";
        }
        if (eContainingFeature == PivotPackage.Literals.PROPERTY__DEFAULT_EXPRESSION) {
            return "derivation";
        }
        return "";
    }

    public static List<ParameterableElement> getTemplateParameterables(TemplateableElement templateableElement) {
        if (templateableElement == null) {
            return Collections.emptyList();
        }
        TemplateSignature ownedTemplateSignature = templateableElement.getOwnedTemplateSignature();
        if (ownedTemplateSignature == null) {
            return Collections.emptyList();
        }
        List<TemplateParameter> templateParameters = ownedTemplateSignature.getOwnedParameter();
        if (templateParameters.size() == 0) {
            return Collections.emptyList();
        }
        if (templateParameters.size() == 1) {
            return Collections.singletonList(templateParameters.get(0).getParameteredElement());
        }
        ArrayList<ParameterableElement> results = new ArrayList<ParameterableElement>(templateParameters.size());
        for (TemplateParameter templateParameter : templateParameters) {
            results.add(templateParameter.getParameteredElement());
        }
        return results;
    }

    @Nullable
    public static Type getType(@Nullable TypedElement typedElement) {
        Type selfType;
        Operation operation;
        if (typedElement == null) {
            return null;
        }
        Type type = typedElement.getType();
        if (type == null) {
            return null;
        }
        if ((type = PivotUtil.getType(type)) instanceof SelfType && typedElement instanceof Parameter && (operation = ((Parameter)typedElement).getOperation()) != null && (selfType = operation.getOwningType()) != null) {
            type = selfType;
        }
        return type;
    }

    @NonNull
    public static Type getType(@NonNull Type type) {
        Type behavioralType;
        if (type instanceof LambdaType) {
            Type resultType = ((LambdaType)type).getResultType();
            if (resultType != null) {
                type = resultType;
            }
        } else if (type instanceof DataType && (behavioralType = ((DataType)type).getBehavioralType()) != null) {
            type = behavioralType;
        }
        return type;
    }

    @NonNull
    public static List<Type> getTypeTemplateParameterables(@NonNull TemplateableElement templateableElement) {
        TemplateSignature ownedTemplateSignature = templateableElement.getOwnedTemplateSignature();
        if (ownedTemplateSignature == null) {
            return MetaModelManager.EMPTY_TYPE_LIST;
        }
        List<TemplateParameter> templateParameters = ownedTemplateSignature.getOwnedParameter();
        if (templateParameters.size() == 0) {
            return MetaModelManager.EMPTY_TYPE_LIST;
        }
        if (templateParameters.size() == 1) {
            TemplateParameter templateParameter = templateParameters.get(0);
            if (templateParameter == null) {
                return MetaModelManager.EMPTY_TYPE_LIST;
            }
            ParameterableElement parameteredElement = templateParameter.getParameteredElement();
            if (!(parameteredElement instanceof Type)) {
                return MetaModelManager.EMPTY_TYPE_LIST;
            }
            List<Type> singletonList = Collections.singletonList((Type)parameteredElement);
            return singletonList;
        }
        ArrayList<Type> results = new ArrayList<Type>(templateParameters.size());
        for (TemplateParameter templateParameter : templateParameters) {
            results.add((Type)templateParameter.getParameteredElement());
        }
        return results;
    }

    @NonNull
    public static <T extends TemplateableElement> T getUnspecializedTemplateableElement(@NonNull T templateableElement) {
        TemplateableElement unspecializedElement = templateableElement.getUnspecializedElement();
        if (unspecializedElement == null) {
            return templateableElement;
        }
        TemplateableElement castUnspecializedElement = unspecializedElement;
        return (T)castUnspecializedElement;
    }

    @NonNull
    public static ExpressionInOCL getValidExpressionInOCL(@NonNull NamedElement contextElement, @NonNull String expression) throws ParserException {
        Resource resource = contextElement.eResource();
        if (resource == null) {
            throw new ParserException("No containing resource for " + contextElement);
        }
        ResourceSet resourceSet = (ResourceSet)DomainUtil.nonNullState((Object)resource.getResourceSet());
        MetaModelManager metaModelManager = MetaModelManager.getAdapter(resourceSet);
        ParserContext parserContext = metaModelManager.getParserContext(contextElement, new Object[0]);
        if (parserContext == null) {
            throw new ParserException("Unknown context type for " + contextElement.eClass().getName());
        }
        Type classContext = parserContext.getClassContext();
        ExpressionInOCL expressionInOCL = parserContext.parse(classContext, expression);
        return expressionInOCL;
    }

    public static boolean isASURI(@Nullable String uri) {
        return uri != null && uri.endsWith("as");
    }

    public static boolean isASURI(@Nullable URI uri) {
        return uri != null && PivotUtil.isASURI(uri.toString());
    }

    public static boolean isLibraryType(@NonNull Type type) {
        if (type instanceof LambdaType) {
            return false;
        }
        if (type instanceof TupleType) {
            return false;
        }
        return type.getTemplateBinding().isEmpty();
    }

    @Deprecated
    public static boolean isPivotURI(@NonNull URI uri) {
        return PivotUtil.isASURI(uri);
    }

    public static boolean isValidIdentifier(@Nullable String value) {
        if (value == null) {
            return false;
        }
        int iMax = value.length();
        int i = 0;
        while (i < iMax) {
            char c = value.charAt(i);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_' || '0' <= c && c <= '9' && i > 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T extends EObject> void refreshList(@Nullable List<? super T> oldElements, @Nullable List<? extends T> newElements) {
        if (oldElements == null) {
            return;
        }
        if (newElements == null) {
            if (oldElements.size() > 0) {
                oldElements.clear();
            }
            return;
        }
        int k = newElements.size();
        while (k-- > 0) {
            EObject newElement = (EObject)newElements.get(k);
            if (!newElement.eIsProxy()) continue;
            oldElements.remove(newElement);
        }
        k = oldElements.size();
        while (k-- > 0) {
            T oldElement = oldElements.get(k);
            if (newElements.contains(oldElement)) continue;
            oldElements.remove(k);
        }
        int newMax = newElements.size();
        int i = 0;
        while (i < newMax) {
            EObject newElement = (EObject)newElements.get(i);
            int oldMax = oldElements.size();
            boolean reused = false;
            int j = i;
            while (j < oldMax) {
                T oldElement = oldElements.get(j);
                if (oldElement == newElement) {
                    if (j != i) {
                        oldElements.remove(j);
                        oldElements.add(i, newElement);
                    }
                    reused = true;
                    break;
                }
                ++j;
            }
            if (!reused) {
                if (i < oldMax) {
                    oldElements.add(i, newElement);
                } else {
                    oldElements.add(newElement);
                }
            }
            assert (newElements.get(i) == oldElements.get(i));
            ++i;
        }
        int k2 = oldElements.size();
        while (k2 > newMax) {
            oldElements.remove(--k2);
        }
        assert (newElements.size() == oldElements.size());
    }

    public static <T extends EObject> void refreshSet(@Nullable List<? super T> oldElements, @Nullable Collection<? extends T> newElements) {
        if (oldElements == null) {
            return;
        }
        if (newElements == null) {
            oldElements.clear();
            return;
        }
        int i = oldElements.size();
        while (i-- > 0) {
            T oldElement = oldElements.get(i);
            if (newElements.contains(oldElement)) continue;
            oldElements.remove(i);
        }
        for (EObject newElement : newElements) {
            if (newElement.eIsProxy() || oldElements.contains(newElement)) continue;
            oldElements.add(newElement);
        }
    }

    public static void resetContainer(@NonNull EObject eObject) {
        EObject eContainer;
        EStructuralFeature eContainingFeature = eObject.eContainingFeature();
        if (eContainingFeature != null && (eContainer = eObject.eContainer()) != null) {
            if (!eContainingFeature.isMany()) {
                eContainer.eSet(eContainingFeature, null);
            } else {
                Object objects = eContainer.eGet(eContainingFeature);
                if (objects instanceof List) {
                    ((List)objects).remove(eObject);
                }
            }
        }
    }

    public static void setBody(@NonNull ExpressionInOCL expressionInOCL, @Nullable OCLExpression oclExpression, @Nullable String stringExpression) {
        PivotUtil.setBody(expressionInOCL, stringExpression);
        expressionInOCL.setBodyExpression(oclExpression);
    }

    public static void setBody(@NonNull OpaqueExpression opaqueExpression, @Nullable String stringExpression) {
        opaqueExpression.getBody().clear();
        opaqueExpression.getLanguage().clear();
        if (stringExpression != null) {
            opaqueExpression.getBody().add(stringExpression);
            opaqueExpression.getLanguage().add("OCL");
        }
    }

    @Deprecated
    public static void setMessage(@NonNull ExpressionInOCL expressionInOCL, @Nullable OCLExpression oclExpression, @Nullable String stringExpression) {
    }

    public static boolean setParserContext(@NonNull BaseResource resource, @NonNull EObject eObject, Object ... todoParameters) throws ParserException {
        Element pivotElement;
        MetaModelManager metaModelManager;
        AbstractMetaModelManagerResourceAdapter<?> adapter = MetaModelManagerResourceAdapter.findAdapter(resource);
        MetaModelManager metaModelManager2 = metaModelManager = adapter != null ? adapter.getMetaModelManager() : null;
        if (metaModelManager == null) {
            ResourceSet resourceSet = (ResourceSet)DomainUtil.nonNullState((Object)resource.getResourceSet());
            metaModelManager = MetaModelManager.getAdapter(resourceSet);
        }
        if (eObject instanceof Element) {
            pivotElement = (Element)eObject;
        } else {
            pivotElement = metaModelManager.getPivotOf(Element.class, eObject);
            if (eObject instanceof org.eclipse.uml2.uml.Constraint && pivotElement instanceof Constraint && pivotElement.eContainer() == null) {
                pivotElement = metaModelManager.getPivotOf(Element.class, (EObject)((org.eclipse.uml2.uml.Constraint)eObject).getSpecification());
            }
        }
        if (pivotElement == null) {
            return false;
        }
        ParserContext parserContext = metaModelManager.getParserContext(pivotElement, todoParameters);
        if (parserContext == null) {
            return false;
        }
        resource.setParserContext(parserContext);
        return true;
    }

    @Deprecated
    public static char toHex(int nibble) {
        return DomainUtil.toHex((int)nibble);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrecedenceComparator
    implements Comparator<Precedence> {
        public static final PrecedenceComparator INSTANCE = new PrecedenceComparator();

        @Override
        public int compare(Precedence p1, Precedence p2) {
            int o1 = p1 != null ? p1.getOrder().intValue() : -1;
            int o2 = p2 != null ? p2.getOrder().intValue() : -1;
            return o1 - o2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateParameterSubstitutionComparator
    implements Comparator<TemplateParameterSubstitution> {
        public static Comparator<? super TemplateParameterSubstitution> INSTANCE = new TemplateParameterSubstitutionComparator();

        @Override
        public int compare(TemplateParameterSubstitution o1, TemplateParameterSubstitution o2) {
            TemplateParameter f1 = o1.getFormal();
            TemplateParameter f2 = o2.getFormal();
            int i1 = f1.getSignature().getOwnedParameter().indexOf(f1);
            int i2 = f2.getSignature().getOwnedParameter().indexOf(f2);
            return i1 - i2;
        }
    }
}

